<?php

/** 
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExamApplicableLocation is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam_applicable_location".
 *
 * The followings are the available columns in table 'entrance_exam_applicable_location':
 * @property integer $entrance_applicable_location_id
 * @property integer $entrance_exam_ref_id
 * @property integer $country_ref_id
 * @property integer $state_ref_id
 * @property integer $uni_ref_id
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property EntranceExam $entranceExamRef
 * @property TblAdmin $addedBy
 * @property TblCountryMaster $countryRef
 * @property TblAdmin $modifiedBy
 * @property TblState $stateRef
 * @property TblUniversityMaster $uniRef
 */
class BaseEntranceExamApplicableLocation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EntranceExamApplicableLocation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam_applicable_location';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_exam_ref_id, added_by', 'required'),
			array('entrance_exam_ref_id, country_ref_id, state_ref_id, uni_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_applicable_location_id, entrance_exam_ref_id, country_ref_id, state_ref_id, uni_ref_id, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'stateRef' => array(self::BELONGS_TO, 'TblState', 'state_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_applicable_location_id' => 'Entrance Applicable Location',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'country_ref_id' => 'Country Ref',
			'state_ref_id' => 'State Ref',
			'uni_ref_id' => 'Uni Ref',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_applicable_location_id',$this->entrance_applicable_location_id);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('state_ref_id',$this->state_ref_id);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}