<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExamApplicable is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam_applicable".
 *
 * The followings are the available columns in table 'entrance_exam_applicable':
 * @property string $entrance_exam_id
 * @property integer $entrance_ref_id
 * @property integer $maindept_ref_id
 * @property integer $subdept_ref_id
 * @property integer $state_ref_id
 * @property integer $country_ref_id
 * @property integer $uni_ref_id
 * @property string $added_on
 * @property string $added_by
 */
class BaseEntranceExamApplicable extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EntranceExamApplicable the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam_applicable';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_ref_id, maindept_ref_id, subdept_ref_id', 'required'),
			array('entrance_ref_id, maindept_ref_id, subdept_ref_id, state_ref_id, country_ref_id, uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('added_by', 'length', 'max'=>45),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_exam_id, entrance_ref_id, maindept_ref_id, subdept_ref_id, state_ref_id, country_ref_id, uni_ref_id, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_exam_id' => 'Entrance Exam',
			'entrance_ref_id' => 'Entrance Ref',
			'maindept_ref_id' => 'Maindept Ref',
			'subdept_ref_id' => 'Subdept Ref',
			'state_ref_id' => 'State Ref',
			'country_ref_id' => 'Country Ref',
			'uni_ref_id' => 'Uni Ref',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_exam_id',$this->entrance_exam_id,true);
		$criteria->compare('entrance_ref_id',$this->entrance_ref_id);
		$criteria->compare('maindept_ref_id',$this->maindept_ref_id);
		$criteria->compare('subdept_ref_id',$this->subdept_ref_id);
		$criteria->compare('state_ref_id',$this->state_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}