<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEngagementEmailsUniversities is autogenerate by UniModel generator
 *
 * This is the model class for table "engagement_emails_universities".
 *
 * The followings are the available columns in table 'engagement_emails_universities':
 * @property string $engagement_emails_universities_id
 * @property string $user_ref_id
 * @property integer $uni_ref_id
 * @property string $engagement_emails_ref_id
 * @property string $email_message_ref_id
 * @property string $link_opened_on
 * @property string $mail_type
 *
 * The followings are the available model relations:
 * @property EngagementEmails $engagementEmailsRef
 * @property EmailMessage $emailMessageRef
 * @property TblUniversityMaster $uniRef
 * @property TblUserMaster $userRef
 */
class BaseEngagementEmailsUniversities extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EngagementEmailsUniversities the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'engagement_emails_universities';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, uni_ref_id, email_message_ref_id, mail_type', 'required'),
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, engagement_emails_ref_id, email_message_ref_id', 'length', 'max'=>10),
			array('mail_type', 'length', 'max'=>20),
			array('link_opened_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('engagement_emails_universities_id, user_ref_id, uni_ref_id, engagement_emails_ref_id, email_message_ref_id, link_opened_on, mail_type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'engagementEmailsRef' => array(self::BELONGS_TO, 'EngagementEmails', 'engagement_emails_ref_id'),
			'emailMessageRef' => array(self::BELONGS_TO, 'EmailMessage', 'email_message_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'engagement_emails_universities_id' => 'Engagement Emails Universities',
			'user_ref_id' => 'User Ref',
			'uni_ref_id' => 'Uni Ref',
			'engagement_emails_ref_id' => 'Engagement Emails Ref',
			'email_message_ref_id' => 'Email Message Ref',
			'link_opened_on' => 'Link Opened On',
			'mail_type' => 'Mail Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('engagement_emails_universities_id',$this->engagement_emails_universities_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('engagement_emails_ref_id',$this->engagement_emails_ref_id,true);
		$criteria->compare('email_message_ref_id',$this->email_message_ref_id,true);
		$criteria->compare('link_opened_on',$this->link_opened_on,true);
		$criteria->compare('mail_type',$this->mail_type,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}