<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEngagementEmailsTests is autogenerate by UniModel generator
 *
 * This is the model class for table "engagement_emails_tests".
 *
 * The followings are the available columns in table 'engagement_emails_tests':
 * @property string $engagement_emails_tests_id
 * @property string $user_ref_id
 * @property string $engagement_emails_ref_id
 * @property integer $exam_ref_id
 * @property string $email_message_ref_id
 * @property string $sent_on
 * @property string $opened_on
 * @property string $link_opened_on
 * @property string $mail_type
 *
 * The followings are the available model relations:
 * @property EngagementEmails $engagementEmailsRef
 * @property EntranceExam $examRef
 * @property EmailMessage $emailMessageRef
 * @property TblUserMaster $userRef
 */
class BaseEngagementEmailsTests extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EngagementEmailsTests the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'engagement_emails_tests';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, exam_ref_id', 'required'),
			array('exam_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, engagement_emails_ref_id, email_message_ref_id', 'length', 'max'=>10),
			array('mail_type', 'length', 'max'=>20),
			array('sent_on, opened_on, link_opened_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('engagement_emails_tests_id, user_ref_id, engagement_emails_ref_id, exam_ref_id, email_message_ref_id, sent_on, opened_on, link_opened_on, mail_type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'engagementEmailsRef' => array(self::BELONGS_TO, 'EngagementEmails', 'engagement_emails_ref_id'),
			'examRef' => array(self::BELONGS_TO, 'EntranceExam', 'exam_ref_id'),
			'emailMessageRef' => array(self::BELONGS_TO, 'EmailMessage', 'email_message_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'engagement_emails_tests_id' => 'Engagement Emails Tests',
			'user_ref_id' => 'User Ref',
			'engagement_emails_ref_id' => 'Engagement Emails Ref',
			'exam_ref_id' => 'Exam Ref',
			'email_message_ref_id' => 'Email Message Ref',
			'sent_on' => 'Sent On',
			'opened_on' => 'Opened On',
			'link_opened_on' => 'Link Opened On',
			'mail_type' => 'Mail Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('engagement_emails_tests_id',$this->engagement_emails_tests_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('engagement_emails_ref_id',$this->engagement_emails_ref_id,true);
		$criteria->compare('exam_ref_id',$this->exam_ref_id);
		$criteria->compare('email_message_ref_id',$this->email_message_ref_id,true);
		$criteria->compare('sent_on',$this->sent_on,true);
		$criteria->compare('opened_on',$this->opened_on,true);
		$criteria->compare('link_opened_on',$this->link_opened_on,true);
		$criteria->compare('mail_type',$this->mail_type,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}