<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEngagementEmailsEvents is autogenerate by UniModel generator
 *
 * This is the model class for table "engagement_emails_events".
 *
 * The followings are the available columns in table 'engagement_emails_events':
 * @property string $engagement_emails_events_id
 * @property string $engagement_emails_ref_id
 * @property string $user_ref_id
 * @property integer $event_ref_id
 * @property string $message_ref_id
 * @property string $link_opened_on
 *
 * The followings are the available model relations:
 * @property EngagementEmails $engagementEmailsRef
 * @property TblEvent $eventRef
 * @property EmailMessage $messageRef
 * @property TblUserMaster $userRef
 */
class BaseEngagementEmailsEvents extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EngagementEmailsEvents the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'engagement_emails_events';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_ref_id, message_ref_id', 'required'),
			array('event_ref_id', 'numerical', 'integerOnly'=>true),
			array('engagement_emails_ref_id, user_ref_id, message_ref_id', 'length', 'max'=>10),
			array('link_opened_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('engagement_emails_events_id, engagement_emails_ref_id, user_ref_id, event_ref_id, message_ref_id, link_opened_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'engagementEmailsRef' => array(self::BELONGS_TO, 'EngagementEmails', 'engagement_emails_ref_id'),
			'eventRef' => array(self::BELONGS_TO, 'TblEvent', 'event_ref_id'),
			'messageRef' => array(self::BELONGS_TO, 'EmailMessage', 'message_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'engagement_emails_events_id' => 'Engagement Emails Events',
			'engagement_emails_ref_id' => 'Engagement Emails Ref',
			'user_ref_id' => 'User Ref',
			'event_ref_id' => 'Event Ref',
			'message_ref_id' => 'Message Ref',
			'link_opened_on' => 'Link Opened On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('engagement_emails_events_id',$this->engagement_emails_events_id,true);
		$criteria->compare('engagement_emails_ref_id',$this->engagement_emails_ref_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('event_ref_id',$this->event_ref_id);
		$criteria->compare('message_ref_id',$this->message_ref_id,true);
		$criteria->compare('link_opened_on',$this->link_opened_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}