<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailMessage is autogenerate by UniModel generator
 *
 * This is the model class for table "email_message".
 *
 * The followings are the available columns in table 'email_message':
 * @property string $email_message_id
 * @property string $email_type_ref_id
 * @property string $email_campaign_ref_id
 * @property string $subject
 * @property string $body
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property EmailAttachment[] $emailAttachments
 * @property EmailCampaign $emailCampaignRef
 * @property EmailType $emailTypeRef
 * @property EmailRecipient[] $emailRecipients
 */
class BaseEmailMessage extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailMessage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'email_message';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('email_type_ref_id', 'required'),
			array('added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('email_type_ref_id, email_campaign_ref_id', 'length', 'max'=>10),
			array('subject', 'length', 'max'=>255),
			array('body, added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('email_message_id, email_type_ref_id, email_campaign_ref_id, subject, body, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emailAttachments' => array(self::HAS_MANY, 'EmailAttachment', 'email_message_ref_id'),
			'emailCampaignRef' => array(self::BELONGS_TO, 'EmailCampaign', 'email_campaign_ref_id'),
			'emailTypeRef' => array(self::BELONGS_TO, 'EmailType', 'email_type_ref_id'),
			'emailRecipients' => array(self::HAS_MANY, 'EmailRecipient', 'email_message_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'email_message_id' => 'Email Message',
			'email_type_ref_id' => 'Email Type Ref',
			'email_campaign_ref_id' => 'Email Campaign Ref',
			'subject' => 'Subject',
			'body' => 'Body',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('email_message_id',$this->email_message_id,true);
		$criteria->compare('email_type_ref_id',$this->email_type_ref_id,true);
		$criteria->compare('email_campaign_ref_id',$this->email_campaign_ref_id,true);
		$criteria->compare('subject',$this->subject,true);
		$criteria->compare('body',$this->body,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}