<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailCampaign is autogenerate by UniModel generator
 *
 * This is the model class for table "email_campaign".
 *
 * The followings are the available columns in table 'email_campaign':
 * @property string $email_campaign_id
 * @property string $email_type_ref_id
 * @property string $name
 * @property string $added_on
 * @property integer $added_by
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property EmailType $emailTypeRef
 * @property EmailMessage[] $emailMessages
 */
class BaseEmailCampaign extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailCampaign the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'email_campaign';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('email_type_ref_id, name', 'required'),
			array('added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('email_type_ref_id', 'length', 'max'=>10),
			array('name', 'length', 'max'=>100),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('email_campaign_id, email_type_ref_id, name, added_on, added_by, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emailTypeRef' => array(self::BELONGS_TO, 'EmailType', 'email_type_ref_id'),
			'emailMessages' => array(self::HAS_MANY, 'EmailMessage', 'email_campaign_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'email_campaign_id' => 'Email Campaign',
			'email_type_ref_id' => 'Email Type Ref',
			'name' => 'Name',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('email_campaign_id',$this->email_campaign_id,true);
		$criteria->compare('email_type_ref_id',$this->email_type_ref_id,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}