<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiUserEoiSms is autogenerate by UniModel generator
 *
 * This is the model class for table "di_user_eoi_sms".
 *
 * The followings are the available columns in table 'di_user_eoi_sms':
 * @property integer $di_user_eoi_sms_id
 * @property string $user_ref_id
 * @property string $di_user_eoi_log_ref_id
 * @property string $number
 * @property integer $day
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property DiUserEoiLog $diUserEoiLogRef
 * @property TblUserMaster $userRef
 */
class BaseDiUserEoiSms extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiUserEoiSms the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_user_eoi_sms';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, di_user_eoi_log_ref_id, number, day', 'required'),
			array('day', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, di_user_eoi_log_ref_id', 'length', 'max'=>10),
			array('number', 'length', 'max'=>20),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_user_eoi_sms_id, user_ref_id, di_user_eoi_log_ref_id, number, day, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diUserEoiLogRef' => array(self::BELONGS_TO, 'DiUserEoiLog', 'di_user_eoi_log_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_user_eoi_sms_id' => 'Di User Eoi Sms',
			'user_ref_id' => 'User Ref',
			'di_user_eoi_log_ref_id' => 'Di User Eoi Log Ref',
			'number' => 'Number',
			'day' => 'Day',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_user_eoi_sms_id',$this->di_user_eoi_sms_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('di_user_eoi_log_ref_id',$this->di_user_eoi_log_ref_id,true);
		$criteria->compare('number',$this->number,true);
		$criteria->compare('day',$this->day);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}