<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiUserCriteriaGrade is autogenerate by UniModel generator
 *
 * This is the model class for table "di_user_criteria_grade".
 *
 * The followings are the available columns in table 'di_user_criteria_grade':
 * @property integer $di_user_criteria_grade_id
 * @property string $di_user_criteria_ref_id
 * @property integer $grade_ref_id
 * @property integer $min_grade_count
 * @property integer $max_grade_count
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property DiUserCriteria $diUserCriteriaRef
 * @property LookupGrade $gradeRef
 * @property LoginMaster $modifiedBy
 */
class BaseDiUserCriteriaGrade extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiUserCriteriaGrade the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_user_criteria_grade';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_user_criteria_ref_id, grade_ref_id, added_on, added_by', 'required'),
			array('grade_ref_id, min_grade_count, max_grade_count', 'numerical', 'integerOnly'=>true),
			array('di_user_criteria_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_user_criteria_grade_id, di_user_criteria_ref_id, grade_ref_id, min_grade_count, max_grade_count, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'diUserCriteriaRef' => array(self::BELONGS_TO, 'DiUserCriteria', 'di_user_criteria_ref_id'),
			'gradeRef' => array(self::BELONGS_TO, 'LookupGrade', 'grade_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_user_criteria_grade_id' => 'Di User Criteria Grade',
			'di_user_criteria_ref_id' => 'Di User Criteria Ref',
			'grade_ref_id' => 'Grade Ref',
			'min_grade_count' => 'Min Grade Count',
			'max_grade_count' => 'Max Grade Count',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_user_criteria_grade_id',$this->di_user_criteria_grade_id);
		$criteria->compare('di_user_criteria_ref_id',$this->di_user_criteria_ref_id,true);
		$criteria->compare('grade_ref_id',$this->grade_ref_id);
		$criteria->compare('min_grade_count',$this->min_grade_count);
		$criteria->compare('max_grade_count',$this->max_grade_count);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}