<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiStudentSelectionStatus is autogenerate by UniModel generator
 *
 * This is the model class for table "di_student_selection_status".
 *
 * The followings are the available columns in table 'di_student_selection_status':
 * @property string $di_student_selection_status_id
 * @property integer $di_user_ref_id
 * @property string $user_ref_id
 * @property integer $main_dept_ref_id
 * @property string $status
 * @property string $origin
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupDepartment $mainDeptRef
 * @property DiUser $diUserRef
 * @property TblUserMaster $userRef
 */
class BaseDiStudentSelectionStatus extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiStudentSelectionStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_student_selection_status';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_user_ref_id, user_ref_id, status, origin, added_on', 'required'),
			array('di_user_ref_id, main_dept_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('status', 'length', 'max'=>11),
			array('origin', 'length', 'max'=>9),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_student_selection_status_id, di_user_ref_id, user_ref_id, main_dept_ref_id, status, origin, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'mainDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_dept_ref_id'),
			'diUserRef' => array(self::BELONGS_TO, 'DiUser', 'di_user_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_student_selection_status_id' => 'Di Student Selection Status',
			'di_user_ref_id' => 'Di User Ref',
			'user_ref_id' => 'User Ref',
			'main_dept_ref_id' => 'Main Dept Ref',
			'status' => 'Status',
			'origin' => 'Origin',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_student_selection_status_id',$this->di_student_selection_status_id,true);
		$criteria->compare('di_user_ref_id',$this->di_user_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('main_dept_ref_id',$this->main_dept_ref_id);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('origin',$this->origin,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}