<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiReviewUnfreeze is autogenerate by UniModel generator
 *
 * This is the model class for table "di_review_unfreeze".
 *
 * The followings are the available columns in table 'di_review_unfreeze':
 * @property string $id
 * @property integer $di_ref_id
 * @property string $notes
 * @property string $unfreezed_on
 * @property string $unfreezed_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $unfreezedBy
 * @property Di $diRef
 */
class BaseDiReviewUnfreeze extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiReviewUnfreeze the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_review_unfreeze';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_ref_id', 'required'),
			array('di_ref_id', 'numerical', 'integerOnly'=>true),
			array('unfreezed_by', 'length', 'max'=>10),
			array('notes, unfreezed_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, di_ref_id, notes, unfreezed_on, unfreezed_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'unfreezedBy' => array(self::BELONGS_TO, 'LoginMaster', 'unfreezed_by'),
			'diRef' => array(self::BELONGS_TO, 'Di', 'di_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'di_ref_id' => 'Di Ref',
			'notes' => 'Notes',
			'unfreezed_on' => 'Unfreezed On',
			'unfreezed_by' => 'Unfreezed By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('di_ref_id',$this->di_ref_id);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('unfreezed_on',$this->unfreezed_on,true);
		$criteria->compare('unfreezed_by',$this->unfreezed_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}