<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiReviewExam is autogenerate by UniModel generator
 *
 * This is the model class for table "di_review_exam".
 *
 * The followings are the available columns in table 'di_review_exam':
 * @property string $di_review_exam_id
 * @property string $di_user_eoi_log_ref_id
 * @property integer $entrance_exam_ref_id
 * @property string $info_provided
 * @property string $na_reason
 *
 * The followings are the available model relations:
 * @property EntranceExam $entranceExamRef
 * @property DiUserEoiLog $diUserEoiLogRef
 */
class BaseDiReviewExam extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiReviewExam the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_review_exam';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_user_eoi_log_ref_id', 'required'),
			array('entrance_exam_ref_id', 'numerical', 'integerOnly'=>true),
			array('di_user_eoi_log_ref_id', 'length', 'max'=>10),
			array('info_provided', 'length', 'max'=>1),
			array('na_reason', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_review_exam_id, di_user_eoi_log_ref_id, entrance_exam_ref_id, info_provided, na_reason', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'diUserEoiLogRef' => array(self::BELONGS_TO, 'DiUserEoiLog', 'di_user_eoi_log_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_review_exam_id' => 'Di Review Exam',
			'di_user_eoi_log_ref_id' => 'Di User Eoi Log Ref',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'info_provided' => 'Info Provided',
			'na_reason' => 'Na Reason',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_review_exam_id',$this->di_review_exam_id,true);
		$criteria->compare('di_user_eoi_log_ref_id',$this->di_user_eoi_log_ref_id,true);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('info_provided',$this->info_provided,true);
		$criteria->compare('na_reason',$this->na_reason,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}