<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDepartmentValidation is autogenerate by UniModel generator
 *
 * This is the model class for table "department_validation".
 *
 * The followings are the available columns in table 'department_validation':
 * @property integer $id
 * @property integer $dept_ref_id
 * @property integer $dept_pref_2
 * @property integer $score
 *
 * The followings are the available model relations:
 * @property LookupDepartment $deptRef
 */
class BaseDepartmentValidation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DepartmentValidation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'department_validation';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('dept_ref_id, score', 'required'),
			array('dept_ref_id, dept_pref_2, score', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, dept_ref_id, dept_pref_2, score', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'deptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'dept_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'dept_ref_id' => 'Dept Ref',
			'dept_pref_2' => 'Dept Pref 2',
			'score' => 'Score',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('dept_ref_id',$this->dept_ref_id);
		$criteria->compare('dept_pref_2',$this->dept_pref_2);
		$criteria->compare('score',$this->score);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}