<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDepartmentSubject is autogenerate by UniModel generator
 *
 * This is the model class for table "department_subject".
 *
 * The followings are the available columns in table 'department_subject':
 * @property integer $department_subject_id
 * @property integer $department_ref_id
 * @property integer $subject_ref_id
 *
 * The followings are the available model relations:
 * @property ZDELETEUniversityDepartmentSubjectWeightage[] $zDELETEUniversityDepartmentSubjectWeightages
 * @property LookupDepartment $departmentRef
 * @property LookupSubjectMaster $subjectRef
 * @property UniversityDepartmentSubjectCutoff[] $universityDepartmentSubjectCutoffs
 */
class BaseDepartmentSubject extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DepartmentSubject the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'department_subject';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('department_ref_id, subject_ref_id', 'required'),
			array('department_ref_id, subject_ref_id', 'numerical', 'integerOnly'=>true),
            array('subject_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('department_subject_id, department_ref_id, subject_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'zDELETEUniversityDepartmentSubjectWeightages' => array(self::HAS_MANY, 'ZDELETEUniversityDepartmentSubjectWeightage', 'department_subject_ref_id'),
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
			'subjectRef' => array(self::BELONGS_TO, 'LookupSubjectMaster', 'subject_ref_id'),
			'universityDepartmentSubjectCutoffs' => array(self::HAS_MANY, 'UniversityDepartmentSubjectCutoff', 'department_subject_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'department_subject_id' => 'Department Subject',
			'department_ref_id' => 'Department Ref',
			'subject_ref_id' => 'Subject Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('department_subject_id',$this->department_subject_id);
		$criteria->compare('department_ref_id',$this->department_ref_id);
        $criteria->compare('subject_ref_id',$this->subject_ref_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}