<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseCourseFees is autogenerate by UniModel generator
 *
 * This is the model class for table "course_fees".
 *
 * The followings are the available columns in table 'course_fees':
 * @property string $course_fees_id
 * @property string $uni_course_ref_id
 * @property integer $reservation_ref_id
 * @property integer $course_fees_duration_ref_id
 * @property string $fees
 * @property integer $currency_ref_id
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property LookupCurrency $currencyRef
 * @property LookupCourseFeesDuration $courseFeesDurationRef
 * @property TblAdmin $modifiedBy
 * @property LookupReservation $reservationRef
 * @property TblUniCourses $uniCourseRef
 */
class BaseCourseFees extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CourseFees the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'course_fees';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_course_ref_id, reservation_ref_id, course_fees_duration_ref_id, fees, currency_ref_id', 'required'),
			array('reservation_ref_id, course_fees_duration_ref_id, currency_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('uni_course_ref_id, fees', 'length', 'max'=>10),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('course_fees_id, uni_course_ref_id, reservation_ref_id, course_fees_duration_ref_id, fees, currency_ref_id, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'courseFeesDurationRef' => array(self::BELONGS_TO, 'LookupCourseFeesDuration', 'course_fees_duration_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'reservationRef' => array(self::BELONGS_TO, 'LookupReservation', 'reservation_ref_id'),
			'uniCourseRef' => array(self::BELONGS_TO, 'TblUniCourses', 'uni_course_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'course_fees_id' => 'Course Fees',
			'uni_course_ref_id' => 'Uni Course Ref',
			'reservation_ref_id' => 'Reservation Ref',
			'course_fees_duration_ref_id' => 'Course Fees Duration Ref',
			'fees' => 'Fees',
			'currency_ref_id' => 'Currency Ref',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('course_fees_id',$this->course_fees_id,true);
		$criteria->compare('uni_course_ref_id',$this->uni_course_ref_id,true);
		$criteria->compare('reservation_ref_id',$this->reservation_ref_id);
		$criteria->compare('course_fees_duration_ref_id',$this->course_fees_duration_ref_id);
		$criteria->compare('fees',$this->fees,true);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}