<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseCourseAffiliation is autogenerate by UniModel generator
 *
 * This is the model class for table "course_affiliation".
 *
 * The followings are the available columns in table 'course_affiliation':
 * @property string $course_affiliation_id
 * @property string $uni_course_ref_id
 * @property integer $uni_ref_id
 * @property string $uni_name
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property TblAdmin $modifiedBy
 * @property TblUniCourses $uniCourseRef
 * @property TblUniversityMaster $uniRef
 */
class BaseCourseAffiliation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CourseAffiliation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'course_affiliation';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_course_ref_id', 'required'),
			array('uni_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('uni_course_ref_id', 'length', 'max'=>10),
			array('uni_name', 'length', 'max'=>500),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('course_affiliation_id, uni_course_ref_id, uni_ref_id, uni_name, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'uniCourseRef' => array(self::BELONGS_TO, 'TblUniCourses', 'uni_course_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'course_affiliation_id' => 'Course Affiliation',
			'uni_course_ref_id' => 'Uni Course Ref',
			'uni_ref_id' => 'Uni Ref',
			'uni_name' => 'Uni Name',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('course_affiliation_id',$this->course_affiliation_id,true);
		$criteria->compare('uni_course_ref_id',$this->uni_course_ref_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('uni_name',$this->uni_name,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}