<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseCountryValidation is autogenerate by UniModel generator
 *
 * This is the model class for table "country_validation".
 *
 * The followings are the available columns in table 'country_validation':
 * @property integer $id
 * @property string $school_type
 * @property integer $board_ref_id
 * @property string $gender
 * @property string $p1
 * @property string $p2
 * @property string $p3
 * @property integer $score
 *
 * The followings are the available model relations:
 * @property LookupBoard $boardRef
 */
class BaseCountryValidation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CountryValidation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'country_validation';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('school_type, board_ref_id, gender, p1, score', 'required'),
			array('board_ref_id, score', 'numerical', 'integerOnly'=>true),
			array('school_type, gender', 'length', 'max'=>1),
			array('p1, p2, p3', 'length', 'max'=>2),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, school_type, board_ref_id, gender, p1, p2, p3, score', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'boardRef' => array(self::BELONGS_TO, 'LookupBoard', 'board_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'school_type' => 'School Type',
			'board_ref_id' => 'Board Ref',
			'gender' => 'Gender',
			'p1' => 'P1',
			'p2' => 'P2',
			'p3' => 'P3',
			'score' => 'Score',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('school_type',$this->school_type,true);
		$criteria->compare('board_ref_id',$this->board_ref_id);
		$criteria->compare('gender',$this->gender,true);
		$criteria->compare('p1',$this->p1,true);
		$criteria->compare('p2',$this->p2,true);
		$criteria->compare('p3',$this->p3,true);
		$criteria->compare('score',$this->score);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}