<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseCareerTags is autogenerate by UniModel generator
 *
 * This is the model class for table "career_tags".
 *
 * The followings are the available columns in table 'career_tags':
 * @property string $career_tag_id
 * @property string $career_ref_id
 * @property string $tag_name
 * @property string $career_id
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property LookupCareer $careerRef
 * @property LookupCareer $career
 * @property LoginMaster $addedBy
 */
class BaseCareerTags extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CareerTags the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'career_tags';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('career_ref_id, career_id, added_by', 'length', 'max'=>10),
			array('tag_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('career_tag_id, career_ref_id, tag_name, career_id, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'careerRef' => array(self::BELONGS_TO, 'LookupCareer', 'career_ref_id'),
			'career' => array(self::BELONGS_TO, 'LookupCareer', 'career_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'career_tag_id' => 'Career Tag',
			'career_ref_id' => 'Career Ref',
			'tag_name' => 'Tag Name',
			'career_id' => 'Career',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('career_tag_id',$this->career_tag_id,true);
		$criteria->compare('career_ref_id',$this->career_ref_id,true);
		$criteria->compare('tag_name',$this->tag_name,true);
		$criteria->compare('career_id',$this->career_id,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}