<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseCalendarSettings is autogenerate by UniModel generator
 *
 * This is the model class for table "calendar_settings".
 *
 * The followings are the available columns in table 'calendar_settings':
 * @property string $calendar_settings_id
 * @property string $user_ref_id
 * @property string $events
 * @property string $shortlisted
 * @property string $top_colleges
 * @property string $tests
 * @property string $first_time
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseCalendarSettings extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CalendarSettings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'calendar_settings';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('events, shortlisted, top_colleges, tests, first_time, added_on', 'required'),
			array('user_ref_id', 'length', 'max'=>10),
			array('events, shortlisted, top_colleges, tests, first_time', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('calendar_settings_id, user_ref_id, events, shortlisted, top_colleges, tests, first_time, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'calendar_settings_id' => 'Calendar Settings',
			'user_ref_id' => 'User Ref',
			'events' => 'Events',
			'shortlisted' => 'Shortlisted',
			'top_colleges' => 'Top Colleges',
			'tests' => 'Tests',
			'first_time' => 'First Time',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('calendar_settings_id',$this->calendar_settings_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('events',$this->events,true);
		$criteria->compare('shortlisted',$this->shortlisted,true);
		$criteria->compare('top_colleges',$this->top_colleges,true);
		$criteria->compare('tests',$this->tests,true);
		$criteria->compare('first_time',$this->first_time,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}