<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseBoard is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_board".
 *
 * The followings are the available columns in table 'lookup_board':
 * @property integer $board_id
 * @property string $board_name
 * @property string $board_desc
 */
class BaseBoard extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Board the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_board';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('board_name', 'length', 'max'=>10),
			array('board_desc', 'length', 'max'=>75),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('board_id, board_name, board_desc', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'board_id' => 'Board',
			'board_name' => 'Board Name',
			'board_desc' => 'Board Desc',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('board_id',$this->board_id);
		$criteria->compare('board_name',$this->board_name,true);
		$criteria->compare('board_desc',$this->board_desc,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}