<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseArticleKnowledgeMailTracker is autogenerate by UniModel generator
 *
 * This is the model class for table "article_knowledge_mail_tracker".
 *
 * The followings are the available columns in table 'article_knowledge_mail_tracker':
 * @property integer $article_knowledge_mail_tracker_id
 * @property integer $article_ref_id
 * @property string $user_ref_id
 * @property string $sent_on
 * @property string $email_message_ref_id
 * @property string $engagement_emails_ref_id
 * @property string $mail_opened_on
 * @property string $is_link_opened
 * @property string $is_confirmed
 * @property string $link_opened_on
 *
 * The followings are the available model relations:
 * @property Article $articleRef
 * @property EngagementEmails $engagementEmailsRef
 * @property EmailMessage $emailMessageRef
 * @property TblUserMaster $userRef
 */
class BaseArticleKnowledgeMailTracker extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ArticleKnowledgeMailTracker the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'article_knowledge_mail_tracker';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('article_ref_id, user_ref_id, sent_on', 'required'),
			array('article_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, email_message_ref_id, engagement_emails_ref_id', 'length', 'max'=>10),
			array('is_link_opened, is_confirmed', 'length', 'max'=>1),
			array('mail_opened_on, link_opened_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('article_knowledge_mail_tracker_id, article_ref_id, user_ref_id, sent_on, email_message_ref_id, engagement_emails_ref_id, mail_opened_on, is_link_opened, is_confirmed, link_opened_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'articleRef' => array(self::BELONGS_TO, 'Article', 'article_ref_id'),
			'engagementEmailsRef' => array(self::BELONGS_TO, 'EngagementEmails', 'engagement_emails_ref_id'),
			'emailMessageRef' => array(self::BELONGS_TO, 'EmailMessage', 'email_message_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'article_knowledge_mail_tracker_id' => 'Article Knowledge Mail Tracker',
			'article_ref_id' => 'Article Ref',
			'user_ref_id' => 'User Ref',
			'sent_on' => 'Sent On',
			'email_message_ref_id' => 'Email Message Ref',
			'engagement_emails_ref_id' => 'Engagement Emails Ref',
			'mail_opened_on' => 'Mail Opened On',
			'is_link_opened' => 'Is Link Opened',
			'is_confirmed' => 'Is Confirmed',
			'link_opened_on' => 'Link Opened On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('article_knowledge_mail_tracker_id',$this->article_knowledge_mail_tracker_id);
		$criteria->compare('article_ref_id',$this->article_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('sent_on',$this->sent_on,true);
		$criteria->compare('email_message_ref_id',$this->email_message_ref_id,true);
		$criteria->compare('engagement_emails_ref_id',$this->engagement_emails_ref_id,true);
		$criteria->compare('mail_opened_on',$this->mail_opened_on,true);
		$criteria->compare('is_link_opened',$this->is_link_opened,true);
		$criteria->compare('is_confirmed',$this->is_confirmed,true);
		$criteria->compare('link_opened_on',$this->link_opened_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}