<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseArticleDepartements is autogenerate by UniModel generator
 *
 * This is the model class for table "article_departements".
 *
 * The followings are the available columns in table 'article_departements':
 * @property integer $article_departement_id
 * @property integer $article_ref_id
 * @property integer $department_ref_id
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupDepartment $departmentRef
 * @property Article $articleRef
 */
class BaseArticleDepartements extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ArticleDepartements the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'article_departements';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('article_ref_id, added_on', 'required'),
			array('article_ref_id, department_ref_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('article_departement_id, article_ref_id, department_ref_id, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
			'articleRef' => array(self::BELONGS_TO, 'Article', 'article_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'article_departement_id' => 'Article Departement',
			'article_ref_id' => 'Article Ref',
			'department_ref_id' => 'Department Ref',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('article_departement_id',$this->article_departement_id);
		$criteria->compare('article_ref_id',$this->article_ref_id);
		$criteria->compare('department_ref_id',$this->department_ref_id);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}