<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseAdmin is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_admin".
 *
 * The followings are the available columns in table 'tbl_admin':
 * @property integer $admin_id
 * @property string $login_ref_id
 * @property string $admin_name
 * @property string $admin_email
 * @property string $admin_pwd
 * @property string $admin_full_name
 * @property integer $records_per_page
 * @property string $roles
 * @property integer $role_type_id
 * @property string $admin_details
 * @property string $is_active
 * @property string $added_on
 * @property string $last_modified
 * @property string $new_password
 *
 * The followings are the available model relations:
 * @property CourseAffiliation[] $courseAffiliations
 * @property CourseApplicationDates[] $courseApplicationDates
 * @property CourseEligibility[] $courseEligibilities
 * @property CourseFees[] $courseFees
 * @property CourseStartDate[] $courseStartDates
 * @property CourseTwining[] $courseTwinings
 * @property DiSignup[] $diSignups
 * @property EmailAlias[] $emailAliases
 * @property EmailAlias[] $emailAliases1
 * @property LoginMaster[] $loginMasters
 * @property LoginMaster[] $loginMasters1
 * @property MdmCourseDump[] $mdmCourseDumps
 * @property MdmCourseDump[] $mdmCourseDumps1
 * @property MdmCourseLog[] $mdmCourseLogs
 * @property MdmCourseLog[] $mdmCourseLogs1
 * @property MdmNewCourseLog[] $mdmNewCourseLogs
 * @property MdmNewCourseLog[] $mdmNewCourseLogs1
 * @property MdmNewCourseLog[] $mdmNewCourseLogs2
 * @property Prospect[] $prospects
 * @property Prospect[] $prospects1
 * @property Prospect[] $prospects2
 * @property Prospect[] $prospects3
 * @property ProspectInteraction[] $prospectInteractions
 * @property SessionAdvisorDeptCountry[] $sessionAdvisorDeptCountries
 * @property SessionTimeslot[] $sessionTimeslots
 * @property SessionTimeslot[] $sessionTimeslots1
 * @property SiAdvisor[] $siAdvisors
 * @property Task[] $tasks
 * @property Task[] $tasks1
 * @property Task[] $tasks2
 * @property Task[] $tasks3
 * @property TaskComments[] $taskComments
 * @property TaskLog[] $taskLogs
 * @property TaskLog[] $taskLogs1
 * @property UmailExtensionLog[] $umailExtensionLogs
 * @property UniCourseContact[] $uniCourseContacts
 * @property Workshop[] $workshops
 * @property WorkshopGroup[] $workshopGroups
 * @property WorkshopGroup[] $workshopGroups1
 */
class BaseAdmin extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Admin the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_admin';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('records_per_page, role_type_id', 'numerical', 'integerOnly'=>true),
			array('login_ref_id', 'length', 'max'=>10),
			array('admin_name', 'length', 'max'=>20),
			array('admin_email, admin_full_name', 'length', 'max'=>255),
			array('admin_pwd', 'length', 'max'=>200),
			array('roles', 'length', 'max'=>2),
			array('is_active, new_password', 'length', 'max'=>1),
			array('added_on', 'length', 'max'=>50),
			array('admin_details, last_modified', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('admin_id, login_ref_id, admin_name, admin_email, admin_pwd, admin_full_name, records_per_page, roles, role_type_id, admin_details, is_active, added_on, last_modified, new_password', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseAffiliations' => array(self::HAS_MANY, 'CourseAffiliation', 'added_by'),
			'courseApplicationDates' => array(self::HAS_MANY, 'CourseApplicationDates', 'added_by'),
			'courseEligibilities' => array(self::HAS_MANY, 'CourseEligibility', 'added_by'),
			'courseFees' => array(self::HAS_MANY, 'CourseFees', 'added_by'),
			'courseStartDates' => array(self::HAS_MANY, 'CourseStartDate', 'added_by'),
			'courseTwinings' => array(self::HAS_MANY, 'CourseTwining', 'added_by'),
			'diSignups' => array(self::HAS_MANY, 'DiSignup', 'added_by'),
			'emailAliases' => array(self::HAS_MANY, 'EmailAlias', 'added_by'),
			'emailAliases1' => array(self::HAS_MANY, 'EmailAlias', 'modified_by'),
			'loginMasters' => array(self::HAS_MANY, 'LoginMaster', 'added_by'),
			'loginMasters1' => array(self::HAS_MANY, 'LoginMaster', 'modified_by'),
			'mdmCourseDumps' => array(self::HAS_MANY, 'MdmCourseDump', 'added_by'),
			'mdmCourseDumps1' => array(self::HAS_MANY, 'MdmCourseDump', 'modified_by'),
			'mdmCourseLogs' => array(self::HAS_MANY, 'MdmCourseLog', 'approved_by'),
			'mdmCourseLogs1' => array(self::HAS_MANY, 'MdmCourseLog', 'request_by_id'),
			'mdmNewCourseLogs' => array(self::HAS_MANY, 'MdmNewCourseLog', 'approved_by'),
			'mdmNewCourseLogs1' => array(self::HAS_MANY, 'MdmNewCourseLog', 'modified_by'),
			'mdmNewCourseLogs2' => array(self::HAS_MANY, 'MdmNewCourseLog', 'request_by_id'),
			'prospects' => array(self::HAS_MANY, 'Prospect', 'advisor_ref_id'),
			'prospects1' => array(self::HAS_MANY, 'Prospect', 'reassigned_from'),
			'prospects2' => array(self::HAS_MANY, 'Prospect', 'added_by'),
			'prospects3' => array(self::HAS_MANY, 'Prospect', 'modified_by'),
			'prospectInteractions' => array(self::HAS_MANY, 'ProspectInteraction', 'assisted_by'),
			'sessionAdvisorDeptCountries' => array(self::HAS_MANY, 'SessionAdvisorDeptCountry', 'advisor_ref_id'),
			'sessionTimeslots' => array(self::HAS_MANY, 'SessionTimeslot', 'advisor_ref_id'),
			'sessionTimeslots1' => array(self::HAS_MANY, 'SessionTimeslot', 'reassigned_by'),
			'siAdvisors' => array(self::HAS_MANY, 'SiAdvisor', 'advisor_id'),
			'tasks' => array(self::HAS_MANY, 'Task', 'modified_by'),
			'tasks1' => array(self::HAS_MANY, 'Task', 'assigned_to'),
			'tasks2' => array(self::HAS_MANY, 'Task', 'creator'),
			'tasks3' => array(self::HAS_MANY, 'Task', 'reassigned_to'),
			'taskComments' => array(self::HAS_MANY, 'TaskComments', 'added_by'),
			'taskLogs' => array(self::HAS_MANY, 'TaskLog', 'assigned_to'),
			'taskLogs1' => array(self::HAS_MANY, 'TaskLog', 'reassigned_to'),
			'umailExtensionLogs' => array(self::HAS_MANY, 'UmailExtensionLog', 'extension_by'),
			'uniCourseContacts' => array(self::HAS_MANY, 'UniCourseContact', 'added_by'),
			'workshops' => array(self::HAS_MANY, 'Workshop', 'created_by_advisor'),
			'workshopGroups' => array(self::HAS_MANY, 'WorkshopGroup', 'assigned_to_advisor'),
			'workshopGroups1' => array(self::HAS_MANY, 'WorkshopGroup', 'created_by_advisor'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'admin_id' => 'Admin',
			'login_ref_id' => 'Login Ref',
			'admin_name' => 'Admin Name',
			'admin_email' => 'Admin Email',
			'admin_pwd' => 'Admin Pwd',
			'admin_full_name' => 'Admin Full Name',
			'records_per_page' => 'Records Per Page',
			'roles' => 'Roles',
			'role_type_id' => 'Role Type',
			'admin_details' => 'Admin Details',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'last_modified' => 'Last Modified',
			'new_password' => 'New Password',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('admin_id',$this->admin_id);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('admin_name',$this->admin_name,true);
		$criteria->compare('admin_email',$this->admin_email,true);
		$criteria->compare('admin_pwd',$this->admin_pwd,true);
		$criteria->compare('admin_full_name',$this->admin_full_name,true);
		$criteria->compare('records_per_page',$this->records_per_page);
		$criteria->compare('roles',$this->roles,true);
		$criteria->compare('role_type_id',$this->role_type_id);
		$criteria->compare('admin_details',$this->admin_details,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('last_modified',$this->last_modified,true);
		$criteria->compare('new_password',$this->new_password,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}