<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseUserScholarship');

class UserScholarship extends BaseUserScholarship
{
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public static function getUserScholarshipList($userId = false, $scholarshipId = false)
    {
        $scholarship = self::model()->find('user_ref_id=:userId AND scholarship_ref_id=:scholarshipId', array(':userId' => $userId, 'scholarshipId' => $scholarshipId));
        if ($scholarship) {
            return $scholarship;
        } else {
            return false;
        }
    }

    public static function addUserScholarshipList($userId = false, $scholarshipId = false, $loginRefId = false)
    {
        $scholarship = self::model()->count('user_ref_id=:userId AND scholarship_ref_id=:scholarshipId', array(':userId' => $userId, 'scholarshipId' => $scholarshipId));

        if ($scholarship == 0) {
            $userScholarshipModel = new UserScholarship();
            $userScholarshipModel->user_ref_id = $userId;
            $userScholarshipModel->scholarship_ref_id = $scholarshipId;
            $userScholarshipModel->added_on = date('Y-m-d H:i:s');
            $userScholarshipModel->added_by = $loginRefId;

            $test = $userScholarshipModel->save();

        }

    }

    public static function userAllScholarshipList($userId = false, $scholarshipids = false)
    {
        if ($userId) {
            $scholarship = self::model()->findAll('user_ref_id=:userId', array(':userId' => $userId));
        } else if ($scholarshipids) {
            $scholarship = self::model()->findAll('scholarship_ref_id IN (' . $scholarshipids . ')');
        }
        return $scholarship;
    }

    public static function deleteUserScholarshipList($userId = false, $scholarshipId = false, $loginRefId = false)
    {
        $scholarshipDelete = self::model()->deleteAll('user_ref_id=:userId AND scholarship_ref_id=:scholarshipId', array(':userId' => $userId, 'scholarshipId' => $scholarshipId));
    }

    public static function getShortlistScholarshipData($userId)
    {
        $shortListScholarship = Yii::app()->db->createCommand()
            ->select('us.*, scholarship_id, scholarship_name, type_name, currency_ref_id, html_entity, amount, frequency, deadline_day as day, deadline_month as month, deadline_year as year')
            ->from('user_scholarship us')
            ->join('scholarship s', 's.scholarship_id = us.scholarship_ref_id')
            ->leftJoin('lookup_scholarship_type lst', 'lst.scholarship_type_id = s.scholarship_type_ref_id')
            ->leftJoin('lookup_currency lc', 'lc.currency_id = s.currency_ref_id')
            ->where('user_ref_id = :userId AND is_active = :status', array(':userId' => $userId, ':status' => '1'))
            ->queryAll();
        return $shortListScholarship;
    }

    public static function getShortlistCountryList($userId){
        $sql = "SELECT tcm.country_name,tcm.country_id FROM scholarship sp
                INNER JOIN user_scholarship us ON us.scholarship_ref_id = sp.scholarship_id
                INNER JOIN `scholarship_host_institute` sh ON sh.`scholarship_ref_id` = us.scholarship_ref_id
                INNER JOIN tbl_country_master tcm ON tcm.country_id = sh.`country_ref_id`
                WHERE us.user_ref_id = ".$userId."
                AND sh.country_ref_id IS NOT NULL AND sp.is_active = 1
                GROUP BY sh.country_ref_id ORDER BY tcm.country_name";
        $cmd = Yii::app()->db->createCommand($sql);
        $result = $cmd->queryAll();
        $country = Array();

        foreach($result as $row){
            $country[$row['country_id']] = $row['country_name'];
        }
        return $country;
    }

    public static function getShortlistDepartments($userId){
        $sql = "SELECT ld.department_id,ld.department_name FROM scholarship sp
                INNER JOIN user_scholarship us ON us.scholarship_ref_id = sp.scholarship_id
                INNER JOIN `scholarship_department` sd ON sd.`scholarship_ref_id`= us.scholarship_ref_id
                INNER JOIN `lookup_department` ld ON ld.department_id = sd.`main_dept_ref_id`
                WHERE us.user_ref_id = ".$userId."
                AND sd.main_dept_ref_id IS NOT NULL AND sp.is_active = 1
                GROUP BY sd.main_dept_ref_id ORDER BY ld.department_name";
        $cmd = Yii::app()->db->createCommand($sql);
        $result = $cmd->queryAll();
        $departments = Array();

        foreach($result as $row){
            $departments[$row['department_id']] = $row['department_name'];
        }
        return $departments;
    }

    public static function getShortlistUniversityList($countryId,$departmentId,$providerId=false){
        $sql = "SELECT shi.uni_ref_id,tu.uni_name
                FROM user_scholarship us
                INNER JOIN student_shortlist_university ssu ON ssu.user_ref_id = us.user_ref_id
                INNER JOIN `scholarship_host_institute` shi ON shi.scholarship_ref_id = us.scholarship_ref_id AND shi.uni_ref_id = ssu.uni_ref_id
                INNER JOIN tbl_university_master tu ON tu.uni_id = shi.uni_ref_id
                LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id`= us.scholarship_ref_id
                INNER JOIN scholarship sp ON sp.scholarship_id = us.scholarship_ref_id
                WHERE us.user_ref_id = ".Yii::app()->user->sub_id." AND tu.is_active = 'Y' AND ssu.shortlist_status !='Reject' ";
        if($providerId)
            $sql.= " AND sp.scholarship_provider_ref_id = ".$providerId;
        if($countryId)
            $sql.= " AND shi.country_ref_id=".$countryId;
        if($departmentId)
            $sql.= " AND sd.main_dept_ref_id=".$departmentId;

        $sql.= " GROUP BY shi.uni_ref_id";
        $cmd = Yii::app()->db->createCommand($sql);
        $result = $cmd->queryAll();
        $universities = Array();

        foreach($result as $row){
            $universities[$row['uni_ref_id']] = CHtml::decode($row['uni_name']);
        }
        return $universities;
    }

    public static function getNewShortlistScholarshipData($params, $limit=false,$offset=false){
        $condition = $conditionForUniversity = array();
        if($params['provider_type'] != '') {
            $condition[1]  = " scholarship_provider_ref_id = ". $params['provider_type'];
        }
        if($params['dept_pref'] != '') {
            $condition[2]  = " sd.main_dept_ref_id = ". $params['dept_pref'];
        }
        if($params['country_pref'] != '') {
            $condition[3]  = " shi.country_ref_id = ". $params['country_pref'];
        }
        if($params['filter_college'] != '') {
            $condition[4]  = " shi.uni_ref_id = ". $params['filter_college'];
        }
        $finalCondition = implode(' AND ', $condition);
        if($finalCondition ==''){
            $finalCondition = ' 1=1 ';
        }

       $sql = "SELECT sp.`scholarship_id`, sp.`scholarship_name`, sp.deadline_month, sp.deadline_day, sp.deadline_year, sp.amount, sp.frequency, lc.html_entity, lspt.provider_type, shi.`country_ref_id`,`university_type`,shi.`uni_ref_id`, lst.type_name
                FROM user_scholarship us
                LEFT JOIN scholarship sp ON sp.scholarship_id = us.scholarship_ref_id
                LEFT JOIN scholarship_host_institute shi ON shi.scholarship_ref_id = sp.`scholarship_id`
                LEFT JOIN `scholarship_department` sd ON sd.`scholarship_ref_id` = shi.`scholarship_ref_id`
                LEFT JOIN lookup_currency AS lc ON sp.currency_ref_id = lc.currency_id
                LEFT JOIN lookup_scholarship_provider_type AS lspt ON lspt.scholarship_provider_type_id = sp.scholarship_provider_ref_id
                LEFT JOIN lookup_scholarship_type lst on lst.scholarship_type_id=sp.scholarship_type_ref_id
                LEFT JOIN tbl_country_master tcm ON tcm.country_id = shi.`country_ref_id`
                LEFT JOIN student_shortlist_university ssu ON us.user_ref_id = ssu.user_ref_id
                WHERE us.user_ref_id = ".Yii::app()->user->sub_id."
                AND sp.is_active = 1 AND ".$finalCondition." "; //
            $sql.=" GROUP BY sp.scholarship_id ORDER BY sp.amount DESC";
        if($limit){
            $sql.= " LIMIT ".$offset.", ".$limit;
        }
        $cmd = Yii::app()->db->createCommand($sql); //AND sd.course_level_ref_id = 6
        $result = $cmd->queryAll();
        return $result;
    }
}