<?php

Yii::import('application.models.base.BaseUserDataPoint');

class UserDataPoint extends BaseUserDataPoint {

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function rules()
    {
        $rules=parent::rules();
        return CMap::mergeArray($rules,array(
            array('comments', 'required', 'message'=>'<div class="holder"><p>'.'Please enter notes'.'</p></div>','on'=>'counsellor'),
            array('interaction_ref_id', 'required', 'message'=>'<div class="holder"><p>Please choose mode of interaction</p></div>','on'=>'counsellor'),
        ));
    }

    public static function getUserDataPoints($userId = 0) {
        $model = self::model()->with('addedBy')->findAll(array("condition" => "user_ref_id = $userId", "order" => "t.added_on DESC"));
        return $model;
    }

    public static function getUserDataPointsForCSSAdvisor($userId, $instId = 0) {
        
        if($instId) {
            $model = Yii::app()->db->createCommand()
                            ->select('user_data_point_id, user_ref_id, added_by, udp.added_on, comments, admin_name')
                            ->from('user_data_point AS udp')
                            ->join('tbl_admin AS ta', 'ta.login_ref_id = udp.added_by AND si_ref_id = '.$instId)
                            ->where('user_ref_id = '.$userId)
                            ->order("udp.added_on DESC")
                            ->queryAll();
        } else {
            $model = Yii::app()->db->createCommand()
                            ->select('user_data_point_id, user_ref_id, added_by, udp.added_on, comments, admin_name')
                            ->from('user_data_point AS udp')
                            ->join('tbl_admin AS ta', 'ta.login_ref_id = udp.added_by')
                            ->where('user_ref_id = '.$userId)
                            ->order("udp.added_on DESC")
                            ->queryAll();
        }
        return $model;
    }

    public static function addUserDataPoint($attributes = array()) {
        $model = new UserDataPoint();
        $model->setAttributes($attributes);
        $model->save(false);
        return $model->user_data_point_id;
    }

}