<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseTopPopularCollege');

class TopPopularCollege extends BaseTopPopularCollege
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  
  public static function getTopColleges($offset = 0, $limit = 0, $deptId = 0, $countryId = 0) {
          $criteria = new CDbCriteria();
          $criteria->select = 'DISTINCT(top_college_ref_id),country_ref_id,level_type';;
          $criteria->condition = 'top_college_ref_id IS NOT NULL';
          $criteria->compare('department_ref_id', $deptId);
          $criteria->compare('country_ref_id', $countryId);          
          $criteria->compare('is_active', 1);
		  $criteria->order = "top_college_rank";
          $criteria->offset = $offset;
          if($limit)
          $criteria->limit = $limit;
          
          return self::model()->findAll($criteria); 
          
  }
  
  public static function getPopularColleges($offset = 0, $limit = 0, $deptId = 0, $countryId = 0) {
          $criteria = new CDbCriteria();
          $criteria->condition = 'popular_college_ref_id IS NOT NULL';
          $criteria->compare('department_ref_id', $deptId);
          $criteria->compare('country_ref_id', $countryId);          
          $criteria->compare('is_active', 1);
		  $criteria->order = "top_college_rank";         
          $criteria->offset = $offset;
          if($limit)
          $criteria->limit = $limit;
          
          return self::model()->findAll($criteria); 
          
  }
  
  public static function getTopEngColleges($offset = 0, $limit = 20, $level, $deptId = 0, $countryId = 0) {
          $criteria = new CDbCriteria();
          $criteria->compare('department_ref_id', $deptId);
          $criteria->compare('country_ref_id', $countryId);
          $criteria->compare('level_type', $level);
          $criteria->compare('is_active', 1);
		  $criteria->order = "top_college_rank";
          $criteria->offset = $offset;
          $criteria->limit = $limit;
          return self::model()->findAll($criteria); 
          
  }

    public function getTopCollegeByEntranceTest($entranceId,$offset=0,$limit=0){

        $sql = "SELECT ct.entrance_ref_id, ee.entrance_full_name,t.top_college_ref_id,tum.uni_name,tcm.city_name, ts.name,  c.country_name
                FROM top_popular_college t
                JOIN uni_course_test ct ON ct.uni_ref_id = t.top_college_ref_id
                JOIN tbl_university_master tum ON tum.uni_id =  ct.uni_ref_id
                JOIN entrance_exam ee ON ee.entrance_id = ct.entrance_ref_id
                JOIN tbl_city_master tcm ON tcm.city_id = tum.city_ref_id
                JOIN tbl_state ts ON ts.id = tum.state_ref_id
                JOIN tbl_country_master c ON c.country_id = tum.country_ref_id
                WHERE ct.entrance_ref_id = '".$entranceId."'
                GROUP BY t.top_college_ref_id
                ORDER BY top_college_rank,tum.uni_name ASC LIMIT $offset,$limit";
        $result = Yii::app()->db->createCommand($sql)->queryAll();
        return $result;

    }
  
}