<?php

Yii::import('application.models.base.BaseTblUniversityMaster');

class TblUniversityMaster extends BaseTblUniversityMaster {

    const COED_BOYS = 'Boys';
    const COED_GIRLS = 'Girls';
    const COED_COED = 'Co-Education';
    public $country_search;
    public $state_search;
    public $city_search;
    public $page_number;
    public $city_name;
    public $cover_page_banner;
    public $alt_logo;
    public $alt_banner;
    public $heading;
    public $title;
    public $meta_keyword;
    public $meta_desc;

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            //array('url_primary_key', 'required'),
            array('uni_name,country_ref_id', 'required','on'=>'Create'),
            /* START:  these validation are used in case of basic tab of international university */
            array('address1,website_url,uni_name,country_ref_id,institute_control_ref_id,vintage,location_type', 'required', 'on' => 'Basic'),
            array('seo_keyword', 'match', 'pattern' => '/^([a-zA-Z])+$/', 'message' => 'Only alphabets is allowed.', 'on' => 'Basic'),
            array('vintage', 'length', 'min' => 4, 'max' => 4, 'tooLong' => 'Please enter 4 digit year.', 'tooShort' => 'Please enter 4 digit year.', 'on' => 'Basic'),
            array('admission_url,course_page_url,scholarship_link,media_reports', 'url', 'allowEmpty' => true, 'message' => 'Please enter a valid URL.', 'validSchemes' => array('http', 'https'), 'on' => 'Basic'),
            array('website_url', 'url', 'allowEmpty' => true, 'message' => 'Please enter a valid URL.', 'validSchemes' => array('http', 'https'), 'on' => 'Basic'),
            array('website_url', 'url', 'allowEmpty' => true, 'message' => 'Please enter a valid URL.', 'validSchemes' => array('http', 'https'), 'on' => 'BasicIndia'),            
            array('zipcode', 'length', 'min' => 3, 'max' => 10, 'allowEmpty' => true, 'tooShort' => 'Enter a valid zipcode', 'tooLong' => 'Enter a valid zipcode(Max. length 10).', 'on' => 'Basic'),
            array('latitude,longitude', 'length', 'max' => 15, 'allowEmpty' => true, 'tooLong' => 'Enter a valid data.', 'on' => 'Basic'),
            array('uni_logo,cover_page_banner', 'file', 'allowEmpty' => true, 'types' => 'jpg', 'wrongType' => 'Incorrect file format, Allowed extensions jpg.', 'on' => 'Basic'),
            /* END */

            /* START:  these validation are used in case of basic tab of indian university */
            //array('address1,website_url,country_ref_id,state_ref_id', 'required', 'on' => 'BasicIndia'),
			array('address1,website_url,country_ref_id,state_ref_id,contact_email', 'required', 'on' => 'BasicIndia'),
			 array('contact_email', 'email', 'on'=>'BasicIndia'),
            array('uni_name', 'required', 'message' => 'College name cannot be blank.', 'on' => 'BasicIndia'),
            array('seo_keyword', 'match', 'pattern' => '/^([a-zA-Z])+$/', 'message' => 'Only alphabets is allowed.', 'on' => 'BasicIndia'),
            //array('city_ref_id', 'required','message'=>'City cannot be blank.', 'on' => 'BasicIndia'),
            array('vintage', 'length', 'min' => 4, 'max' => 4, 'tooLong' => 'Please enter 4 digit year.', 'tooShort' => 'Please enter 4 digit year.', 'on' => 'BasicIndia'),
            array('admission_url,course_page_url,scholarship_link', 'url', 'allowEmpty' => true, 'message' => 'Please enter a valid URL.', 'validSchemes' => array('http', 'https'), 'on' => 'BasicIndia'),
            array('website_url', 'url', 'allowEmpty' => true, 'message' => 'Please enter a valid URL.', 'validSchemes' => array('http', 'https'), 'on' => 'Basic'),
            array('uni_rating','match','pattern'=>'/^(?:5(?:\.0)?|[0-4](?:\.[0-9])?|0?\.[1-9])$/', 'message' => 'Numbers only and Maximum rating can be 5.0', 'on' => 'Basic'),
            array('uni_rating','match','pattern'=>'/^(?:5(?:\.0)?|[0-4](?:\.[0-9])?|0?\.[1-9])$/', 'message' => 'Numbers only and Maximum rating can be 5.0', 'on' => 'BasicIndia'),
//            array('uni_rating', 'numerical', 'on' => 'Basic'),
//            array('uni_rating', 'numerical', 'on' => 'BasicIndia'),
            array('zipcode', 'numerical', 'integerOnly' => true, 'on' => 'BasicIndia'),
            array('zipcode', 'length', 'is' => 6, 'allowEmpty' => true, 'on' => 'BasicIndia'),
            array('latitude,longitude', 'length', 'max' => 15, 'allowEmpty' => true, 'tooLong' => 'Enter a valid data.', 'on' => 'BasicIndia'),
            array('uni_logo,cover_page_banner', 'file', 'allowEmpty' => true, 'types' => 'jpg', 'wrongType' => 'Incorrect file format, Allowed extensions jpg.', 'on' => 'BasicIndia'),
            /* END */
            array('uni_country_rank, uni_global_rank, global_display_rank, university_affiliation_ref_id, institute_control_ref_id, state_ref_id, city_ref_id, country_ref_id, international_stud_total, international_stud_total_men, international_stud_total_women, total_students, total_applicants, total_enrolled_people, living_cost_in_city, living_cost_on_campus, vintage, no_of_campus, low_sal_range_currency_ref_id, high_sal_range_currency_ref_id, avg_salary_currency_ref_id, median_salary_currency_ref_id, high_domestic_salary_currency_ref_id, high_international_salary_currency_ref_id, added_by, modified_by', 'numerical', 'integerOnly' => true),
            array('uni_rank_factor, international_stud_per, full_time_per,latitude,longitude, part_time_per, male_per, female_per', 'numerical'),
            array('uni_code', 'length', 'max' => 20),
            array('uni_name', 'required', 'message' => 'Please enter university name.', 'on' => 'Basic'),
            array('country_ref_id', 'required', 'message' => 'Please select country.', 'on' => 'Basic'),
            array('uni_name, uni_slug_name, uni_logo, website_url, admission_url, course_page_url, application_url, flagship_subjects_courses_url, campus_look_n_feel, campus_link, longitude, latitude,scholarship_link', 'length', 'max' => 255),
            array('url_primary_key', 'length', 'max' => 32),
            array('coed', 'length', 'max' => 12),
            array('type_of_institute', 'length', 'max' => 11),
            array('zipcode, acceptance_rate, enrolment_ratio, job_placement_per_pg, likelihood_scholarship, low_sal_range, high_sal_range, avg_salary, median_salary, high_domestic_salary, high_international_salary', 'length', 'max' => 10),
            array('location_type', 'length', 'max' => 6),
            array('calender_system', 'length', 'max' => 18),
            array('admission_cycle_cnt, student_professor_ratio', 'length', 'max' => 7),
            array('main_campus_size_in_acres', 'length', 'max' => 8),
            array('on_site_residence', 'length', 'max' => 3),
            array('is_twining, is_active', 'length', 'max' => 1),
            array('uni_profile,university_affiliation_ref_id, address, address1, address2,uni_logo,city_name, seo_keyword, university_tier, uni_id, flagship_subjects_courses, test_needed, media_reports, placement_article_link, admission_comments, added_on, modified_on, contact_email, unique_feature, uni_join, is_user_entered', 'safe'),
            array('international_stud_total', 'numerical', 'integerOnly' => true, 'on' => 'Diversity', 'message' => 'International student total must be an integer'),
            array('international_stud_total_men', 'numerical', 'integerOnly' => true, 'on' => 'Diversity', 'message' => 'International student total men must be an integer'),
            array('international_stud_total_women', 'numerical', 'integerOnly' => true, 'on' => 'Diversity', 'message' => 'International student women total must be an integer'),
            array('total_students', 'numerical', 'integerOnly' => true, 'on' => 'Diversity', 'message' => 'Total student must be an integer'),
            array('international_stud_per', 'numerical', 'min' => 1, 'max' => 100, 'on' => 'Diversity'),
            array('full_time_per', 'numerical', 'min' => 1, 'max' => 100, 'on' => 'Diversity'),
            array('part_time_per', 'numerical', 'min' => 1, 'max' => 100, 'on' => 'Diversity'),
            array('male_per', 'numerical', 'min' => 1, 'max' => 100, 'on' => 'Diversity'),
            array('female_per', 'numerical', 'min' => 1, 'max' => 100, 'on' => 'Diversity'),
            //Campus senario validation
           // array('student_professor_ratio', 'numerical', 'on' => 'Campus', 'message' => 'Student professor ratio must be numeric'),
            array('living_cost_in_city', 'numerical', 'integerOnly' => true, 'on' => 'Campus', 'message' => 'Living cost in city must be an integer'),
            array('living_cost_on_campus', 'numerical', 'integerOnly' => true, 'on' => 'Campus', 'message' => 'Living cost in campus must be an integer'),
            array('no_of_campus', 'numerical', 'integerOnly' => true, 'on' => 'Campus', 'message' => 'No of campus must be an integer'),
            array('main_campus_size_in_acres', 'numerical', 'on' => 'Campus', 'message' => 'Main campus size in acres must be an integer'),
//            array('longitude', 'numerical', 'on' => 'Campus', 'message' => 'Longitude must be numeric'),
//            array('latitude', 'numerical', 'on' => 'Campus', 'message' => 'Latitude must be numeric'),
            array('acceptance_rate', 'numerical', 'integerOnly' => true, 'on' => 'Campus', 'message' => 'Acceptance rate must be an integer'),
            array('total_applicants', 'numerical', 'integerOnly' => true, 'on' => 'Campus', 'message' => 'Total applicants must be an integer'),
            array('job_placement_per_pg', 'numerical', 'integerOnly' => true, 'on' => 'Campus', 'message' => 'Job placement percnetage must be an integer'),
            array('total_faculties,phd_faculties', 'numerical', 'integerOnly' => true, 'on' => 'Campus'),
            //array('uni_id, flagship_subjects_courses', 'safe', 'on' => 'Diversity'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('uni_id, uni_code,country_search,state_search,page_number,city_search, uni_name, url_primary_key, uni_country_rank, uni_global_rank, global_display_rank, uni_rank_factor, uni_slug_name, uni_logo, uni_profile, coed, university_affiliation_ref_id, type_of_institute, institute_control_ref_id, address, state_ref_id, city_ref_id, zipcode, country_ref_id, location_type, website_url, admission_url, course_page_url,scholarship_link, application_url, calender_system, international_stud_total, international_stud_total_men, international_stud_total_women, international_stud_per, total_students, full_time_per, part_time_per, male_per, female_per, flagship_subjects_courses, flagship_subjects_courses_url, admission_cycle_cnt, acceptance_rate, total_applicants, total_enrolled_people, enrolment_ratio, job_placement_per_pg, test_needed, likelihood_scholarship, living_cost_in_city, living_cost_on_campus, vintage, no_of_campus, main_campus_size_in_acres, campus_look_n_feel, campus_link, on_site_residence, student_professor_ratio, longitude, latitude, media_reports, placement_article_link, low_sal_range, low_sal_range_currency_ref_id, high_sal_range, high_sal_range_currency_ref_id, avg_salary, avg_salary_currency_ref_id, median_salary, median_salary_currency_ref_id, high_domestic_salary, high_domestic_salary_currency_ref_id, high_international_salary, high_international_salary_currency_ref_id, admission_comments, is_twining, is_active, added_on, added_by, modified_on, modified_by,campus_life,total_faculties,phd_faculties', 'safe', 'on' => 'search'),
        );
    }

    /**
     * This method will return the possible college list for a student based on passed department_sub_id and student preferred countries.
     * @param int $studentId
     * @param int $departmentId
     * @param string $searchTerm, Optional, if passed university name search results will be returned
     * @return array
     */
    public static function getSuggestionListForStudent($studentId, $departmentId, $searchTerm = null, $limit = 10) {
        $criteria = new CDbCriteria;
        $criteria->alias = 'um';
        $criteria->join = 'JOIN student_preferred_country as spc on um.country_ref_id = spc.country_ref_id JOIN tbl_uni_courses as uc ON um.uni_id = uc.uni_ref_id';
        if ($searchTerm) {
            $criteria->compare('um.uni_name', $searchTerm, true);
        }
        $criteria->compare('spc.user_ref_id', $studentId);
        $criteria->compare('uc.department_ref_id', $departmentId);
        $criteria->group = 'um.uni_id';
        //$criteria->order = 'um.uni_name';
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN um.uni_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), um.uni_name";
        $criteria->limit = $limit;
        return self::model()->findAll($criteria);
    }

    /**
     * This method will return the university list, if department is passed, based on passed department_sub_id
     * @param string $searchTerm
     * @param int $departmentId
     * @return array
     */
    public static function getSuggestionList($searchTerm, $departmentId = 0, $limit = 10, $gender = '') {
        $criteria = new CDbCriteria;
        $criteria->alias = 'um';
        if ($departmentId > 0) {
            $criteria->join = 'JOIN tbl_uni_courses as uc ON um.uni_id = uc.uni_ref_id';
            $criteria->compare('uc.department_ref_id', $departmentId);
        }

        // Using this condtion on b2b signup aspiration college page.
        if($gender) {
            $criteria->addInCondition('um.coed', array($gender, 'Co-Education'));
        }
        //$criteria->addCondition('um.is_user_entereds', '0',true);
        $criteria->compare('um.uni_name', $searchTerm, true);
        $criteria->compare('um.is_active', 'Y', true);
        $criteria->compare('um.is_user_entered', '0', true);
        $criteria->group = 'um.uni_id';
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN um.uni_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), um.uni_name";
        $criteria->limit = $limit;
        return self::model()->findAll($criteria);
    }

    /**
     * Returns the list of Universities based on global/national rank
     * @param integer $offset
     * @return array TblUniversityMaster
     */
    public static function getUniversityListTotal($offset = 0, $limit = 10, $countryId = 0, $departmentId = 0) {
        $criteria = new CDbCriteria();


        if ($countryId > 0) {
            $criteria->condition = 'global_display_rank > 0';
            $criteria->compare('country_ref_id', $countryId);
            $criteria->order = 'global_display_rank';
        } else {
            $criteria->condition = 'global_display_rank > 0';
            $criteria->order = 'global_display_rank';
        }
        $criteria->compare('is_active', 'Y');
        $criteria->offset = $offset;
        //$criteria->limit = $limit;

        return self::model()->findAll($criteria);
    }

    public static function getUniversityList($offset = 0, $limit = 10, $countryId = 0, $departmentId = 0) {
        $criteria = new CDbCriteria();


        if ($countryId > 0) {
            $criteria->condition = 'global_display_rank > 0';
            $criteria->compare('country_ref_id', $countryId);
            $criteria->order = 'global_display_rank';
        } else {
            $criteria->condition = 'global_display_rank > 0';
            $criteria->order = 'global_display_rank';
        }
        $criteria->compare('is_active', 'Y');
        $criteria->offset = $offset;
        $criteria->limit = $limit;

        return self::model()->findAll($criteria);
    }

    public static function getUniversityFieldsList($offset = 0, $limit = 10, $countryId = 0, $departmentId = 0) {
        $criteria = new CDbCriteria();
        $criteria->select   =   't.uni_id,t.uni_logo,t.uni_slug_name,t.uni_name,t.state_ref_id,t.city_ref_id,t.country_ref_id';
        if ($countryId > 0) {
            $criteria->condition = 'global_display_rank > 0';
            $criteria->compare('country_ref_id', $countryId);
            $criteria->order = 'global_display_rank';
        } else {
            $criteria->condition = 'global_display_rank > 0';
            $criteria->order = 'global_display_rank';
        }
        $criteria->compare('is_active', 'Y');
        $criteria->offset = $offset;
        $criteria->limit = $limit;

        return self::model()->findAll($criteria);
    }
    /**
     * This method will return the university list
     * @param string $searchTerm     
     * @return array
     */
    public static function getUniversityListAuto($searchTerm, $limit = 20, $countryId = 0) {
        $criteria = new CDbCriteria;
        $criteria->alias = 'um';
        $criteria->compare('um.uni_name', $searchTerm, true);
        $criteria->compare('um.country_ref_id', $countryId);
        $criteria->group = 'um.uni_id';
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN um.uni_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), um.uni_name";
        $criteria->limit = $limit;
        return self::model()->findAll($criteria);
    }

    public static function getUniversityName($uniId) {
        $criteria = new CDbCriteria;
        $criteria->select = array('uni_name');
        $criteria->compare('uni_id', $uniId);
        $res = self::model()->find($criteria);
        if (count($res) > 0)
            return $res->uni_name;
    }
	
	  public static function getUniversityDetails($uniId) {
        $criteria = new CDbCriteria;
        //$criteria->select = array('uni_name');
        $criteria->compare('uni_id', $uniId);
        $res = self::model()->find($criteria);
        if (count($res) > 0)
            return $res;
    }

    public static function getUniCountryName($uniId) {
        $criteria = new CDbCriteria;
        $criteria->select = array('country_ref_id');
        $criteria->compare('uni_id', $uniId);
        $res = self::model()->find($criteria);
        return $res->country_ref_id;
    }

    public static function getUniversityListAuto1($searchTerm, $limit = 20, $countryId = 0, $status = '') {
        $criteria = new CDbCriteria;
        $criteria->alias = 'um';
        
        if (isset($countryId) && !empty($countryId)) {
            if ($countryId <> '100')
                $criteria->condition = "um.uni_name LIKE '%$searchTerm%' AND um.country_ref_id <> 100";
            else
                $criteria->condition = "um.uni_name LIKE '%$searchTerm%' AND um.country_ref_id = 100";
        } else {
            $criteria->compare('um.uni_name', $searchTerm, true);
        }
        if($status != '')
        {
            $criteria->condition = "um.is_active = '$status'";
        }
        $criteria->group = 'um.uni_id';
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN um.uni_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), um.uni_name";
        $criteria->limit = $limit;

        $res = self::model()->findAll($criteria);
        return $res;
    }

    // Using this function in university page header search
    public static function  getUniversityListAuto2($searchTerm, $limit = 20, $status = '') {
        
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria = new CDbCriteria;
        $criteria->alias = 'um';
        $criteria->select = array('uni_id', 'uni_name', 'website_url', 'url_primary_key');
        $criteria->join = "LEFT JOIN `tag_university` tu ON um.uni_id = tu.uni_ref_id";
        $criteria->join .= " LEFT JOIN tag tg ON tg.tag_id = tu.tag_ref_id";        
        $criteria->condition = "(um.uni_name LIKE '%$searchTerm%' OR tg.tag_name LIKE '%$searchTerm%') AND um.is_active = '$status' AND um.is_user_entered='0' ";
        if(Yii::app()->user->visitorCountry != 100)
        $criteria->condition.= " AND (um.is_international_serach = 'Y' OR is_international_serach IS NULL) ";
        $criteria->group = 'um.uni_id';
        //$searchTerm = mysql_escape_string($searchTerm);
        //$criteria->order = "(CASE WHEN um.uni_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), um.uni_name";
        $criteria->order = "(CASE WHEN um.uni_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), um.uni_name, (CASE WHEN tg.tag_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), tg.tag_name";
        $criteria->limit = $limit;

        $res = self::model()->findAll($criteria);
        return $res;
    }

    public static function  getUniversityListAuto3($searchTerm, $limit = 20, $status = '', $country = '' , $dept = '') {

        $searchTerm = mysql_escape_string($searchTerm);
        $dept_cond = $country_cond = '';
        if ($country != '' && $country != 'all') {
            $country_cond = " AND t.country_ref_id = ".$country;
        }

        $criteria = new CDbCriteria;
        $criteria->select = array('uni_id', 'uni_name', 'website_url', 't.url_primary_key');
        $criteria->join = "LEFT JOIN `tag_university` tu ON t.uni_id = tu.uni_ref_id";
        $criteria->join .= " LEFT JOIN tag tg ON tg.tag_id = tu.tag_ref_id";

        if ($dept != '' && $dept != 'all') {
            $criteria->join .= " INNER JOIN tbl_uni_courses as tuc ON tuc.uni_ref_id = t.uni_id";
            $criteria->join .= " INNER JOIN lookup_department as lp ON lp.department_id = tuc.department_ref_id";

            $dept_cond = " AND lp.main_dept_id = $dept ";
        }

        $criteria->condition = "(t.uni_name LIKE '%$searchTerm%' OR tg.tag_name LIKE '%$searchTerm%') AND t.is_active = '$status' AND t.is_user_entered = '0' $country_cond $dept_cond ";


        $criteria->group = 't.uni_id';
        $criteria->order = "(CASE WHEN t.uni_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), t.uni_name";
        $criteria->limit = $limit;

        $res = self::model()->findAll($criteria);
        return $res;
    }

    /**
     * This method will return the university data with specified columns
     * @param int $id     
     * @param string $columns (optional)
     * @return array
     */
    public static function getUniversityAttributeById($id, $columns = '') {
        $criteria = new CDbCriteria();
        if (strlen($columns)) {
            $criteria->select = $columns;
        } else {
            $criteria->select = '*';
        }

        $criteria->condition = 'uni_id=:id';
        $criteria->params = array(':id' => $id);
        $data = self::model()->find($criteria);
        return $data;
    }

    /**
     * This method will return the university data with specified columns
     * @param int $id     
     * @param string $columns (optional)
     * @return array
     */
    public static function getUniversitySocialMedia($id) {
        $data = Yii::app()->db->createCommand()
                ->select('uni_ref_id, media_link, media_name, handler_text')
                ->from('university_social_media AS usm')
                ->join('lookup_social_media AS lsm', 'usm.social_media_ref_id = lsm.social_media_id')
                ->where('uni_ref_id=:id and handler_text is not null', array(':id' => $id))
                ->group('social_media_ref_id')
                ->queryAll();
        return $data;
    }

    /**
     * This method will return the University Ranking for Indian and foreign university accordingly
     * @param int $id  
     * @param int $rankLimit (optional)   
     * @return array
     */
    public static function getUniversityRanking($id, $rankLimit = 4) {
        $rankData = array();
        $countryData = self::getUniversityAttributeById($id, "country_ref_id");
        $uniCountry = $countryData->country_ref_id;

        //if ($uniCountry != '') { // if inconsistant data exist
        array_push($rankData, $uniCountry);
        if ($uniCountry != "100") { // university contry is india
            $rankData[1] = Yii::app()->db->createCommand()
                    ->select('uni_ref_id, source_name, rank_year, rank')
                    ->from('university_dept_ranking as udr')
                    ->join('lookup_rank_source as lrs', 'udr.rank_source_ref_id = lrs.rank_source_id')
                    ->where('uni_ref_id=:id', array(':id' => $id))
                    ->order('rank_year DESC, source_type,source_name ASC')
                    ->limit($rankLimit)
                    ->queryAll();
        } else { // university contry is not india
            $rankData[1] = Yii::app()->db->createCommand()
                    ->select('uni_ref_id, source_name, rank_year, rank, department_name')
                    ->from('university_dept_ranking as udr')
                    ->join('lookup_rank_source as lrs', 'udr.rank_source_ref_id = lrs.rank_source_id')
                    ->join('lookup_department as ld', 'udr.department_ref_id = ld.department_id')
                    ->where('uni_ref_id=:id', array(':id' => $id))
                    ->order('rank_year DESC')
                    ->limit($rankLimit)
                    ->queryAll();
        }
        //}
        //print_r($rankData);
        return $rankData;
    }

    /**
     * This method will return the university data with specified columns
     * @param int $id     
     * @param string $columns (optional)
     * @return array
     */
    public static function getUniversityWeather($id) {
        $criteria = new CDbCriteria();
        $criteria->select = 'winter_day_temp, winter_night_temp, spring_day_temp, spring_night_temp, summer_day_temp, summer_night_temp, autumn_day_temp, autumn_night_temp';
        $criteria->condition = "uni_ref_id=:id";
        $criteria->params = array(':id' => $id);

        $data = TblUniWeather::model()->find($criteria);
        return $data;
    }

    public static function getUniIdFromHash($hashUniId) {
        $criteria = new CDbCriteria();
        $criteria->select = 'uni_id, url_primary_key, uni_name, is_active';
        $criteria->condition = "url_primary_key=:id";
        $criteria->params = array(':id' => $hashUniId);

        $data = self::model()->find($criteria);

        $uniUrl['uni_id'] = $data->uni_id;
        $uniUrl['uni_slug_name'] = $data->uni_slug_name;
        $uniUrl['url_primary_key'] = $data->url_primary_key;
        $uniUrl['uni_name'] = $data->uni_name;
        $uniUrl['is_active'] = $data->is_active;
        
        return $uniUrl;
    }

    public function unimdmSearch() {
        
        // for outside data entry
        $criteria = new CDbCriteria;
        $criteria->with = array('countryRef', 'stateRef', 'cityRef');
        
        if(Yii::app()->session->get('admin_role_name') == 'External Data Entry'){
            $criteria->compare('t.added_by', Yii::app()->user->id);
        }
        
        $criteria->compare('uni_id', $this->uni_id);
        $criteria->compare('countryRef.country_name', $this->country_search, true);
        $criteria->compare('stateRef.name', $this->state_search, true);
        $criteria->compare('cityRef.city_name', $this->city_search, true);
        $criteria->compare('uni_name', $this->uni_name, true);

        return new CActiveDataProvider($this, array(
                    'criteria' => $criteria,
                    'pagination' => array(
                        'pageSize' => 30,
                        'pageVar' => 'page',
                    ),
                    'sort' => array(
                        'defaultOrder' => 'uni_name',
                        'sortVar' => 'sort',
                        'attributes' => array(
                            'uni_name',
                            'added_on',
                            'is_active',
                            'country_search' => array(
                                'asc' => 'countryRef.country_name',
                                'desc' => 'countryRef.country_name DESC',
                            ),
                            'state_search' => array(
                                'asc' => 'stateRef.name',
                                'desc' => 'stateRef.name DESC',
                            ),
                            'city_search' => array(
                                'asc' => 'cityRef.city_name',
                                'desc' => 'cityRef.city_name DESC',
                            )
                        ),
                    ),
                ));
    }

    public static function getUniversityUrlData($uniId, $byUniHash = 0) {
        $criteria = new CDbCriteria();
        $criteria->select = 'uni_id, uni_name, uni_slug_name, url_primary_key, seo_keyword';
        
        if($byUniHash) {
            $criteria->condition = "t.url_primary_key=:id";
            $criteria->params = array(':id' => $uniId);
        } else {
            $criteria->condition = "uni_id=:id";
            $criteria->params = array(':id' => $uniId);
        }
        
        

        $data = self::model()->with('countryRef')->find($criteria);

        $uniUrlData['url_primary_key'] = $data->url_primary_key;
        $uniUrlData['country_code'] = $data->countryRef->country_code;
        $uniUrlData['keyword'] = $data->seo_keyword;
        $uniUrlData['uni_name'] = $data->uni_name;

        $topDept = self::getTopDepartmentNameByUniId($uniId);
        $uniUrlData['department_name'] = $topDept['department_name'];

        return $uniUrlData;
    }

    public static function getTopDepartmentNameByUniId($uniId) {

        $topDept = Yii::app()->db->createCommand()
                ->select('main.department_name, COUNT(*) cnt')
                ->from('tbl_uni_courses AS uc')
                ->join('lookup_department AS sub', 'uc.department_ref_id = sub.department_id')
                ->join('lookup_department AS main', 'main.department_id = sub.main_dept_id')
                ->where('uni_ref_id=:id', array(':id' => $uniId))
                ->group('main.department_id')
                ->order('cnt DESC')
                ->limit("1")
                ->queryRow();
        //print_r($topDept);
        return $topDept;
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'uni_id' => 'Uni',
            'uni_code' => 'Uni Code',
            'uni_name' => 'University Name',
            'url_primary_key' => 'Url Primary Key',
            'uni_country_rank' => 'Uni Country Rank',
            'uni_global_rank' => 'Uni Global Rank',
            'global_display_rank' => 'Global Display Rank',
            'uni_rank_factor' => 'Uni Rank Factor',
            'uni_slug_name' => 'Uni Slug Name',
            'uni_logo' => 'University Logo',
            'uni_profile' => 'University Profile',
            'coed' => 'Coed',
            'university_affiliation_ref_id' => 'University Affiliation Ref',
            'type_of_institute' => 'Type Of Institute',
            'institute_control_ref_id' => 'Institute Control',
            'address' => 'Address',
            'address1' => 'Address Line 1',
            'address2' => 'Address Line 2',
            'state_ref_id' => 'State',
            'city_ref_id' => 'City',
            'zipcode' => 'Zipcode',
            'country_ref_id' => 'Country',
            'location_type' => 'Location Type',
            'website_url' => 'Website Url',
            'admission_url' => 'Admission Url',
            'course_page_url' => 'Course Page Url',
            'application_url' => 'Application Url',
            'calender_system' => 'Calender System',
            'international_stud_total' => 'International Student Total',
            'international_stud_total_men' => 'International Student Total Men',
            'international_stud_total_women' => 'International Student Total Women',
            'international_stud_per' => 'International Student Percentage',
            'total_students' => 'Total Students',
            'full_time_per' => 'Full Time Percentage',
            'part_time_per' => 'Part Time Percentage',
            'male_per' => 'Male Percentage',
            'female_per' => 'Female Percentage',
            'flagship_subjects_courses' => 'Flagship Subjects Courses',
            'flagship_subjects_courses_url' => 'Flagship Subjects Courses Url',
            'admission_cycle_cnt' => 'Admission Cycle Cnt',
            'acceptance_rate' => 'Acceptance Rate',
            'total_applicants' => 'Total Applicants',
            'total_enrolled_people' => 'Total Enrolled People',
            'enrolment_ratio' => 'Enrolment Ratio',
            'job_placement_per_pg' => 'Job Placement Per Pg',
            'test_needed' => 'Test Needed',
            'likelihood_scholarship' => 'Likelihood Scholarship',
            'living_cost_in_city' => 'Living Cost In City',
            'living_cost_on_campus' => 'Living Cost On Campus',
            'vintage' => 'Establishment Year',
            'no_of_campus' => 'No Of Campus',
            'main_campus_size_in_acres' => 'Main Campus Size In Acres',
            'campus_look_n_feel' => 'Campus Look N Feel',
            'campus_link' => 'Campus Link',
            'on_site_residence' => 'On Site Residence',
            'student_professor_ratio' => 'Student Professor Ratio',
            'longitude' => 'Longitude',
            'latitude' => 'Latitude',
            'media_reports' => 'Media Reports',
            'placement_article_link' => 'Placement Article Link',
            'low_sal_range' => 'Low Sal Range',
            'low_sal_range_currency_ref_id' => 'Low Sal Range Currency Ref',
            'high_sal_range' => 'High Salary Range',
            'high_sal_range_currency_ref_id' => 'High Sal Range Currency Ref',
            'avg_salary' => 'Avg Salary',
            'avg_salary_currency_ref_id' => 'Avg Salary Currency Ref',
            'median_salary' => 'Median Salary',
            'median_salary_currency_ref_id' => 'Median Salary Currency Ref',
            'high_domestic_salary' => 'High Domestic Salary',
            'high_domestic_salary_currency_ref_id' => 'High Domestic Salary Currency Ref',
            'high_international_salary' => 'High International Salary',
            'high_international_salary_currency_ref_id' => 'High International Salary Currency Ref',
            'admission_comments' => 'Admission Comments',
            'is_twining' => 'Is Twining',
            'is_active' => 'Is Active',
            'added_on' => 'Added On',
            'added_by' => 'Added By',
            'modified_on' => 'Modified On',
            'modified_by' => 'Modified By',
            'uni_join'=>'Why Join',
            'uni_rating' => 'University Rating',
            'campus_life'=>'Campus Life',
        );
    }

    public function getUniqueUrlPrimarykey($var1, $var2) {
        static $count = 0;
        $gereratedKey = hash('crc32b', $var1 . $var2);
        $rowData = TblUniversityMaster::model()->find('url_primary_key ="' . $gereratedKey . '"');
        $count++;
        if (!$rowData->uni_id) {
            return $gereratedKey;
        } else {
            echo $var2 = $var2 . $count;
            return $this->getUniqueUrlPrimarykey($var1, $var2);
        }
    }
    
    public static function getUniversityNameList(){
        $criteria=New CDbCriteria;
        $criteria->select='uni_id,uni_name';
        $criteria->condition ='is_active="Y"';
        $criteria->order= 'uni_name';
        $data =  self::model()->findAll($criteria);
        foreach($data as $value){
            $universityList[$value->attributes['uni_id']] = $value->attributes['uni_name'];
        }
        return $universityList;
    }

    public  static function getUniversityListByDepartment($departmentId=0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->join = "INNER JOIN tbl_uni_courses uc ON uc.uni_ref_id = t.uni_id";
        $cdbCriteria->addCondition("uc.department_ref_id = ".$departmentId, "AND");
        $cdbCriteria->group = "t.uni_id";
        $cdbCriteria->order = "t.uni_id";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public  static function getUniversityListByCountryDept($country=0,$departmentId=0){
        $sql ="SELECT DISTINCT t.uni_id,t.uni_name FROM tbl_university_master t
			    INNER JOIN tbl_uni_courses uc ON uc.uni_ref_id = t.uni_id
			    INNER JOIN lookup_department ld ON ld.department_id = uc.department_ref_id
--			    INNER JOIN lookup_department ld1 ON ld1.department_id = ld.main_dept_id
			    WHERE t.country_ref_id = :countryId AND ld.main_dept_id = :departmentId AND uc.course_level = '6' ORDER BY t.uni_name ASC";
        $command =Yii::app()->db->createCommand($sql);
        $command->bindValue(":countryId", $country, PDO::PARAM_INT);
        $command->bindValue(":departmentId", $departmentId, PDO::PARAM_INT);
        $res =$command->queryAll();

        return $res;
    }

    public  static function getUniversityListByPopularMainDept($countryId=0,$departmentId=0,$courseLevel=0){
        $cdbCriteria = new CDbCriteria();
        //$cdbCriteria->select = 'uni_id,uni_name';
        $cdbCriteria->join = "INNER JOIN tbl_uni_courses uc ON uc.uni_ref_id = t.uni_id
        INNER JOIN lookup_course_level lcl ON lcl.level_id = uc.course_level
        INNER JOIN lookup_popular_courses lpc ON lpc.department_ref_id = uc.department_ref_id
        INNER JOIN lookup_department ld ON ld.department_id = uc.department_ref_id";
        $cdbCriteria->addCondition("t.country_ref_id IN (".$countryId.")", "AND");
        $cdbCriteria->addCondition("ld.main_dept_id IN (".$departmentId.")", "AND");
        $cdbCriteria->addCondition("lcl.parent_ref_id IN (".$courseLevel.")", "AND");
        $cdbCriteria->group = "t.uni_name";
        $cdbCriteria->order = "t.uni_name";

        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getCollegeSearchResult($offset = 0, $limit = 0,$params){
        $singleval=0;
        $condition = array();
        if($params['state'] != '' && ($params['country'] == 100 || $params['country'] == 224 || $params['country'] == 222)) {
            $params_state_csv = implode(',',$params['state']);
            $condition['11']  = " t.state_ref_id IN ($params_state_csv)";
        }
        $paramss = '';
        if($params['city'] != '' && ($params['country'] == 100 || $params['country'] == 224 || $params['country'] == 222)) {
            $paramss = implode(',',$params['city']);
            $condition['0']  = " t.state_ref_id IN ($paramss)";
        }
        if($params['city'] != '') {
            $params_csv = implode(',',$params['city']);
            $condition['0']  = " t.city_ref_id  IN  ($params_csv)";
        }
        if($params['study_level'] != '') {
            $condition['1']  = " tuc.course_level = ". $params['study_level'];
        }
        if($params['department'] != '') {
            $condition['3'] = " ld.main_dept_id = ". $params['department'];
        }
        if($params['subDeptId'] != '') {
            $condition['2']  = " tuc.department_ref_id= ". $params['subDeptId'];
        }
        if($params['location_type']!=''){
            $condition['4'] = "( t.location_type = '". $params['location_type']."' OR t.location_type IS NULL OR t.location_type ='')";
        }
        if($params['uni_gender']!=''){
            $condition['5'] = " (t.coed = '". $params['uni_gender']."' OR t.coed IS NULL OR t.coed ='')";
        }
        if($params['college_size']!=''){
            if($params['college_size']=='Small'){
                $condition['6'] = ' ((t.total_students >=0 AND t.total_students <=1999) OR t.total_students IS NULL OR t.total_students ="")';
            }elseif($params['college_size']=='Medium'){
                $condition['6'] = ' ((t.total_students >=2000 AND t.total_students <=15000) OR t.total_students IS NULL OR t.total_students ="")';
            }elseif($params['college_size']=='Large'){
                $condition['6'] = ' (t.total_students>15000 OR t.total_students IS NULL OR t.total_students ="")';
            }
        }
        if($params['international_student']!=''){
            if($params['international_student']=='Low'){
                $condition['7'] = ' (t.international_stud_per < 10 OR t.international_stud_per IS NULL OR t.international_stud_per ="")';
            }elseif($params['international_student']=='Medium'){
                $condition['7'] = ' (t.international_stud_per >= 10 AND t.international_stud_per <= 30 OR t.international_stud_per IS NULL OR t.international_stud_per ="")';
            }elseif($params['international_student']=='High'){
                $condition['7'] = ' (t.international_stud_per>30 OR t.international_stud_per IS NULL OR t.international_stud_per ="")';
            }
        }
        if($params['vintage']!=''){
            if($params['vintage']=='Low'){

                $condition['8'] = ' (t.vintage >'.(date('Y')-10).' OR t.vintage IS NULL OR t.vintage ="")';
            }elseif($params['vintage']=='Medium'){

                $condition['8'] = ' (t.vintage >='.(date('Y')-30).' AND t.vintage <='.(date('Y')-10).' OR t.vintage IS NULL OR t.vintage ="")';
            }elseif($params['vintage']=='High'){

                $condition['8'] = ' (t.vintage<'.(date('Y')-30).' OR t.vintage IS NULL OR t.vintage ="")';
            }
        }
        if($params['acceptance_rate']!=''){
            if($params['acceptance_rate']=='Low'){
                $condition['9'] = ' (t.acceptance_rate < 25 OR t.acceptance_rate IS NULL OR t.acceptance_rate ="")';
            }elseif($params['acceptance_rate']=='Medium'){
                $condition['9'] = ' (t.acceptance_rate >= 25 AND t.acceptance_rate <= 50 OR t.acceptance_rate IS NULL OR t.acceptance_rate ="")';
            }elseif($params['acceptance_rate']=='High'){
                $condition['9'] = ' (t.acceptance_rate > 50 OR t.acceptance_rate IS NULL OR t.acceptance_rate ="")';
            }
        }
        if($params['popular_course'] != '') {
            $condition['10'] = " ld.department_name = '". $params['popular_course']. "'";
        }
        if(count($condition)!=0){
            $finalCondition = implode(' AND ', $condition);
        }else{
            $finalCondition = '1=1';
        }
        $offset = $offset;
        if($limit)
            $limit = $limit;

        if($params['department']!=''){
            $order = 'ORDER BY deptRank ASC';
        }else{
            $order = 'ORDER BY  uni_country_rank ASC';
        }
        $sql = 'SELECT t.uni_name , t.uni_id, tc.country_name, ts.name, tcm.city_name, t.url_primary_key, uni_logo, CAST(IFNULL(uni_country_rank,999999) AS UNSIGNED) as uni_country_rank ,CAST(IFNULL(udr.rank,999999) AS UNSIGNED) as deptRank
                    FROM tbl_university_master t
                    INNER JOIN tbl_country_master tc ON  tc.country_id = t.country_ref_id
                    LEFT JOIN tbl_state ts ON  ts.id = t.state_ref_id
                    LEFT JOIN tbl_city_master tcm ON tcm.city_id = t.city_ref_id
                    LEFT JOIN tbl_uni_courses as tuc ON tuc.uni_ref_id = t.uni_id
                    LEFT JOIN lookup_department as ld ON tuc.department_ref_id = ld.department_id
                    LEFT JOIN university_dept_ranking udr ON udr.uni_ref_id = t.uni_id AND udr.department_ref_id = ld.main_dept_id AND udr.rank_year is NULL
                    WHERE t.is_active="Y" AND tuc.course_level = 6 AND t.country_ref_id= '. $params['country']. ' AND ' .$finalCondition.' AND tuc.is_active="Y" GROUP BY uni_id '.$order.' LIMIT  '.$offset.' , '.$limit
        ;



        $result = Yii::app()->db->createCommand($sql)->queryAll();

        return $result;


//            $criteria = new CDbCriteria;
//            // Often used in search functions. Note: if passed value is empty, the WHERE is not added!
//            $criteria->distinct =true;
//            $criteria->select ='t.uni_name,t.uni_id,t.url_primary_key,uni_logo';
//            $criteria->with = array('cityRef','stateRef','countryRef');
//            $criteria->join = 'LEFT JOIN tbl_uni_courses as tuc ON t.uni_id = tuc.uni_ref_id
//                               LEFT JOIN lookup_department as ld ON tuc.department_ref_id = ld.department_id';
//            $criteria->addCondition('t.is_active="Y"');
//            $criteria->compare('t.country_ref_id', $params['country']);
//            $criteria->compare('t.city_ref_id', $params['city']);
//            //$criteria->compare('scholarshipDepartments.sub_dept_ref_id', $params['sub_dept'],true);
//            $criteria->compare('t.location_type', $params['location_type']);
//            $criteria->compare('t.coed', $params['uni_gender']);
//            $criteria->compare('tuc.course_level', $params['study_level']);
//            $criteria->compare('ld.main_dept_id', $params['mainDepartment']);
//            if($params['uni_gender']!=''){
//               // $criteria->addInCondition('t.gender', array('All',$params['gender']));
//                $criteria->addCondition('t.coed="'.$params['uni_gender'].'"');
//            }
//            if($params['college_size']!=''){
//                if($params['college_size']=='Small'){
//                    $criteria->addBetweenCondition('t.total_students', 0,1999);
//                }elseif($params['college_size']=='Medium'){
//                    $criteria->addBetweenCondition('t.total_students', 2000,15000);
//                }elseif($params['college_size']=='Large'){
//                    $criteria->addCondition('t.total_students>15000');
//                }
//            }
//            if($params['international_student']!=''){
//                if($params['international_student']=='Low'){
//                   $criteria->addCondition('t.international_stud_per < 10');
//                }elseif($params['international_student']=='Medium'){
//                    $criteria->addBetweenCondition('t.international_stud_per', 10,30);
//                }elseif($params['international_student']=='High'){
//                    $criteria->addCondition('t.international_stud_per>30');
//                }
//            }
//            if($params['vintage']!=''){
//                if($params['vintage']=='Low'){
//                   $criteria->addCondition('t.vintage >'.(date('Y')-10));
//                }elseif($params['vintage']=='Medium'){
//                    $criteria->addBetweenCondition('t.vintage', date('Y')-30,date('Y')-10);
//                }elseif($params['vintage']=='High'){
//                    $criteria->addCondition('t.vintage<'.(date('Y')-30));
//                }
//            }
//            if($params['acceptance_rate']!=''){
//               if($params['acceptance_rate']=='Low'){
//                   $criteria->addCondition('t.acceptance_rate < 25');
//                }elseif($params['acceptance_rate']=='Medium'){
//                    $criteria->addBetweenCondition('t.acceptance_rate', 25,50);
//                }elseif($params['acceptance_rate']=='High'){
//                    $criteria->addCondition('t.acceptance_rate > 50');
//                }
//            }
//            if($returnAsGrid){
//                return new CActiveDataProvider(TblUniversityMaster::model(), array(
//                    'criteria'=>$criteria,
//                    'pagination'=>array(
//                        'pageSize'=>$pageLimit,
//                    ),
//                ));
//            }else{
//                return self::model()->findAll($criteria);
//            }
    }

    public static function getExpandUniversityBlockDetails($uniId){
        $universityData = self::getUniversityAttributeById($uniId, 'uni_id, uni_name, vintage, country_ref_id, state_ref_id, city_ref_id, university_affiliation_ref_id, institute_control_ref_id, total_students, acceptance_rate, international_stud_per');
        $universityDetails = array();
        $universityDetails['uni_name'] = $universityData->uni_name;
        $universityDetails['uni_id'] = $universityData->uni_id;
        $universityDetails['vintage'] = $universityData->vintage;
        $universityDetails['country'] = $universityData->countryRef->country_name;
        $universityDetails['state'] = $universityData->stateRef->name ? $universityData->stateRef->name.", " : '';
        $universityDetails['city'] = $universityData->cityRef->city_name ? $universityData->cityRef->city_name.", " : '';
        $universityDetails['country_ref_id'] = $universityData->country_ref_id;
        
        if($universityData->country_ref_id == 100) {
            $universityDetails['affiliation'] = $universityData->universityAffiliationRef->univeristy_name;
            $universityDetails['inst_control'] = $universityData->instituteControlRef->control_name;
        } else {
            $universityDetails['total_students'] = $universityData->total_students;
            $universityDetails['acceptance_rate'] = $universityData->acceptance_rate;
            $universityDetails['international_stud_per'] = $universityData->international_stud_per;
        }
        
        return $universityDetails;
    }

    public static function getUniCountryCityState($uniId) {
        $universityData = self::getUniversityAttributeById($uniId, 'uni_id, uni_name, country_ref_id, state_ref_id, city_ref_id');
        $universityDetails = array();
        $universityDetails['uni_name'] = $universityData->uni_name;
        $universityDetails['uni_id'] = $universityData->uni_id;
        $universityDetails['country'] = $universityData->countryRef->country_name;
        $universityDetails['state'] = $universityData->stateRef->name ? $universityData->stateRef->name.", " : '';
        $universityDetails['city'] = $universityData->cityRef->city_name ? $universityData->cityRef->city_name.", " : '';
        return $universityDetails;
    }
	public static function getUniversitySearchList($universityId = false){
        $universityList  = self::model()->find('uni_id=:universityId',array('universityId'=>$universityId));
       return $universityList->uni_id;
    }
    public static function getUniversitySearchLists($universityId = false){
        $universityList  = self::model()->find('uni_id=:universityId',array('universityId'=>$universityId));
         return $universityList;
    }

    public function searchUniversity($search, $country, $dept) {
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 'uni_id, uni_name';
        $cdbCriteria->join = 'INNER JOIN tbl_uni_courses as tuc on tuc.uni_ref_id = t.uni_id INNER JOIN lookup_department as ld on ld.department_id = tuc.department_ref_id';
        $cdbCriteria->addCondition("t.country_ref_id = ".$country." ", "AND");
        $cdbCriteria->addCondition("ld.parent_dept_id = ".$dept." ", "AND");
        $cdbCriteria->addCondition("t.uni_name LIKE  '%".$search."%' ", "AND");
        $cdbCriteria->addCondition("t.is_active = 'Y'", "AND");

        $return = array();
        $result = self::model()->findAll($cdbCriteria);
        foreach ($result as $data) {
            $op = array(
                'id' => $data->uni_id,
                'value' => $data->uni_name,
            );
            $return[$data->uni_id] = $op;
        }
        return array_values($return);
    }

    public function searchUniversities($search, $country = '', $dept = '', $exclude = '') {
        $searchTerm = mysql_escape_string($search);
        $criteria = new CDbCriteria;
        $criteria->alias = 'um';
        $criteria->select = array('uni_id', 'uni_name', 'website_url', 'url_primary_key');
        $criteria->join = "LEFT JOIN `tag_university` tu ON um.uni_id = tu.uni_ref_id";
        $criteria->join .= " LEFT JOIN tag tg ON tg.tag_id = tu.tag_ref_id";
        $criteria->condition = "(um.uni_name LIKE '%$searchTerm%' OR tg.tag_name LIKE '%$searchTerm%') AND um.is_active = 'Y'";
        $criteria->group = 'um.uni_id';
        $criteria->order = "(CASE WHEN um.uni_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), um.uni_name";

        $criteria->limit = 10;

        $res = self::model()->findAll($criteria);

        foreach ($res as $data) {
            $op = array(
                'id' => $data->uni_id,
                'value' => $data->uni_name,
            );
            $return[$data->uni_id] = $op;
        }
        return array_values($return);
    }
    
    public static function getUserFeaturedUni($userId, $limit = 5) {
        $prefCountry = StudentPreferredCountry::getStdCountryPrefByPrefOrder($userId, 1);
        $prefCountry = $prefCountry->country_ref_id;

        $prefDepartment = StudentPreferredDepartment::getStdDepartmentPrefByPrefOrder($userId, 1);
        $prefDepartment = $prefDepartment->main_dept_ref_id;

        if($prefCountry && $prefDepartment) {
            $data = Yii::app()->db->createCommand()
						->selectDistinct('uni_name, uni_id, tum.url_primary_key, country_name, city_name, name, LPAD(SUBSTRING_INDEX(rank, "-", 1), 5, "0") AS new_rank')
						->from('tbl_university_master AS tum ')
						->join('tbl_uni_courses AS tuc', 'tuc.uni_ref_id = tum.uni_id')
						->join('lookup_department AS sub', 'sub.department_id = tuc.department_ref_id')
						->join('lookup_department AS main', 'main.department_id = sub.main_dept_id')
						->leftJoin('university_dept_ranking AS udr', 'udr.uni_ref_id = tum.uni_id AND udr.department_ref_id = sub.main_dept_id')
						->leftJoin('tbl_country_master AS tcm', 'tcm.country_id = tum.country_ref_id')
						->leftJoin('tbl_city_master AS citym', 'citym.city_id = tum.city_ref_id')
						->leftJoin('tbl_state AS ts', 'ts.id = tum.state_ref_id')
						->where("tum.country_ref_id = ". $prefCountry ." AND main.department_id = ". $prefDepartment ." AND rank_source_ref_id  IS NULL AND is_featured = 1 AND rank IS NOT NULL ")
						->order('new_rank')
						->limit($limit)
						->queryAll();
        } elseif($prefCountry) {
            $data = Yii::app()->db->createCommand()
                                ->selectDistinct('uni_name, uni_id, tum.url_primary_key, country_name, city_name, name')
                                ->from('tbl_university_master AS tum ')
                                ->leftJoin('tbl_country_master AS tcm', 'tcm.country_id = tum.country_ref_id')
                                ->leftJoin('tbl_city_master AS citym', 'citym.city_id = tum.city_ref_id')
                                ->leftJoin('tbl_state AS ts', 'ts.id = tum.state_ref_id')
                                ->where("tum.country_ref_id = ". $prefCountry ." AND is_featured = 1")
                                ->limit($limit)
                                ->queryAll();
        } elseif($prefDepartment) {
            $data = Yii::app()->db->createCommand()
                                ->selectDistinct('uni_name, uni_id, tum.url_primary_key, country_name, city_name, name')
                                ->from('tbl_university_master AS tum ')
                                ->join('tbl_uni_courses AS tuc', 'tuc.uni_ref_id = tum.uni_id')
                                ->join('lookup_department AS sub', 'sub.department_id = tuc.department_ref_id')
                                ->join('lookup_department AS main', 'main.department_id = sub.main_dept_id')
                                ->leftJoin('tbl_country_master AS tcm', 'tcm.country_id = tum.country_ref_id')
                                ->leftJoin('tbl_city_master AS citym', 'citym.city_id = tum.city_ref_id')
                                ->leftJoin('tbl_state AS ts', 'ts.id = tum.state_ref_id')
                                ->where("is_featured = 1 AND main.department_id = ".$prefDepartment)
                                ->limit($limit)
                                ->queryAll();
        }

        if(!count($data)) { // if no data found in above cases
            $data = Yii::app()->db->createCommand()
                                ->selectDistinct('uni_name, uni_id, tum.url_primary_key, country_name, city_name, name')
                                ->from('tbl_university_master AS tum ')
                                ->leftJoin('tbl_country_master AS tcm', 'tcm.country_id = tum.country_ref_id')
                                ->leftJoin('tbl_city_master AS citym', 'citym.city_id = tum.city_ref_id')
                                ->leftJoin('tbl_state AS ts', 'ts.id = tum.state_ref_id')
                                ->where("is_featured = 1")
                                ->limit($limit)
                                ->queryAll();
        }
        
        $featuredUni = array();
        foreach($data as $datas) {
            $arr['uni_name'] = $datas['uni_name'];
            $arr['uni_id'] = $datas['uni_id'];
            $arr['url_primary_key'] = $datas['url_primary_key'];
            $arr['country'] = $datas['country_name'];
            $arr['city'] = $datas['city_name'];
            $arr['state'] = $datas['name'];
            $featuredUni[] = $arr;
        }
        return $featuredUni;
    }

    public function getDiUniversities(){
        $sql="SELECT um.uni_name,um.uni_id
              FROM tbl_university_master um
              JOIN di ON um.uni_id=di.uni_ref_id ORDER BY um.uni_name ASC";
        $cmd = Yii::app()->db->createCommand($sql);
        $result=$cmd->queryAll();
        $uniData=Array();

        foreach($result as $row)
        {
            $uniData[$row['uni_id']] = $row['uni_name'];
        }
        return $uniData;
    }
    public static function getAffiliatedUniId($uniId)
    {
        if($uniId)
        $criteria = new CDbCriteria;
        $criteria->select = "university_affiliation_ref_id";
        $criteria->condition = "uni_id =".$uniId;
        return self::model()->findAll($criteria);
    }
    public static function getAffiliatedUniversityId($affUniName)
    {
        $affUniName = addslashes($affUniName);
        if($affUniName)
        $criteria = new CDbCriteria;
        $criteria->select = "uni_id";
        $criteria->condition = "uni_name LIKE '".$affUniName."'";
        return self::model()->findAll($criteria);
    }
    public static function getUniversityOneMainDepartment($Uid){
        $sql='  SELECT tum.uni_id,tum.uni_name,tum.url_primary_key,tum.uni_slug_name,tum.uni_logo ,tum.uni_profile,tuc.course_name,tcm.country_name,ts.name,
                tc.city_name,tuc.`department_ref_id`,ld.main_dept_id ,ld1.department_name FROM `tbl_university_master` tum
                INNER JOIN `tbl_uni_courses` tuc ON tuc.uni_ref_id = tum.uni_id
                INNER JOIN `lookup_department` ld ON tuc.`department_ref_id` = ld.department_id
                JOIN `lookup_department` ld1 ON ld.main_dept_id = ld1.department_id
                JOIN `tbl_country_master` tcm ON tcm.country_id = tum.country_ref_id
                JOIN `tbl_state` ts ON ts.id = tum.state_ref_id
                LEFT JOIN `tbl_city_master` tc ON tc.city_id = tum.city_ref_id
                WHERE uni_id ='.$Uid.' GROUP BY uni_id';
        $command =Yii::app()->db->createCommand($sql);
        $res =$command->queryAll();
        return $res;
    }
    public static function getUniversityMainDepartment($Uid){
        $sql='  SELECT tum.uni_id,tum.uni_name,tum.url_primary_key,tum.uni_slug_name,tum.uni_logo ,tum.uni_profile,tuc.course_name,tcm.country_name,ts.name,
                tc.city_name,tuc.`department_ref_id`,ld.main_dept_id ,ld1.department_name FROM `tbl_university_master` tum
                INNER JOIN `tbl_uni_courses` tuc ON tuc.uni_ref_id = tum.uni_id
                INNER JOIN `lookup_department` ld ON tuc.`department_ref_id` = ld.department_id
                JOIN `lookup_department` ld1 ON ld.main_dept_id = ld1.department_id
                JOIN `tbl_country_master` tcm ON tcm.country_id = tum.country_ref_id
                JOIN `tbl_state` ts ON ts.id = tum.state_ref_id
                LEFT JOIN `tbl_city_master` tc ON tc.city_id = tum.city_ref_id
                WHERE uni_id ='.$Uid.' GROUP BY ld1.department_name';
        $command = Yii::app()->db->createCommand($sql);
        $res = $command->queryAll();
        return $res;
    }

    public function getDiCollegesByArticle($countryId = false, $deptId = false)
    {
        $sql = "SELECT DISTINCT uni_id,t.country_ref_id FROM tbl_university_master t
                INNER JOIN di ON di.uni_ref_id = t.uni_id
                INNER JOIN university_dept_ranking ur ON ur.uni_ref_id = t.uni_id
                WHERE t.country_ref_id IN (".$countryId.")
                AND ur.department_ref_id IN (".$deptId.")
                AND di.is_active = 1 AND di.is_test = 'N' AND t.is_active = 'Y'
                ORDER BY RAND() LIMIT 3";
        $result = Yii::app()->db->createCommand($sql)->queryAll();
        return $result;
    }

    public function getCollegesByArticle($countryId = false, $deptId = false)
    {
        $sql = "SELECT DISTINCT uni_id,t.country_ref_id FROM tbl_university_master t
                INNER JOIN university_dept_ranking ur ON ur.uni_ref_id = t.uni_id
                WHERE t.country_ref_id IN (".$countryId.")
                AND ur.department_ref_id IN (".$deptId.")
                AND t.is_active = 'Y' AND ur.rank_source_ref_id IS NULL AND ur.college_level = 'Top'
                ORDER BY RAND() LIMIT 3";
        $result = Yii::app()->db->createCommand($sql)->queryAll();
        return $result;
    }
    
    public static function get_popular_colleges($filters, $offset = 0, $limit = 20, $get_total = FALSE){
        $conditions = 'TblUniversityMaster.is_active = "Y"';
        $parameters = array();
        $command = Yii::app()->db->createCommand()
                ->select('TblUniversityMaster.uni_id, TblUniversityMaster.uni_code, TblUniversityMaster.uni_name, TblUniversityMaster.url_primary_key, TblUniversityMaster.seo_keyword, TblUniversityMaster.uni_slug_name, TblUniversityMaster.uni_logo, TblUniversityMaster.uni_profile, TblUniversityMaster.address, TblUniversityMaster.address1, TblUniversityMaster.address2, TblUniversityMaster.vintage AS year, TblState.name AS state_name, TblCityMaster.city_name, TblUniversityMaster.zipcode, TblCountryMaster.country_name, TblCountryMaster.country_code, CAST(`UniversityDeptRanking`.`rank` AS UNSIGNED) AS udrank')
                ->from(TblUniversityMaster::model()->tableSchema->name.' TblUniversityMaster')
                ->join(Di::model()->tableSchema->name.' Di', 'Di.uni_ref_id = TblUniversityMaster.uni_id AND Di.is_test = "N" AND Di.is_popular = "Y"')
                ->join(UniversityDeptRanking::model()->tableSchema->name.' UniversityDeptRanking', 'UniversityDeptRanking.uni_ref_id = TblUniversityMaster.uni_id AND UniversityDeptRanking.rank_source_ref_id IS NULL')
                ->leftJoin(TblState::model()->tableSchema->name.' TblState', 'TblState.id = TblUniversityMaster.state_ref_id')
                ->join(TblCityMaster::model()->tableSchema->name.' TblCityMaster', 'TblCityMaster.city_id = TblUniversityMaster.city_ref_id')
                ->join(TblCountryMaster::model()->tableSchema->name.' TblCountryMaster', 'TblCountryMaster.country_id = TblUniversityMaster.country_ref_id');
        
        if($get_total){
            $command = Yii::app()->db->createCommand()
                ->select('count(distinct(TblUniversityMaster.uni_id))')
                ->from(TblUniversityMaster::model()->tableSchema->name.' TblUniversityMaster')
                ->join(Di::model()->tableSchema->name.' Di', 'Di.uni_ref_id = TblUniversityMaster.uni_id AND Di.is_test = "N" AND Di.is_popular = "Y"')
                ->join(UniversityDeptRanking::model()->tableSchema->name.' UniversityDeptRanking', 'UniversityDeptRanking.uni_ref_id = TblUniversityMaster.uni_id  AND UniversityDeptRanking.rank_source_ref_id IS NULL')
                ->leftJoin(TblState::model()->tableSchema->name.' TblState', 'TblState.id = TblUniversityMaster.state_ref_id')
                ->join(TblCityMaster::model()->tableSchema->name.' TblCityMaster', 'TblCityMaster.city_id = TblUniversityMaster.city_ref_id')
                ->join(TblCountryMaster::model()->tableSchema->name.' TblCountryMaster', 'TblCountryMaster.country_id = TblUniversityMaster.country_ref_id');
            
            self::_apply_college_filters($command, $filters, $conditions, $parameters);
            return $command->where($conditions, $parameters)->queryScalar();
        }
        self::_apply_college_filters($command, $filters, $conditions, $parameters);
        
//        echo '<pre>';
//        $command->where($conditions, $parameters)->group('TblUniversityMaster.uni_id')->order('UniversityDeptRanking.rank ASC')->offset($offset)->limit($limit);
//        echo $command->getText(); print_r($parameters); exit;
        
        return $command->where($conditions, $parameters)->group('TblUniversityMaster.uni_id')->order('udrank ASC')->offset($offset)->limit($limit)->queryAll();
    }
    
    public static function get_top_colleges($filters, $offset = 0, $limit = 20, $get_total = FALSE){
        $conditions = 'TblUniversityMaster.is_active = "Y"';
        $parameters = array();
        
        $command = Yii::app()->db->createCommand()
                ->select('TblUniversityMaster.uni_id, TblUniversityMaster.uni_code, TblUniversityMaster.uni_name, TblUniversityMaster.url_primary_key, TblUniversityMaster.seo_keyword, TblUniversityMaster.uni_slug_name, TblUniversityMaster.uni_logo, TblUniversityMaster.uni_profile, TblUniversityMaster.address, TblUniversityMaster.address1, TblUniversityMaster.address2, TblUniversityMaster.vintage AS year, TblState.name AS state_name, TblCityMaster.city_name, TblUniversityMaster.zipcode, TblCountryMaster.country_name, TblCountryMaster.country_code, CAST(`UniversityDeptRanking`.`rank` AS UNSIGNED) AS udrank')
                ->from(TblUniversityMaster::model()->tableSchema->name.' TblUniversityMaster')
                ->join(UniversityDeptRanking::model()->tableSchema->name.' UniversityDeptRanking', 'UniversityDeptRanking.uni_ref_id = TblUniversityMaster.uni_id AND UniversityDeptRanking.college_level = "TOP"  AND UniversityDeptRanking.rank_source_ref_id IS NULL')
                ->leftJoin(TblState::model()->tableSchema->name.' TblState', 'TblState.id = TblUniversityMaster.state_ref_id')
                ->join(TblCityMaster::model()->tableSchema->name.' TblCityMaster', 'TblCityMaster.city_id = TblUniversityMaster.city_ref_id')
                ->join(TblCountryMaster::model()->tableSchema->name.' TblCountryMaster', 'TblCountryMaster.country_id = TblUniversityMaster.country_ref_id');
        
        if($get_total){
            $command = Yii::app()->db->createCommand()
                ->select('count(distinct(TblUniversityMaster.uni_id))')
                ->from(TblUniversityMaster::model()->tableSchema->name.' TblUniversityMaster')
                ->join(UniversityDeptRanking::model()->tableSchema->name.' UniversityDeptRanking', 'UniversityDeptRanking.uni_ref_id = TblUniversityMaster.uni_id AND UniversityDeptRanking.college_level = "TOP"  AND UniversityDeptRanking.rank_source_ref_id IS NULL')
                ->leftJoin(TblState::model()->tableSchema->name.' TblState', 'TblState.id = TblUniversityMaster.state_ref_id')
                ->join(TblCityMaster::model()->tableSchema->name.' TblCityMaster', 'TblCityMaster.city_id = TblUniversityMaster.city_ref_id')
                ->join(TblCountryMaster::model()->tableSchema->name.' TblCountryMaster', 'TblCountryMaster.country_id = TblUniversityMaster.country_ref_id');
            
            self::_apply_college_filters($command, $filters, $conditions, $parameters);
            return $command->where($conditions, $parameters)->queryScalar();            
        }
        self::_apply_college_filters($command, $filters, $conditions, $parameters);

//        echo '<pre>';
//        $command->where($conditions, $parameters)->group('TblUniversityMaster.uni_id')->order('UniversityDeptRanking.rank ASC')->offset($offset)->limit($limit);
//        echo $command->getText(); print_r($parameters); exit;
        
        return $command->where($conditions, $parameters)->group('TblUniversityMaster.uni_id')->order('udrank ASC')->offset($offset)->limit($limit)->queryAll();
    }
    
    public static function get_mid_level_colleges($filters, $offset = 0, $limit = 20, $get_total = FALSE){
        $conditions = 'TblUniversityMaster.is_active = "Y"';
        $parameters = array();
        
        $command = Yii::app()->db->createCommand()
                ->select('TblUniversityMaster.uni_id, TblUniversityMaster.uni_code, TblUniversityMaster.uni_name, TblUniversityMaster.url_primary_key, TblUniversityMaster.seo_keyword, TblUniversityMaster.uni_slug_name, TblUniversityMaster.uni_logo, TblUniversityMaster.uni_profile, TblUniversityMaster.address, TblUniversityMaster.address1, TblUniversityMaster.address2, TblUniversityMaster.vintage AS year, TblState.name AS state_name, TblCityMaster.city_name, TblUniversityMaster.zipcode, TblCountryMaster.country_name, TblCountryMaster.country_code, CAST(`UniversityDeptRanking`.`rank` AS UNSIGNED) AS udrank')
                ->from(TblUniversityMaster::model()->tableSchema->name.' TblUniversityMaster')
                ->join(UniversityDeptRanking::model()->tableSchema->name.' UniversityDeptRanking', 'UniversityDeptRanking.uni_ref_id = TblUniversityMaster.uni_id AND UniversityDeptRanking.college_level = "Middle"  AND UniversityDeptRanking.rank_source_ref_id IS NULL')
                ->leftJoin(TblState::model()->tableSchema->name.' TblState', 'TblState.id = TblUniversityMaster.state_ref_id')
                ->join(TblCityMaster::model()->tableSchema->name.' TblCityMaster', 'TblCityMaster.city_id = TblUniversityMaster.city_ref_id')
                ->join(TblCountryMaster::model()->tableSchema->name.' TblCountryMaster', 'TblCountryMaster.country_id = TblUniversityMaster.country_ref_id');
        
        if($get_total){
            $command = Yii::app()->db->createCommand()
                ->select('count(distinct(TblUniversityMaster.uni_id))')
                ->from(TblUniversityMaster::model()->tableSchema->name.' TblUniversityMaster')
                ->join(UniversityDeptRanking::model()->tableSchema->name.' UniversityDeptRanking', 'UniversityDeptRanking.uni_ref_id = TblUniversityMaster.uni_id AND UniversityDeptRanking.college_level = "Middle"  AND UniversityDeptRanking.rank_source_ref_id IS NULL')
                ->leftJoin(TblState::model()->tableSchema->name.' TblState', 'TblState.id = TblUniversityMaster.state_ref_id')
                ->join(TblCityMaster::model()->tableSchema->name.' TblCityMaster', 'TblCityMaster.city_id = TblUniversityMaster.city_ref_id')
                ->join(TblCountryMaster::model()->tableSchema->name.' TblCountryMaster', 'TblCountryMaster.country_id = TblUniversityMaster.country_ref_id');
            
            self::_apply_college_filters($command, $filters, $conditions, $parameters);
            return $command->where($conditions, $parameters)->queryScalar();
        }
        self::_apply_college_filters($command, $filters, $conditions, $parameters);
//        echo '<pre>';
//        $command->where($conditions, $parameters)->group('TblUniversityMaster.uni_id')->order('UniversityDeptRanking.rank ASC')->offset($offset)->limit($limit);
//        echo $command->getText(); print_r($parameters); exit;
        
        return $command->where($conditions, $parameters)->group('TblUniversityMaster.uni_id')->order('udrank ASC')->offset($offset)->limit($limit)->queryAll();
    }
    
    public static function get_best_emerging_colleges($filters, $offset = 0, $limit = 20, $get_total = FALSE){
        $conditions = 'TblUniversityMaster.is_active = "Y" ';
        $parameters = array();
        
        $command = Yii::app()->db->createCommand()
                ->select('TblUniversityMaster.uni_id, TblUniversityMaster.uni_code, TblUniversityMaster.uni_name, TblUniversityMaster.url_primary_key, TblUniversityMaster.seo_keyword, TblUniversityMaster.uni_slug_name, TblUniversityMaster.uni_logo, TblUniversityMaster.uni_profile, TblUniversityMaster.address, TblUniversityMaster.address1, TblUniversityMaster.address2, TblUniversityMaster.vintage AS year, TblState.name AS state_name, TblCityMaster.city_name, TblUniversityMaster.zipcode, TblCountryMaster.country_name, TblCountryMaster.country_code, CAST(`UniversityDeptRanking`.`rank` AS UNSIGNED) AS udrank')
                ->from(TblUniversityMaster::model()->tableSchema->name.' TblUniversityMaster')
                ->join(UniversityDeptRanking::model()->tableSchema->name.' UniversityDeptRanking', 'UniversityDeptRanking.uni_ref_id = TblUniversityMaster.uni_id AND UniversityDeptRanking.college_level = "Cost Effective"  AND UniversityDeptRanking.rank_source_ref_id IS NULL')
                ->leftJoin(TblState::model()->tableSchema->name.' TblState', 'TblState.id = TblUniversityMaster.state_ref_id')
                ->join(TblCityMaster::model()->tableSchema->name.' TblCityMaster', 'TblCityMaster.city_id = TblUniversityMaster.city_ref_id')
                ->join(TblCountryMaster::model()->tableSchema->name.' TblCountryMaster', 'TblCountryMaster.country_id = TblUniversityMaster.country_ref_id');
                
        if($get_total){
            $command = Yii::app()->db->createCommand()
                ->select('count(distinct(TblUniversityMaster.uni_id))')
                ->from(TblUniversityMaster::model()->tableSchema->name.' TblUniversityMaster')
                ->join(UniversityDeptRanking::model()->tableSchema->name.' UniversityDeptRanking', 'UniversityDeptRanking.uni_ref_id = TblUniversityMaster.uni_id AND UniversityDeptRanking.college_level = "Cost Effective"  AND UniversityDeptRanking.rank_source_ref_id IS NULL')
                ->leftJoin(TblState::model()->tableSchema->name.' TblState', 'TblState.id = TblUniversityMaster.state_ref_id')
                ->join(TblCityMaster::model()->tableSchema->name.' TblCityMaster', 'TblCityMaster.city_id = TblUniversityMaster.city_ref_id')
                ->join(TblCountryMaster::model()->tableSchema->name.' TblCountryMaster', 'TblCountryMaster.country_id = TblUniversityMaster.country_ref_id');
            
            self::_apply_college_filters($command, $filters, $conditions, $parameters);
            return $command->where($conditions, $parameters)->queryScalar();
        }
        self::_apply_college_filters($command, $filters, $conditions, $parameters);
//        echo '<pre>';
//        $command->where($conditions, $parameters)->group('TblUniversityMaster.uni_id')->order('UniversityDeptRanking.rank ASC')->offset($offset)->limit($limit);
//        echo $command->getText(); print_r($parameters); exit;
        
        return $command->where($conditions, $parameters)->group('TblUniversityMaster.uni_id')->order('udrank ASC')->offset($offset)->limit($limit)->queryAll();
    }
    
    private static function _apply_college_filters(&$command, $filters, &$conditions, &$parameters){
        
        if(isset($filters['locations']) && $filters['locations']){
            if(!is_array($filters['locations'])) $filters['locations'] = array($filters['locations']);
            $conditions .= ' AND TblState.id IN ('.implode(',', $filters['locations']).')';
        }
        
        if(isset($filters['country_ref_id']) && $filters['country_ref_id']){
            $conditions .= ' AND TblUniversityMaster.country_ref_id = :country_id'; $parameters[':country_id'] = $filters['country_ref_id'];
        }
        
        if(isset($filters['branches']) && $filters['branches']){
            if(!is_array($filters['branches'])) $filters['branches'] = array($filters['branches']);
            $command->join(TblUniCourses::model()->tableSchema->name.' TblUniCourses', 'TblUniCourses.uni_ref_id = TblUniversityMaster.uni_id AND TblUniCourses.course_level = 6');
            $conditions .= ' AND TblUniCourses.department_ref_id IN ('.implode(',', $filters['branches']).')';
        }
        
        if(isset($filters['department_ref_id']) && $filters['department_ref_id']){
            if(!is_array($filters['department_ref_id'])) $filters['department_ref_id'] = array($filters['department_ref_id']);
            $conditions .= ' AND UniversityDeptRanking.department_ref_id IN ('.implode(",", $filters['department_ref_id']).')';
        }
        
        if(isset($filters['exams']) && $filters['exams']){
            if(!is_array($filters['exams'])) $filters['exams'] = array($filters['exams']);
            $conditions .= ' AND UniCourseTest.entrance_ref_id IN ('.implode(',', $filters['exams']).')';
            $command->join(UniCourseTest::model()->tableSchema->name.' UniCourseTest', 'UniCourseTest.uni_ref_id = TblUniversityMaster.uni_id');
        }
        
        if(isset($filters['exclude_uni_ids']) && $filters['exclude_uni_ids']){
            if(!is_array($filters['exclude_uni_ids'])) $filters['exclude_uni_ids'] = array($filters['exclude_uni_ids']);
            $conditions .= ' AND TblUniversityMaster.uni_id NOT IN ('.implode(",", $filters['exclude_uni_ids']).')';
        }
        
        return true;
    }

    public static function getTopPopularCollegeList($limit = false, $offset = false){
      
        $sql ="SELECT t.uni_id, t.uni_name, t.uni_code,t.url_primary_key,t.seo_keyword,t.uni_slug_name,t.uni_logo,t.address,t.vintage,t.zipcode,
                t.country_id,t.country_name,t.name,t.city_name,t.uni_profile, SUM(total)
                FROM (
                SELECT tum.uni_id,uni_name,tum.uni_code,cm.country_id,tum.url_primary_key,tum.seo_keyword,tum.uni_slug_name,tum.uni_logo,tum.address,tum.vintage,
                tum.zipcode,cm.country_name,ts.name,tcm.city_name,tum.uni_profile, 0.9*COUNT(*) AS total
                FROM `student_shortlist_university` ssu
                LEFT JOIN tbl_university_master tum ON tum.uni_id = ssu.uni_ref_id
                LEFT JOIN tbl_user_master um ON um.user_id = ssu.user_ref_id
                LEFT JOIN tbl_city_master tcm ON tum.city_ref_id = tcm.city_id
                LEFT JOIN tbl_state ts ON tum.state_ref_id = ts.id
                LEFT JOIN tbl_country_master cm ON tum.country_ref_id = cm.country_id
                WHERE 1=1
                AND shortlist_status != 'Reject'
                AND um.is_test = 'N'
                GROUP BY uni_id
                UNION ALL
                SELECT tum.uni_id,uni_name,tum.uni_code,cm.country_id,tum.url_primary_key,tum.seo_keyword,tum.uni_slug_name,tum.uni_logo,tum.address,tum.vintage,
                tum.zipcode,cm.country_name,ts.name,tcm.city_name,tum.uni_profile, 0.1*COUNT(*) AS total
                FROM `di_user_eoi_log` dul
                LEFT JOIN di_user_eoi due ON due.di_user_eoi_id = dul.di_user_eoi_ref_id
                LEFT JOIN `di_student_selection` ds ON ds.di_student_selection_id = due.di_student_selection_ref_id
                LEFT JOIN di d ON d.di_id = ds.di_ref_id
                LEFT JOIN tbl_university_master tum ON tum.uni_id = d.uni_ref_id
                LEFT JOIN tbl_user_master um ON um.user_id = ds.user_ref_id
                LEFT JOIN tbl_city_master tcm ON tum.city_ref_id = tcm.city_id
                LEFT JOIN tbl_state ts ON tum.state_ref_id = ts.id
                LEFT JOIN tbl_country_master cm ON tum.country_ref_id = cm.country_id
                WHERE 1=1
                AND d.is_test = 'N'
                AND d.is_active = 1
                AND um.is_test = 'N'
                GROUP BY di_id
                ORDER BY total DESC
                )AS t
                WHERE total > 50
                GROUP BY uni_id
                ORDER BY total DESC
                ";
                if($limit){
                    $sql.= " LIMIT ".$limit." ";
                }
                if($offset){
                    $sql.= "OFFSET ".$offset." ";
                }
     //  echo sprintf($sql,$shortlistmultiplier,$dimultiplier);exit;
        $result = Yii::app()->db->createCommand($sql)->queryAll();
        return $result;

    }


    public static function getTopPopCollegeList($limit = false, $offset = false){

        $sql ="SELECT t.uni_id, t.uni_name, t.uni_code,t.url_primary_key,t.seo_keyword,t.uni_slug_name,t.uni_logo,
                SUM(total)
                FROM (
                SELECT tum.uni_id,uni_name,tum.uni_code,tum.url_primary_key,tum.seo_keyword,tum.uni_slug_name,tum.uni_logo,
                0.9*COUNT(*) AS total
                FROM `student_shortlist_university` ssu
                LEFT JOIN tbl_university_master tum ON tum.uni_id = ssu.uni_ref_id
                LEFT JOIN tbl_user_master um ON um.user_id = ssu.user_ref_id
                WHERE 1=1
                AND shortlist_status != 'Reject'
                AND um.is_test = 'N'
                GROUP BY uni_id
                UNION ALL
                SELECT tum.uni_id,uni_name,tum.uni_code,tum.url_primary_key,tum.seo_keyword,tum.uni_slug_name,tum.uni_logo,
                0.1*COUNT(*) AS total
                FROM `di_user_eoi_log` dul
                LEFT JOIN di_user_eoi due ON due.di_user_eoi_id = dul.di_user_eoi_ref_id
                LEFT JOIN `di_student_selection` ds ON ds.di_student_selection_id = due.di_student_selection_ref_id
                LEFT JOIN di d ON d.di_id = ds.di_ref_id
                LEFT JOIN tbl_university_master tum ON tum.uni_id = d.uni_ref_id
                LEFT JOIN tbl_user_master um ON um.user_id = ds.user_ref_id
                WHERE 1=1
                AND d.is_test = 'N'
                AND d.is_active = 1
                AND um.is_test = 'N'
                GROUP BY di_id
                ORDER BY total DESC
                )AS t
                WHERE total > 50
                GROUP BY uni_id
                ORDER BY total DESC
                ";
        if($limit){
            $sql.= " LIMIT ".$limit." ";
        }
        if($offset){
            $sql.= "OFFSET ".$offset." ";
        }
        $result = Yii::app()->db->createCommand($sql)->queryAll();
        return $result;
    }


}