<?php

/**
 * This is the model class for table "tbl_country_master".
 *
 * The followings are the available columns in table 'tbl_country_master':
 * @property integer $country_id
 * @property string $country_name
 * @property string $country_code
 * @property string $phone_code
 * @property string $citizen
 * @property string $flag_photo
 * @property string $is_active
 * @property string $is_stud_interested
 * @property integer $display_order
 *
 * The followings are the available model relations:
 * @property DiSearchCountry[] $diSearchCountries
 * @property SessionAdvisorDeptCountry[] $sessionAdvisorDeptCountries
 * @property StudentPreferredCountry[] $studentPreferredCountries
 * @property WorkshopGroupCountry[] $workshopGroupCountries
 */
class TblCountryMaster extends CActiveRecord
{
    
    public $seo_country_id;
    public $seo_country_name;
    public static $univarietyCountryIds = array(224, 100, 12, 190, 223, 36, 154, 82, 222);
    
    
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblCountryMaster the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_country_master';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('country_name', 'required'),
			array('display_order', 'numerical', 'integerOnly'=>true),
			array('country_name, citizen', 'length', 'max'=>50),
            array('phone_code', 'length', 'max'=>10),
			array('country_code', 'length', 'max'=>2),
			array('flag_photo', 'length', 'max'=>100),
			array('is_active, is_stud_interested', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('country_id, country_name, country_code, citizen, flag_photo, is_active, is_stud_interested, display_order', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diSearchCountries' => array(self::HAS_MANY, 'DiSearchCountry', 'country_ref_id'),
			'sessionAdvisorDeptCountries' => array(self::HAS_MANY, 'SessionAdvisorDeptCountry', 'country_ref_id'),
			'studentPreferredCountries' => array(self::HAS_MANY, 'StudentPreferredCountry', 'country_ref_id'),
			'workshopGroupCountries' => array(self::HAS_MANY, 'WorkshopGroupCountry', 'country_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'country_id' => 'Country',
			'country_name' => 'Country Name',
            'phone_code' => 'Phone Code',
			'country_code' => 'Country Code',
			'citizen' => 'Citizen',
			'flag_photo' => 'Flag Photo',
			'is_active' => 'Is Active',
			'is_stud_interested' => 'Is Stud Interested',
			'display_order' => 'Display Order',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('country_id',$this->country_id);
		$criteria->compare('country_name',$this->country_name,true);
        $criteria->compare('phone_code',$this->phone_code,true);
		$criteria->compare('country_code',$this->country_code,true);
		$criteria->compare('citizen',$this->citizen,true);
		$criteria->compare('flag_photo',$this->flag_photo,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('is_stud_interested',$this->is_stud_interested,true);
		$criteria->compare('display_order',$this->display_order);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	// Return array of countries.
	public function getCountryList()
	{
	  $rs = self::model()->findAll(array('condition'=>"is_active ='Y'",'order' => 'country_name ASC'));
	  
	  $countries = array();
	  foreach($rs as $row)
	  {
	  	$countries[$row->country_id] = $row->country_name;
	  }	
	  	
// 	  print_r($countries);
	  
	  return $countries;
	}
	
	/**
     * Returns the array of univariety supporting countries
     * @return TblUniversityMaster array
     */
    public static function getUnivarietyCountries(){
        /* $criteria = new CDbCriteria;
        $criteria->compare('country_id', self::$univarietyCountryIds);
        $criteria->order = 'country_name';
        return self::model()->findAll($criteria); */
        return DiHelper::getStudentInterestedCountries();
    }
	
    public static function getCountryListById($countryIds){
	    $modelCountry = self::model()->findAll(array("condition" => "t.country_id IN (".$countryIds.")"));
	    return $modelCountry;
    }
    
    public static function getCountryListByContinent($searchTerm, $continentId = 0) {
	$criteria = new CDbCriteria;
	if($continentId > 0) {
	    $criteria->compare('continent_ref_id', $continentId);
	}
	    $criteria->compare('country_name', $searchTerm, true);
	    $searchTerm = mysql_escape_string($searchTerm);
	    $criteria->order = "(CASE WHEN country_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), country_name";
	    $criteria->limit = 15;
	    return self::model()->findAll($criteria);	        
    }
    
    public static function getCountryName($countryId) {
        $criteria = new CDbCriteria;
        $criteria->compare('country_id', $countryId);
        $res = self::model()->find($criteria);
        return $res->country_name;
    }

    public static function getPhoneCode($countryId) {
        $criteria = new CDbCriteria;
        $criteria->compare('country_id', $countryId);
        $res = self::model()->find($criteria);
        return $res->phone_code;
    }

    public static function getCountryCode($countryId) {
        $criteria = new CDbCriteria;
        $criteria->compare('country_id', $countryId);
        $res = self::model()->find($criteria);
        return $res->country_code;
    }

    public static function getStudentInterestedCountryList($searchParams = array()){
		
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->condition = "t.is_active = 'Y' AND t.is_stud_interested='Y'";
        if(count($searchParams) > 0 && !empty($searchParams)){
            foreach($searchParams as $fieldName => $fieldValue){
                $cdbCriteria->compare($fieldName, $fieldValue);
            }
        }

        $cdbCriteria->order = "country_name";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }


    public static function getCountryPhoneCodes(){
        $criteria = new CDbCriteria;
        $criteria->select = 'country_id, country_name, phone_code';
        $criteria->compare('country_id', self::$univarietyCountryIds);
        $criteria->order = 'country_name';
        $data =  self::model()->findAll($criteria);
        $index = 0;
        foreach ($data as $value) {
            $return[$index]['country_id'] = $value->country_id;
            $return[$index]['country_name'] = $value->country_name;
            $return[$index]['phone_code'] = $value->phone_code;
            $index++;
        }

        return $return;
    }

    public static function getActiveCountriesList(){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->condition = "t.is_active = 'Y'";
        $cdbCriteria->order = "t.country_name ASC";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }
    
     public static function getCountryInfoByCode($countryCode) {
        $criteria = new CDbCriteria;
        $criteria->compare('phone_code', $countryCode);
        $res = self::model()->find($criteria);
        return $res;
    }
    
    // get the country list for jquery token input
    public static function get_country_list_for_token_input(){
        
        $countries = Yii::app()->db->createCommand()
                ->select('country_id, country_name')
                ->from(self::model()->tableSchema->name)
                ->where('is_active = "Y"')
                ->queryAll();
        
        $data = array();
        
        foreach($countries as $c){
            $data[] = array('id' => $c['country_id'], 'name' => $c['country_name']);
        }
        return $data;
    }


    public static function getStudentInterestedCountryListWithoutGermany($searchParams = array()){

        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->condition = "t.is_active = 'Y' AND t.is_stud_interested='Y' AND country_name NOT IN('Germany')";
        if(count($searchParams) > 0 && !empty($searchParams)){
            foreach($searchParams as $fieldName => $fieldValue){
                $cdbCriteria->compare($fieldName, $fieldValue);
            }
        }

        $cdbCriteria->order = "country_name";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getVendors() {
        Yii::import('application.modules.vendor.models.*');
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = "t.vendor_id, t.name";
        $cdbCriteria->join = " LEFT JOIN `vendor_centre` vc ON vc.vendor_ref_id = t.vendor_id ";
        //$cdbCriteria->condition = "is_registered ='Y'";
        $cdbCriteria->group = "vendor_id";
        $result = Vendor::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getActiveUserCountriesList(){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = "country_id,country_name";
        $cdbCriteria->join = "INNER JOIN tbl_user_master um ON um.country_ref_id = t.country_id";
        $cdbCriteria->join .= " INNER JOIN prospect p ON p.user_ref_id = um.user_id";
        $cdbCriteria->condition = "t.is_active = 'Y'";
        $cdbCriteria->group = "t.country_id";
        $cdbCriteria->order = "t.country_name ASC";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }
    
    public static function _get_active_country_list($slug_country_names = false){
        $country_list = array();
        foreach(Yii::app()->db->createCommand()->select('TblCountryMaster.country_name, TblCountryMaster.country_id')->from(TblCountryMaster::model()->tableSchema->name.' TblCountryMaster')->where('TblCountryMaster.is_active="Y"')->order('TblCountryMaster.country_name')->queryAll() as $country_info){
            $country_list[strtolower(Inflector::slug($country_info['country_name'], '-'))]['id']    = $country_info['country_id'];
            $country_list[strtolower(Inflector::slug($country_info['country_name'], '-'))]['title'] = $country_info['country_name'];
            $country_list[strtolower(Inflector::slug($country_info['country_name'], '-'))]['slug']  = strtolower(Inflector::slug($country_info['country_name'], '-'));
        }
        return $country_list;
    }

    public static function getCountryCodes(){
        $countryData = Yii::app()->db->createCommand()
            ->from('tbl_country_master as tcm')
            ->select('phone_code, country_name')
            ->where('is_active= "Y" AND country_code <> "" ')
            ->order('country_name ASC')
            ->queryAll();
         return $countryData;
    }
}

