<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseStudentShortlistVendor');

class StudentShortlistVendor extends BaseStudentShortlistVendor{
    public static function model($className=__CLASS__){
      return parent::model($className);
    }

    public function afterSave(){
        OfflineF2fCounsellor::localChange($this->user_ref_id);
        return parent::afterSave();
    }

    public function beforeDelete(){
        OfflineF2fCounsellor::localChange($this->user_ref_id);
        OfflineDeleteRecordLog::deleteRecordUpdateTime($this->user_ref_id,__CLASS__);
        return parent::beforeDelete();
    }
    
    public static function get_shortlisted_vendors($user_id = null){
        // if no user id passed get current user
        if(!$user_id && Yii::app()->user->id) $user_id = Yii::app()->user->sub_id;
        if(!$user_id) return array();
        
        return Yii::app()->db->createCommand()
                ->from('student_shortlist_vendor')
                ->where('user_ref_id = :user_ref_id', array(':user_ref_id' => $user_id))
                ->queryAll();
        
    }
    
  
}