<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseStudentPreferredLocation');

class StudentPreferredLocation extends BaseStudentPreferredLocation
{
  public $city_name;
  public $name;
  public $region_name;
  public $cluster_name;

  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }


    public static function studentPreferredLoc($userId, $prefCountryId)
    {
        $criteria = new CDbCriteria;
        $criteria->select = 'r.region_name, t.region_ref_id, ts.name, t.state_ref_id, cm.city_name, t.city_ref_id, pc.preferred_country_id, pc.country_ref_id, t.cluster_ref_id, lcc.cluster_name';
        $criteria->join = " LEFT JOIN student_preferred_country pc ON t.preferred_country_ref_id = pc.preferred_country_id ";
        $criteria->join.= " LEFT JOIN tbl_state ts ON ts.id = t.state_ref_id ";
        $criteria->join.= " LEFT JOIN tbl_city_master cm ON cm.city_id = t.city_ref_id ";
        $criteria->join.= " LEFT JOIN `lookup_region` r ON r.region_id = t.region_ref_id ";
        $criteria->join.= " LEFT JOIN `lookup_city_cluster` lcc ON lcc.city_cluster_id = t.cluster_ref_id ";
        $criteria->addCondition("user_ref_id= " . $userId, "AND");
        $criteria->addCondition("preferred_country_ref_id = " . $prefCountryId, "AND");
        $criteria->order = " t.preferred_location_id asc ";

        return self::model()->findAll($criteria);
    }

    public static function getAllPrefLocations($userId, $countryId) {

        $sql = "SELECT GROUP_CONCAT(CONCAT_WS('-',r.region_name,ts.name,cm.city_name,lcc.cluster_name) SEPARATOR ', ') location, pc.preferred_country_id, pc.country_ref_id
                FROM student_preferred_location t
                LEFT JOIN student_preferred_country pc ON t.preferred_country_ref_id = pc.preferred_country_id
                LEFT JOIN tbl_state ts ON ts.id = t.state_ref_id
                LEFT JOIN tbl_city_master cm ON cm.city_id = t.city_ref_id
                LEFT JOIN `lookup_region` r ON r.region_id = t.region_ref_id
                LEFT JOIN `lookup_city_cluster` lcc ON lcc.city_cluster_id = t.cluster_ref_id
                WHERE user_ref_id = '".$userId."' AND pc.country_ref_id = '".$countryId."'
                ORDER BY preferred_location_id ";

        $command =Yii::app()->db->createCommand($sql);
        return $command->queryRow();

    }
}