<?php

/**
 * This is the model class for table "student_grade_count".
 *
 * The followings are the available columns in table 'student_grade_count':
 * @property integer $student_grade_count_id
 * @property string $student_education_ref_id
 * @property integer $grade_ref_id
 * @property integer $grade_count
 * @property string $added_on
 * @property integer $board_conversion_ref_id
 *
 * The followings are the available model relations:
 * @property StudentEducation $studentEducationRef
 * @property LookupGrade $gradeRef
 */
class StudentGradeCount extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentGradeCount the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_grade_count';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_education_ref_id, grade_ref_id, grade_count', 'required'),
			array('grade_ref_id, grade_count, board_conversion_ref_id', 'numerical', 'integerOnly'=>true),
			array('student_education_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_grade_count_id, student_education_ref_id, grade_ref_id, grade_count, added_on, board_conversion_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'studentEducationRef' => array(self::BELONGS_TO, 'StudentEducation', 'student_education_ref_id'),
			'gradeRef' => array(self::BELONGS_TO, 'LookupGrade', 'grade_ref_id'),
			'boardConversionRef' => array(self::BELONGS_TO, 'LookupBoardConversion', 'board_conversion_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_grade_count_id' => 'Student Grade Count',
			'student_education_ref_id' => 'Student Education Ref',
			'grade_ref_id' => 'Grade Ref',
			'grade_count' => 'Grade Count',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_grade_count_id',$this->student_grade_count_id);
		$criteria->compare('student_education_ref_id',$this->student_education_ref_id,true);
		$criteria->compare('grade_ref_id',$this->grade_ref_id);
		$criteria->compare('grade_count',$this->grade_count);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

    public static function getStudentEducationDetails($userId = 0, $class = ''){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("user_ref_id = '".$userId."'", 'AND');
        if($class != ''){
            $cdbCriteria->addCondition("class_level = '".$class."'", 'AND');
        }
        $result = self::model()->find($cdbCriteria);
        //echo "<pre>";print_r($result->attributes);
        return $result;
    }

    public static function getStudentGradeDetails($studentEducationId){
        /*$sql ="SELECT gc.grade_count FROM student_grade_count gc
                LEFT JOIN lookup_grade lg ON (gc.grade_ref_id = lg.grade_id)
                WHERE gc.student_education_ref_id = '$studentEducationId' AND lg.grade_type='$gradeType'";*/
        $sql = "SELECT gc.grade_count, lg.grade_type FROM lookup_grade lg
                LEFT JOIN student_grade_count gc ON (gc.grade_ref_id = lg.grade_id AND gc.student_education_ref_id = '".$studentEducationId."')";
        $command =Yii::app()->db->createCommand($sql);
        $res =$command->queryAll();
        return $res;
    }

    /*protected function beforeSave(){
        if(parent::beforeSave()){
            if($this->isNewRecord){
                $this->added_on = date('Y-m-d H:i:s');
            }
            return true;

        }
        return false;
    }*/
    
    public static function setStudentGradeInfo($studentEducationRefId,$gradeRefId, $gradeCount){
        $studentGradeModel = new StudentGradeCount();
        $studentGradeModel->grade_ref_id = $gradeRefId;
        $studentGradeModel->grade_count = $gradeCount;
        $studentGradeModel->student_education_ref_id = $studentEducationRefId;
        $studentGradeModel->save(false);
        return $studentGradeModel;
    }

    public static function setStudentGradeInfoNew($studentEducationRefId,$gradeRefId, $gradeCount){
        $studentGradeModel = new StudentGradeCount();
        $studentGradeModel->board_conversion_ref_id = $gradeRefId;
        $studentGradeModel->grade_count = $gradeCount;
        $studentGradeModel->student_education_ref_id = $studentEducationRefId;
        $studentGradeModel->save(false);
        return $studentGradeModel;
    }

    public static function phraseStudentOverallGrades($class,$userId){
        $gradesString = '';
        $gradeType = '';
        $gradeDetail = StudentEducation::getGradeDetail($class, $userId);
        foreach ($gradeDetail as $k => $val) {
            foreach ($val->studentGradeCounts as $key => $value) {
                $gradeType = $value->gradeRef->grade_type;
                $gradeType = str_replace('aa', 'A*', $gradeType);
                $gradeType = strtoupper($gradeType);
                $gradesString .= str_repeat($gradeType.' ', $value->grade_count);
            }
        }
        return $gradesString;
    }

    public static function getStudentAllGradeDetails($studentEducationId=0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->condition = "student_education_ref_id = '".$studentEducationId."'";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function setStudentGrades($studentEducationRefId,$conRefId, $gradeCount){
        $studentGradeModel = new StudentGradeCount();
        $studentGradeModel->board_conversion_ref_id = $conRefId;
        $studentGradeModel->grade_count = $gradeCount;
        $studentGradeModel->student_education_ref_id = $studentEducationRefId;
        $studentGradeModel->save(false);
        return $studentGradeModel;
    }
}