<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseStudentCitizenship');

class StudentCitizenship extends BaseStudentCitizenship {

    public function behaviors(){
        return array(
            'StudentActivityFeedBehavior' => 'application.behaviors.StudentActivityFeedBehavior',
        );
    }        

    public function StudentActivityFeedLoggableAttributes(){
        return array(
            'citizenship_ref_id' => 'citizenship',
        );
    }
    
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getStudentCitizenship($userId) {
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '" . $userId . "'";
        $criteria->limit = 2;
        $studentCitizenship = self::model()->findAll($criteria);
        return $studentCitizenship;
    }

    public function deleteStudentCitizenshipUserId($userId) {
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '" . $userId . "'";
        self::model()->deleteAll($criteria);
    }

    public function insertCitizenshipByUserId($userId, $citizenship) {
        $obj = new StudentCitizenship();
        $obj->{user_ref_id} = $userId;
        $obj->{citizenship_ref_id} = $citizenship;
        $obj->save();
    }
    
    public static function getStudentCitizenshipAsString($userId=0){
        $result = self::getStudentCitizenship($userId);
        $citizenship = array();
        foreach($result as $data){
            $citizenship[] = $data->citizenshipRef->citizen;
        }
        return implode(', ', $citizenship);
    }

}