<?php

/*
 * @author Asif Ali M
 * @package application.models
 *
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseTblUserMaster');

class Student extends BaseTblUserMaster
{
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
        
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        return array(
	        'prospects' => array(self::HAS_MANY, 'Prospect', 'user_ref_id'),
            'studentSchool' => array(self::HAS_ONE, 'StudentSchool', array('user_ref_id' => 'user_id')),
            'board' => array(self::BELONGS_TO, 'Board', 'present_board_ref_id'),
            'membership' => array(self::BELONGS_TO, 'Membership', 'membership_ref_id'),
            'preferredCountries' => array(self::MANY_MANY, 'CountryMaster', 'student_preferred_country(user_ref_id, country_ref_id)', 'order' => 'preference_order'),
            'preferredDepartments' => array(self::MANY_MANY, 'LookupDepartment', 'student_preferred_department(user_ref_id, sub_dept_ref_id)'),
        );
        
    }
	
	public function getStudentList($name = false)	
    {
        
	    $sql = "SELECT user_id FROM login_master LM LEFT JOIN tbl_user_master TUM ON TUM.login_ref_id = LM.login_id WHERE
	                   LM.username like '%".addslashes($name)."%' OR TUM.first_name like '%".addslashes($name)."%' OR TUM.last_name like '%".addslashes($name)."%'";
		
        $users = Yii::app()->db->createCommand($sql)->query();

        if($users)
	    {
		   $comma = $userIds = "";
		   foreach($users as $userList)
		   {			  
			  $userIds .= $comma.$userList['user_id'];
			  $comma = ',';			
		   }
		  return $userIds; 
	    }
	    else
	    {
		   return false;
	    }
        
    }
    
    public static function get_student_home_and_school_address($login_ref_id = null){
        if(!$login_ref_id && !Yii::app()->user->id) return false;
        if(!$login_ref_id) $login_ref_id = Yii::app()->user->id;
        
        $home_address = self::get_student_home_address($login_ref_id);
        if($home_address['school_ref_id']){
            $scholl_address = self::get_student_school_address($home_address['school_ref_id']);
        }else{
            $scholl_address = array();
        }
        
        return array('home' => $home_address, 'school' => $scholl_address);
                
    }
    
    public static function get_student_home_address($login_ref_id){
        return Yii::app()->db->createCommand()
                ->select('u.address1, u.address2, u.post_code, c.city_name, cu.country_name, s.name as state_name, c.city_id, u.school_ref_id')
                ->from('tbl_user_master u')
                ->leftJoin('tbl_city_master c', 'u.city_ref_id = c.city_id')
                ->leftJoin('tbl_country_master cu', 'u.country_ref_id = cu.country_id')
                ->leftJoin('tbl_state s', 'u.state_ref_id = s.id')
                ->where('u.login_ref_id = :login_ref_id',array(':login_ref_id' => $login_ref_id))
                ->queryRow();
    }

    public static function get_student_school_address($school_ref_id){
        return Yii::app()->db->createCommand()
                ->from('tbl_si_di')
                ->where('school_ref_id = :school_id', array(':school_id' => $school_ref_id))
                ->queryRow();
    }

    //student_preferred_country
    //student_preferred_department -> sub_dept_ref_id
}