<?php
/**
 * @author Shiva <shiva.dharana@univariety.com>
 * @package application.models
 *
 */

Yii::import('application.models.base.BaseSiMilestoneDate');

class SiMilestoneDate extends BaseSiMilestoneDate{
    public static function model($className=__CLASS__){
        return parent::model($className);
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('si_ref_id, milestone_id, milestone_date', 'required'),
            array('si_ref_id, milestone_id, board_ref_id, passout_year', 'numerical', 'integerOnly'=>true),
            array('class', 'length', 'max'=>2),
            array('added_by, modified_by', 'length', 'max'=>10),
            array('modified_on', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('si_milestone_date_id, si_ref_id, milestone_id, class, board_ref_id, milestone_date, passout_year, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
        );
    }
    
    protected function beforeSave(){
        if(parent::beforeSave()){
            if($this->isNewRecord){
                $this->added_by = Yii::app()->user->id;
                $this->added_on = date('Y-m-d H:i:s');
            }
            $this->modified_by = Yii::app()->user->id;
            $this->modified_on = date('Y-m-d H:i:s');
            return true;
        }
        return false;
    }

    /**
     * Returns student milestone dates
     * @param integer $studentId
     * @return SiMilestoneDate array
     */
    public static function getStudentDates($studentId){

    }

    /**
     * Returns available passout years based on academic year.
     * @return array
     */
    public static function getCurrentPassoutYears(){
        $year = date('Y');
        $month = date('m');
        if($month < 7){
            return array($year, $year - 1);
        }
        return array($year + 1, $year);
    }

    public static function getSiMilestoneDates($siId, $passoutYear){
        $siMilestoneDates = array();
        for($i = 1; $i <= 6; $i++){
            $criteria = new CDbCriteria;
            $criteria->compare('si_ref_id', $siId);
            $criteria->compare('passout_year', $passoutYear);
            $criteria->compare('milestone_id', $i);
            $siMilestoneDate = self::model()->find($criteria);
            if(empty($siMilestoneDate)){
                $siMilestoneDate = new self();
                $siMilestoneDate->si_ref_id = $siId;
                $siMilestoneDate->milestone_id = $i;
                $siMilestoneDate->passout_year = $passoutYear;
                $siMilestoneDate->milestone_date = $passoutYear;
            }
            $siMilestoneDates[] = $siMilestoneDate;
        }
        return $siMilestoneDates;
    }

    public static function getSiMilestoneDatesByClass($siId, $class, $class_status){
        $siMilestoneDates = array();
        for($i = 1; $i <= 6; $i++){
            $criteria = new CDbCriteria;
            $criteria->compare('si_ref_id', $siId);
            $criteria->compare('class', $class);
            $criteria->compare('milestone_id', $i);
            $siMilestoneDate = self::model()->find($criteria);
            if(empty($siMilestoneDate) || ($class_status == 'Completed')){
                $siMilestoneDate = new self();
                $siMilestoneDate->si_ref_id = $siId;
                $siMilestoneDate->milestone_id = $i;
                $siMilestoneDate->milestone_date = '';
            }
            $siMilestoneDates[] = $siMilestoneDate;
        }
        return $siMilestoneDates;
    }
    
}