<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseScholarshipDestinationCountry');

class ScholarshipDestinationCountry extends BaseScholarshipDestinationCountry
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  protected function beforeSave(){
      if(parent::beforeSave()){
        if($this->isNewRecord){
           $this->added_on = date('Y-m-d H:i:s');
        }else{
          $this->modified_on = date('Y-m-d H:i:s');
        }       
        return true;
        
      }
    return false;
  }
    
 /*
   * Get destination institutes 
   */
  public function getSourceInstitute()
  {
  	//$source = self::model()->findAll();
	
	  $criteria=new CDbCriteria;
				
	  $criteria->select = 't.country_ref_id';
				
      $criteria->join = 'JOIN tbl_country_master cm ON t.country_ref_Id = cm.country_id';
				
      $criteria->order = 'cm.country_name';
				 
	  $source = self::model()->findAll($criteria);
  	
		if($source)
		{
		  return $source;
		}
		else
		{
		  return false;	
		}		
  	
  }
  public function getSourceInstituteByCountry($countryIds = false)
  {
  	$criteria=new CDbCriteria;		
	$countryIdVal = $countryIds[0];
	
	if($countryIdVal == ',')
	{
		 $countryIdVals =substr($countryIds,1);		
	}
	else
	{
		$countryIdVals = $countryIds;
	}
	if(!empty($countryIdVals))
	{
		$criteria->condition = 'country_ref_id IN ('.$countryIdVals.')';
					
		$res = self::model()->findAll($criteria);	
		
		if($res)
		{
		  return $res;
		}
	}
  	else
  	{
  	  return false;	
  	}		
  }
  
   public static function getScholarshipSourceCountryList() {

        $criteria=new CDbCriteria;
        $criteria->select = array('scholarship_destination_country_id');
        $criteria->with = array( 'countryRef' => array('select' => 'country_id, country_name') );
        $criteria->group = 'country_ref_id';
        $criteria->order = 'countryRef.country_name ASC';
        
        $data = self::model()->findAll($criteria);
        $countryList = array();
        foreach ($data as $val) {
           $countryList[$val->countryRef->country_id]  = $val->countryRef->country_name;
        }
        
        return $countryList;
    }
}