<?php

/*
 * @author Asif Ali M
 * @package application.models
 *
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseProspect');

class Prospect extends BaseProspect
{
    /**
     * Status types available for this model
     * @var constant
     */
    //'InProgress','Converted','Lost','Abandon','NotIntrested','Confirmed To Pay','NotAssigned'
    const STATUS_IN_PROGRESS = 'InProgress';
    const STATUS_CONVERTED = 'ConvertedIndia';
    const STATUS_LOST = 'Lost';
    const STATUS_ABANDON = 'Abandon';
    const STATUS_NOT_INTRESTED = 'NotIntrested';
    const STATUS_CONVERTED_ABROAD = 'ConvertedAbroad';
	const STATUS_CONFIRMED_TO_PAY = 'ConfirmedToPay';
    const STATUS_NOT_ASSIGNED = 'NotAssigned';

    /**
     * Custom model attribute to use in search
     * @var string
     */
    public $searchSchool = '';
    public $timeline = '';


    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
			'prospect_id' => 'Prospect',
			'advisor_ref_id' => 'Advisor',
			'user_ref_id' => 'Student',
			'prospect_category_ref_id' => 'Pick',
			'prospect_status' => 'Status',
			'status_reason' => 'Conclusion',
			'assigned_date' => 'Assigned Date',
			'reassigned_from' => 'Reassigned From',
			'reassigned_date' => 'Reassigned Date',
			'decision_date' => 'Decision Date',
			'added_on' => 'Added On',
            'searchSchool' => 'School',
            'ext_advisor_ref_id' => 'External Advisor',
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(

            'advisor' => array(self::BELONGS_TO, 'Admin', 'advisor_ref_id'),
			'student' => array(self::BELONGS_TO, 'Student', 'user_ref_id'),
            'studentSchool' => array(self::BELONGS_TO, 'StudentSchool', array('user_ref_id' => 'user_ref_id')),    //bad way of defining relation, because of existing table structure.
            'prospectCategory' => array(self::BELONGS_TO, 'LookupProspectCategory', 'prospect_category_ref_id'),
            'reassignedFrom' => array(self::BELONGS_TO, 'Admin', 'reassigned_from'),
			'prospectInteractions' => array(self::HAS_MANY, 'ProspectInteraction', 'prospect_ref_id', 'order' => 'prospect_interaction_id DESC'),
        	'prospectInteractionCount' => array(self::STAT, 'ProspectInteraction', 'prospect_ref_id'),
            'prospectMainStatusRef' => array(self::BELONGS_TO, 'LookupProspectStatus', 'prospect_main_status_ref_id'),
            'prospectSubStatusRef' => array(self::BELONGS_TO, 'LookupProspectStatus', 'prospect_sub_status_ref_id'),
        );

    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
        array('advisor_ref_id, user_ref_id, prospect_status', 'required'),
        array('advisor_ref_id, prospect_category_ref_id, reassigned_from', 'numerical', 'integerOnly'=>true),
        //array('user_ref_id', 'length', 'max'=>10),
        array('prospect_status', 'length', 'max'=>25),
        array('status_reason', 'length', 'max'=>255),
        array('assigned_date, reassigned_date, decision_date, added_on, modified_on', 'safe'),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array('advisor_ref_id, user_ref_id, prospect_category_ref_id, prospect_status,ext_advisor_ref_id, status_reason, assigned_date, searchSchool', 'safe', 'on' => 'search, getList'),
        );
    }

    /**
     * This is invoked before the record is saved.
     * @return boolean whether the record should be saved.
     */
    protected function beforeSave()
    {
        if(parent::beforeSave()){
            if($this->isNewRecord){
                //$this->added_on = $this->assigned_date = new CDbExpression('NOW()');
                $this->added_on = new CDbExpression('NOW()');
            }else{
                $this->decision_date = new CDbExpression('NOW()');
            }
            return true;
        }
        return false;
    }

    /**
     * Sets the prospect status as not interested by advisor.
     * @return bool
     */
    public function setNotInterested(){
        //@todo check, below condition might not be required.
        //if advisor or user are not set, return false.
        if(empty($this->advisor_ref_id) || empty($this->user_ref_id)){
            return false;
        }

        //Check if record already exists.
        $criteria=new CDbCriteria;
        $criteria->compare('advisor_ref_id', $this->advisor_ref_id);
        $criteria->compare('user_ref_id', $this->user_ref_id);
        $criteria->compare('prospect_status', self::STATUS_NOT_INTRESTED);
        $recordsCount = self::model()->count($criteria);

        if($recordsCount > 0){
            return false;
        }

        //set the status as not interested.
        $this->prospect_status = self::STATUS_NOT_INTRESTED;
        return $this->save();
    }

    /**
     * Adds a new ProspectInteraction to this Prospect.
     * @param ProspectInteraction $interaction
     * @return bool
     */
    public function addInteraction(ProspectInteraction $interaction){
        $interaction->prospect_ref_id = $this->prospect_id;
        return $interaction->save();
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function getList($advisorId = 0)
    {

        $criteria = new CDbCriteria();
        $criteria->with = array(
			'prospectInteractionCount', 
			'prospectCategory',// => array('condition' => 'prospect_category_ref_id IS NOT NULL'), 
			'advisor', 
			'student',
            'studentSchool'
            );

            // Show default selection of in progress records.
            if(isset($_GET['Prospect']['prospect_status'])){
                $criteria->compare('prospect_status', $this->prospect_status, false);
            }else{
                $criteria->compare('prospect_status', Prospect::STATUS_IN_PROGRESS, false);
                $this->prospect_status = Prospect::STATUS_IN_PROGRESS;
            }
            
            if($advisorId > 0){
                $criteria->addSearchCondition('advisor_ref_id', $advisorId, false);
            }

            $criteria->compare('studentSchool.inst_ref_id', $this->searchSchool, false);
            $criteria->compare('prospect_id',$this->prospect_id, false);
            $criteria->compare('advisor_ref_id', $this->advisor_ref_id, false);
            $criteria->compare('prospect_status', $this->prospect_status, false);
            $criteria->compare('status_reason', $this->status_reason, true);
            $criteria->compare('reassigned_from',$this->reassigned_from, false);
            $criteria->compare('reassigned_date',$this->reassigned_date, true);
            $criteria->compare('decision_date',$this->decision_date, true);

            /**
             * Following compare searches from relations table of the model.
             * It is mandatory to specify 'student' in the 'with' in CDbCriteria.
             */
            if($this->user_ref_id)
                $criteria->addCondition("CONCAT(student.first_name, ' ', student.last_name) LIKE '%" . $this->user_ref_id . "%'");

            if($this->prospect_category_ref_id){
                $orCriteria = new CDbCriteria();
                $orCriteria->compare('prospect_category_ref_id', $this->prospect_category_ref_id);
                $orCriteria->compare('prospectCategory.parent_id', $this->prospect_category_ref_id, false, 'OR');
                $criteria->mergeWith($orCriteria);
                unset($orCriteria);
            }

            if($this->assigned_date){
                $delta = (int) trim($this->assigned_date, '-');
                $op = '>';
                if(strstr($this->assigned_date, '-')){
                    $op = '<';
                }
                list($y, $m, $d) = explode('-', date('Y-m-d'));
                $date = date('Y-m-d', mktime(0, 0, 0, $m, $d - $delta, $y));
                $criteria->addCondition('assigned_date' . $op . "'" . $date . "'");
            }

            return new CActiveDataProvider($this, array(
    			'criteria' => $criteria,
            	'pagination' => array(
    				'pageSize' => Yii::app()->params['postsPerPage'],
                ),
                'sort' => array(
                    'defaultOrder' => 'prospect_id DESC',
                    'attributes'=>array(
                        'advisor_ref_id' => array(
                            'asc' => 'advisor.admin_name',
                            'desc' => 'advisor.admin_name DESC',
                        ),
                        'user_ref_id' => array(
                            'asc' => 'student.first_name',
                            'desc' => 'student.first_name DESC',
                        ),
                        'prospect_category_ref_id' => array(
                            'asc' => 'prospectCategory.value',
                            'desc' => 'prospectCategory.value DESC',
                        ),
                        '*',
                    ),
                ),
            ));
    }

    /**
     * Returns the list of prospect status' as associative array.
     * @return array
     */
    public static function getStatuses(){
        return array(
        self::STATUS_ABANDON => 'Abandoned',
		self::STATUS_CONFIRMED_TO_PAY => 'Confirmed To Pay',
        self::STATUS_CONVERTED_ABROAD => 'Converted Abroad',
        self::STATUS_CONVERTED => 'Converted India',
        self::STATUS_IN_PROGRESS => 'In Progress',
        self::STATUS_LOST => 'Lost',
        self::STATUS_NOT_INTRESTED => 'Not Interested',
        );
    }

    /**
     * Checks whether the student has been abandoned or not
     * If student is abandoned, returns the prospect else null
     * @param int $userId
     * @return null|Prospect
     */
    public function hasAbandoned($userId){
        $criteria = new CDbCriteria;
        $criteria->compare('user_ref_id', $userId, true);
        $criteria->compare('prospect_status', self::STATUS_ABANDON, true);
        return $this->find($criteria);
    }

    /**
     * Reassigns the prospect to new advisor
     * @param int $adminId
     * @return bool
     */
    public function reassignTo($adminId){
        $this->reassigned_from = $this->advisor_ref_id;
        $this->assigned_date = new CDbExpression('NOW()');
        $this->status_reason = null;
        $this->prospect_status = self::STATUS_IN_PROGRESS;
        $this->advisor_ref_id = $adminId;
        return $this->update();
    }

    public static function getTimelineFilters(){
        return array(
            '1' => '< 1 days',
            '7' => '< 7 days',
            '30' => '< 30 days',
            '90' => '< 90 days',
            '90-' => '> 90 days'
            );
    }




    public static function getSummaryReport($from_date=false,$to_date=false){

        //Decide dates based on input filters.
        $toDate = date('Y-m-d 23:23:59');
        $fromDate = '1970-01-01 00:00:00';
        /*if(!empty($timeline)){
            $delta = (int) trim($timeline, '-');

            list($y, $m, $d) = explode('-', date('Y-m-d'));
            $date = date('Y-m-d', mktime(0, 0, 0, $m, $d - $delta, $y));

            if(strstr($timeline, '-')){
                $toDate = $date . ' 23:23:59';
            }else{
                $fromDate = $date . ' 00:00:00';
            }
        }*/
        if(!empty($from_date)){
            list($m, $d, $y) = explode('/', $from_date);

            $fromDate = $y.'-'.$m.'-'.$d.' 00:00:00';
        }
        if(!empty($to_date)){
            list($m, $d, $y) = explode('/', $to_date);

            $toDate = $y.'-'.$m.'-'.$d.' 00:00:00';
        }

        $status = array(
            self::STATUS_IN_PROGRESS => self::STATUS_IN_PROGRESS,
            self::STATUS_NOT_INTRESTED => self::STATUS_NOT_INTRESTED,
            self::STATUS_CONVERTED => self::STATUS_CONVERTED,
            self::STATUS_ABANDON => self::STATUS_ABANDON,
            self::STATUS_LOST => self::STATUS_LOST,
            self::STATUS_CONVERTED_ABROAD => self::STATUS_CONVERTED_ABROAD,
			self::STATUS_CONFIRMED_TO_PAY => self::STATUS_CONFIRMED_TO_PAY
        );

        $subQueries = array();
        $subQueries['active'] = "select count(*) from prospect as p1 where p1.advisor_ref_id = p.advisor_ref_id and p1.prospect_status = '{$status[self::STATUS_IN_PROGRESS]}'";
        $subQueries['not_interested'] = "select count(DISTINCT p1.prospect_id) from prospect as p1 where p1.advisor_ref_id = p.advisor_ref_id and p1.prospect_status = '{$status[self::STATUS_NOT_INTRESTED]}' AND p1.assigned_date BETWEEN :fromDate AND :toDate";
        $subQueries['converted_india'] = "select count(DISTINCT p1.prospect_id) from prospect as p1 where p1.advisor_ref_id = p.advisor_ref_id and p1.prospect_status = '{$status[self::STATUS_CONVERTED]}' AND p1.decision_date BETWEEN :fromDate AND :toDate";
        $subQueries['converted_abroad'] = "select count(DISTINCT p1.prospect_id) from prospect as p1 where p1.advisor_ref_id = p.advisor_ref_id and p1.prospect_status = '{$status[self::STATUS_CONVERTED_ABROAD]}' AND p1.decision_date BETWEEN :fromDate AND :toDate";
        $subQueries['abandoned'] = "select count(*) from prospect as p1 where p1.advisor_ref_id = p.advisor_ref_id and p1.prospect_status = '{$status[self::STATUS_ABANDON]}' AND p1.decision_date BETWEEN :fromDate AND :toDate";
        $subQueries['lost'] = "select count(*) from prospect as p1 where p1.advisor_ref_id = p.advisor_ref_id and p1.prospect_status = '{$status[self::STATUS_LOST]}' AND p1.decision_date BETWEEN :fromDate AND :toDate";
        $subQueries['avg_interactions_per_student'] = "select count(*)/count(distinct p1.user_ref_id) from prospect as p1 join prospect_interaction as pi on pi.prospect_ref_id = p1.prospect_id where p1.advisor_ref_id = p.advisor_ref_id AND pi.interaction_date BETWEEN :fromDate AND :toDate";
        $subQueries['avg_interactions_per_conversion'] = "select count(*)/count(distinct p1.prospect_id) from prospect as p1 left join prospect_interaction as pi on pi.prospect_ref_id = p1.prospect_id where p1.advisor_ref_id = p.advisor_ref_id and p1.prospect_status IN( '{$status[self::STATUS_CONVERTED]}', '{$status[self::STATUS_CONVERTED_ABROAD]}') AND pi.interaction_date BETWEEN :fromDate AND :toDate";
        $subQueries['avg_interactions_per_lost'] = "select count(*)/count(distinct p1.prospect_id) from prospect as p1 left join prospect_interaction as pi on pi.prospect_ref_id = p1.prospect_id where p1.advisor_ref_id = p.advisor_ref_id and p1.prospect_status = '{$status[self::STATUS_LOST]}' AND pi.interaction_date BETWEEN :fromDate AND :toDate";
        $subQueries['avg_days_per_lost'] = "select avg(datediff(p1.decision_date, p1.assigned_date)) from prospect as p1 where p1.advisor_ref_id = p.advisor_ref_id and p1.prospect_status = '{$status[self::STATUS_LOST]}' AND p1.assigned_date BETWEEN :fromDate AND :toDate";
        $subQueries['avg_days_per_converted'] = "select avg(datediff(p1.decision_date, p1.assigned_date)) from prospect as p1 where p1.advisor_ref_id = p.advisor_ref_id and p1.prospect_status IN ('{$status[self::STATUS_CONVERTED]}', '{$status[self::STATUS_CONVERTED_ABROAD]}') AND p1.assigned_date BETWEEN :fromDate AND :toDate";
        $subQueries['avg_days_per_abandon'] = "select avg(datediff(p1.decision_date, p1.assigned_date)) from prospect as p1 where p1.advisor_ref_id = p.advisor_ref_id and p1.prospect_status = '{$status[self::STATUS_ABANDON]}' AND p1.assigned_date BETWEEN :fromDate AND :toDate";
        $subQueries['avg_days_per_prospect'] = "select avg(datediff((CASE p1.prospect_status WHEN p1.prospect_status = '{$status[self::STATUS_IN_PROGRESS]}' THEN CURDATE() ELSE p1.decision_date END), p1.assigned_date)) from prospect as p1 where p1.advisor_ref_id = p.advisor_ref_id and p1.prospect_status != '{$status[self::STATUS_NOT_INTRESTED]}' AND p1.assigned_date BETWEEN :fromDate AND :toDate";

        $subQuery = '';
        foreach($subQueries as $alias => $query){
            $subQuery .= ', (' . $query . ') as ' . $alias;
        }

        $query = Yii::app()->db->createCommand()
        ->select('advisor_ref_id, count(prospect_id) as total ' . $subQuery)
        ->from(self::tableName() . ' p')
        //->where("1", array(':fromDate' => $fromDate, ':toDate' => $toDate))
        ->where("p.added_on BETWEEN :fromDate AND :toDate", array(':fromDate' => $fromDate, ':toDate' => $toDate))
        ->group('p.advisor_ref_id');

        $rawData = $query->queryAll();
        $dataProvider = new CArrayDataProvider($rawData, array(
                'keyField' => 'advisor_ref_id',
        ));
        return $dataProvider;
    }
    
	/**
     * Checks whether the prospect is existing or not
     * @param integar $userId
     * @return boolean
     */
    public static function isExisting($userId){
        $criteria = new CDbCriteria;
        $criteria->compare('user_ref_id', $userId);
        $criteria->compare('prospect_status', array(
            self::STATUS_CONVERTED,
            self::STATUS_CONVERTED_ABROAD,
            self::STATUS_IN_PROGRESS,
            self::STATUS_LOST,
			self::STATUS_CONFIRMED_TO_PAY
        ));
        return (self::model()->count($criteria) > 0);
    }
	
	public static function getProspectDetails($userId=0)
	{
		$modelProspectDetail = self::model()->find(array("condition"=>"user_ref_id = ".$userId." AND prospect_status IN ('InProgress','ConfirmedToPay')"));
		if(!empty($modelProspectDetail))
		{
		  return $modelProspectDetail;
		}
		else
		{
		  return false;
		}
	}

    public static function getProspectCounts($tableName ='Prospect',$from_date=false,$to_date=false)
    {
        $toDate = date('Y-m-d 23:23:59');
        $fromDate = '1970-01-01 00:00:00';
        if(!empty($from_date)){
            list($m, $d, $y) = explode('/', $from_date);

            $fromDate = $y.'-'.$m.'-'.$d.' 00:00:00';
        }
        if(!empty($to_date)){
            list($m, $d, $y) = explode('/', $to_date);

            $toDate = $y.'-'.$m.'-'.$d.' 00:00:00';
        }
        if($tableName == 'Prospect'){
            return self::model()->count("added_on BETWEEN :fromDate AND :toDate", array(':fromDate' => $fromDate, ':toDate' => $toDate));
        }
        if($tableName == 'GemLeadProspect'){
            return GemLeadProspect::model()->count("added_on BETWEEN :fromDate AND :toDate", array(':fromDate' => $fromDate, ':toDate' => $toDate));
        }
    }

   public static function getLeadsReport($from_date=false,$to_date=false){
        //Decide dates based on input filters.
        $toDate = date('Y-m-d 23:23:59');
        $fromDate = '1970-01-01 00:00:00';

        if(!empty($from_date)){
            list($m, $d, $y) = explode('/', $from_date);

            $fromDate = $y.'-'.$m.'-'.$d.' 00:00:00';
        }
        if(!empty($to_date)){
            list($m, $d, $y) = explode('/', $to_date);

            $toDate = $y.'-'.$m.'-'.$d.' 00:00:00';
        }

        //$dateCondition = " AND p1.decision_date BETWEEN '$fromDate' AND '$toDate'";
        //$gemDateCondition = " AND glp1.decision_date BETWEEN '$fromDate' AND '$toDate'";
        $dateCondition = " AND p1.added_on BETWEEN '$fromDate' AND '$toDate'";
        $gemDateCondition = " AND glp1.added_on BETWEEN '$fromDate' AND '$toDate'";

        $sql = "SELECT admin_id,admin_name,SUM(cnt) AS total,SUM(ConvertedIndia) AS ConvertedIndia,SUM(ConvertedAbroad) AS ConvertedAbroad,SUM(Abandon) AS Abandon,SUM(NotAssigned) AS NotAssigned,SUM(InProgress) AS InProgress,SUM(ConfirmedToPay) AS ConfirmedToPay,SUM(Lost) AS Lost,SUM(NotIntrested) AS NotIntrested
FROM (
SELECT admin_id,ta.admin_name,advisor_ref_id,COUNT(*) AS cnt,
(
	 SELECT COUNT(*) AS NotIntrested
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.advisor_ref_id
	 WHERE p1.prospect_status = 'NotIntrested'
	 AND p1.advisor_ref_id = p.advisor_ref_id
	 $dateCondition
) AS 'NotIntrested',
(
	 SELECT COUNT(*) AS Lost
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.advisor_ref_id
	 WHERE p1.prospect_status = 'Lost'
	 AND p1.advisor_ref_id = p.advisor_ref_id
	 $dateCondition
) AS 'Lost',
(
	 SELECT COUNT(*) AS ConfirmedToPay
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.advisor_ref_id
	 WHERE p1.prospect_status = 'ConfirmedToPay'
	 AND p1.advisor_ref_id = p.advisor_ref_id
	 $dateCondition
) AS 'ConfirmedToPay',
(
	 SELECT COUNT(*) AS InProgress
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.advisor_ref_id
	 WHERE p1.prospect_status = 'InProgress'
	 AND p1.advisor_ref_id = p.advisor_ref_id
	 $dateCondition
) AS 'InProgress',
(
	 SELECT COUNT(*) AS NotAssigned
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.advisor_ref_id
	 WHERE p1.prospect_status = 'NotAssigned'
	 AND p1.advisor_ref_id = p.advisor_ref_id
	 $dateCondition
) AS 'NotAssigned',
(
	 SELECT COUNT(*) AS Abandon
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.advisor_ref_id
	 WHERE p1.prospect_status = 'Abandon'
	 AND p1.advisor_ref_id = p.advisor_ref_id
	 $dateCondition
) AS 'Abandon',
(
	 SELECT COUNT(*) AS ConvertedAbroad
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.advisor_ref_id
	 WHERE p1.prospect_status = 'ConvertedAbroad'
	 AND p1.advisor_ref_id = p.advisor_ref_id
	 $dateCondition
) AS 'ConvertedAbroad',
(
	 SELECT COUNT(*) AS cnt
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.advisor_ref_id
	 WHERE p1.prospect_status = 'ConvertedIndia'
	 AND p1.advisor_ref_id = p.advisor_ref_id
	 $dateCondition
) AS 'ConvertedIndia'

FROM prospect p
LEFT JOIN tbl_admin ta ON ta.admin_id = p.advisor_ref_id
AND p.added_on BETWEEN '$fromDate' AND '$toDate'
GROUP BY p.advisor_ref_id
UNION ALL
SELECT admin_id,ta.admin_name,advisor_ref_id,COUNT(*) AS cnt,
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.advisor_ref_id
	 WHERE gl.gem_status = 'NotIntrested'
	 AND ta1.admin_id = ta.admin_id
	 $gemDateCondition
) AS 'NotIntrested',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.advisor_ref_id
	 WHERE gl.gem_status = 'Lost'
	 AND ta1.admin_id = ta.admin_id
	 $gemDateCondition

) AS 'Lost',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.advisor_ref_id
	 WHERE gl.gem_status = 'ConfirmedToPay'
	 AND ta1.admin_id = ta.admin_id
	 $gemDateCondition
) AS 'ConfirmedToPay',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.advisor_ref_id
	 WHERE gl.gem_status = 'InProgress'
	 AND ta1.admin_id = ta.admin_id
	 $gemDateCondition
) AS 'InProgress',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.advisor_ref_id
	 WHERE gl.gem_status = 'NotAssigned'
	 AND ta1.admin_id = ta.admin_id
	 $gemDateCondition
) AS 'NotAssigned',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.advisor_ref_id
	 WHERE gl.gem_status = 'Abandon'
	 AND ta1.admin_id = ta.admin_id
	 $gemDateCondition
) AS 'Abandon',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.advisor_ref_id
	 WHERE gl.gem_status = 'ConvertedAbroad'
	 AND ta1.admin_id = ta.admin_id
	 $gemDateCondition
) AS 'ConvertedAbroad',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.advisor_ref_id
	 WHERE gl.gem_status = 'ConvertedIndia'
	 AND ta1.admin_id = ta.admin_id
	 $gemDateCondition
) AS 'ConvertedIndia'

FROM `gem_lead_prospect` glp
LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp.gem_lead_ref_id
LEFT JOIN tbl_admin ta ON ta.admin_id = glp.advisor_ref_id
AND glp.added_on BETWEEN '$fromDate' AND '$toDate'
GROUP BY glp.advisor_ref_id

) testreports GROUP BY admin_id";

        $rawData=Yii::app()->db->createCommand($sql)->queryAll();
            return new CArrayDataProvider($rawData, array(
                'pagination'=>array(
                    'pageSize'=>20,
                ),
                'sort' => array(
                    //'defaultOrder' => 'assigned_date DESC',
                    'sortVar' => 'sort',
                    'attributes' => array(
                    ),
                )
            ));
    }

    public static function getShortlistLeadsReport($from_date=false,$to_date=false){
        //Decide dates based on input filters.
        $toDate = date('Y-m-d 23:23:59');
        $fromDate = '1970-01-01 00:00:00';

        if(!empty($from_date)){
            list($m, $d, $y) = explode('/', $from_date);

            $fromDate = $y.'-'.$m.'-'.$d.' 00:00:00';
        }
        if(!empty($to_date)){
            list($m, $d, $y) = explode('/', $to_date);

            $toDate = $y.'-'.$m.'-'.$d.' 00:00:00';
        }

        $dateCondition = " AND p1.added_on BETWEEN '$fromDate' AND '$toDate'";
        $gemDateCondition = " AND glp1.added_on BETWEEN '$fromDate' AND '$toDate'";

     $sql = "SELECT admin_id,admin_name,SUM(cnt) AS total,SUM(cnt2) AS total2,SUM(ConvertedIndia) AS ConvertedIndia,SUM(ConvertedAbroad) AS ConvertedAbroad,SUM(Abandon) AS Abandon,SUM(NotAssigned) AS NotAssigned,SUM(InProgress) AS InProgress,SUM(ConfirmedToPay) AS ConfirmedToPay,SUM(Lost) AS Lost,SUM(NotIntrested) AS NotIntrested
FROM (
SELECT admin_id,ta.admin_name,short_list_advisor_ref_id,
(
	 SELECT COUNT(short_list_advisor_ref_id)
	 FROM prospect p1
	 WHERE ta.admin_id = p1.short_list_advisor_ref_id
	 AND p1.short_list_advisor_ref_id IS NOT NULL
	 $dateCondition
) AS 'cnt',
(
    SELECT COUNT(*) FROM prospect p2
    WHERE p2.advisor_ref_id IS NULL
    AND p2.prospect_status='NotAssigned'
    AND p2.short_list_advisor_ref_id IS NULL
    AND p2.added_on BETWEEN '$fromDate' AND '$toDate'
) as cnt2,
(
	 SELECT COUNT(*) AS NotIntrested
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.short_list_advisor_ref_id
	 WHERE p1.prospect_status = 'NotIntrested'
	 AND p1.short_list_advisor_ref_id = p.short_list_advisor_ref_id
	 AND p1.short_list_advisor_ref_id IS NOT NULL
	 $dateCondition
) AS 'NotIntrested',
(
	 SELECT COUNT(*) AS Lost
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.short_list_advisor_ref_id
	 WHERE p1.prospect_status = 'Lost'
	 AND p1.short_list_advisor_ref_id = p.short_list_advisor_ref_id
	 AND p1.short_list_advisor_ref_id IS NOT NULL
	 $dateCondition
) AS 'Lost',
(
	 SELECT COUNT(*) AS ConfirmedToPay
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.short_list_advisor_ref_id
	 WHERE p1.prospect_status = 'ConfirmedToPay'
	 AND p1.short_list_advisor_ref_id = p.short_list_advisor_ref_id
	 AND p1.short_list_advisor_ref_id IS NOT NULL
	 $dateCondition
) AS 'ConfirmedToPay',
(
	 SELECT COUNT(*) AS InProgress
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.short_list_advisor_ref_id
	 WHERE p1.prospect_status = 'InProgress'
	 AND p1.short_list_advisor_ref_id = p.short_list_advisor_ref_id
	 AND p1.short_list_advisor_ref_id IS NOT NULL
	 $dateCondition
) AS 'InProgress',
(
	 SELECT COUNT(*) AS NotAssigned
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.short_list_advisor_ref_id
	 WHERE p1.prospect_status = 'NotAssigned'
	 AND p1.short_list_advisor_ref_id = p.short_list_advisor_ref_id
	 AND p1.short_list_advisor_ref_id IS NOT NULL
	 $dateCondition
) AS 'NotAssigned',
(
	 SELECT COUNT(*) AS Abandon
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.short_list_advisor_ref_id
	 WHERE p1.prospect_status = 'Abandon'
	 AND p1.short_list_advisor_ref_id = p.short_list_advisor_ref_id
	 AND p1.short_list_advisor_ref_id IS NOT NULL
	 $dateCondition
) AS 'Abandon',
(
	 SELECT COUNT(*) AS ConvertedAbroad
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.short_list_advisor_ref_id
	 WHERE p1.prospect_status = 'ConvertedAbroad'
	 AND p1.short_list_advisor_ref_id = p.short_list_advisor_ref_id
	 AND p1.short_list_advisor_ref_id IS NOT NULL
	 $dateCondition
) AS 'ConvertedAbroad',
(
	 SELECT COUNT(*) AS ConvertedIndia
	 FROM prospect p1
	 LEFT JOIN tbl_admin ta ON ta.admin_id = p1.short_list_advisor_ref_id
	 WHERE p1.prospect_status = 'ConvertedIndia'
	 AND p1.short_list_advisor_ref_id = p.short_list_advisor_ref_id
	 AND p1.short_list_advisor_ref_id IS NOT NULL
	 $dateCondition
) AS 'ConvertedIndia'

FROM prospect p
LEFT JOIN tbl_admin ta ON ta.admin_id = p.short_list_advisor_ref_id
GROUP BY p.short_list_advisor_ref_id

UNION ALL

SELECT admin_id,ta.admin_name,short_list_advisor_ref_id,
(
	 SELECT COUNT(short_list_advisor_ref_id)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 WHERE ta.admin_id = glp1.short_list_advisor_ref_id
	 AND glp1.short_list_advisor_ref_id IS NOT NULL
	 $gemDateCondition
) As 'cnt',

(
     SELECT COUNT(*) FROM gem_lead_prospect glp2
	 LEFT JOIN gem_lead gl2 ON gl2.gem_lead_id = glp2.gem_lead_ref_id
	 WHERE gl2.gem_status = 'NotAssigned'
	 AND glp2.short_list_advisor_ref_id IS NULL
	 AND glp2.advisor_ref_id IS NULL
	 AND glp2.added_on BETWEEN '$fromDate' AND '$toDate'
) As 'cnt2',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.short_list_advisor_ref_id
	 WHERE gl.gem_status = 'NotIntrested'
	 AND ta1.admin_id = ta.admin_id
	 AND glp1.short_list_advisor_ref_id IS NOT NULL
	 $gemDateCondition
) AS 'NotIntrested',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.short_list_advisor_ref_id
	 WHERE gl.gem_status = 'Lost'
	 AND ta1.admin_id = ta.admin_id
	 AND glp1.short_list_advisor_ref_id IS NOT NULL
	 $gemDateCondition

) AS 'Lost',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.short_list_advisor_ref_id
	 WHERE gl.gem_status = 'ConfirmedToPay'
	 AND ta1.admin_id = ta.admin_id
	 AND glp1.short_list_advisor_ref_id IS NOT NULL
	 $gemDateCondition
) AS 'ConfirmedToPay',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.short_list_advisor_ref_id
	 WHERE gl.gem_status = 'InProgress'
	 AND ta1.admin_id = ta.admin_id
	 AND glp1.short_list_advisor_ref_id IS NOT NULL
	 $gemDateCondition
) AS 'InProgress',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.short_list_advisor_ref_id
	 WHERE gl.gem_status = 'NotAssigned'
	 AND ta1.admin_id = ta.admin_id
	 AND glp1.short_list_advisor_ref_id IS NOT NULL
	 $gemDateCondition
) AS 'NotAssigned',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.short_list_advisor_ref_id
	 WHERE gl.gem_status = 'Abandon'
	 AND ta1.admin_id = ta.admin_id
	 AND glp1.short_list_advisor_ref_id IS NOT NULL
	 $gemDateCondition
) AS 'Abandon',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.short_list_advisor_ref_id
	 WHERE gl.gem_status = 'ConvertedAbroad'
	 AND ta1.admin_id = ta.admin_id
	 AND glp1.short_list_advisor_ref_id IS NOT NULL
	 $gemDateCondition
) AS 'ConvertedAbroad',
(
	 SELECT COUNT(*)
	 FROM `gem_lead_prospect` glp1
	 LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp1.gem_lead_ref_id
	 LEFT JOIN tbl_admin ta1 ON ta1.admin_id = glp1.short_list_advisor_ref_id
	 WHERE gl.gem_status = 'ConvertedIndia'
	 AND ta1.admin_id = ta.admin_id
	 AND glp1.short_list_advisor_ref_id IS NOT NULL
	 $gemDateCondition
) AS 'ConvertedIndia'

FROM `gem_lead_prospect` glp
LEFT JOIN gem_lead gl ON gl.gem_lead_id = glp.gem_lead_ref_id
LEFT JOIN tbl_admin ta ON ta.admin_id = glp.short_list_advisor_ref_id
GROUP BY glp.short_list_advisor_ref_id

) testreports GROUP BY admin_id";

        $rawData=Yii::app()->db->createCommand($sql)->queryAll();
        return new CArrayDataProvider($rawData, array(
            'pagination'=>array(
                'pageSize'=>20,
            ),
            'sort' => array(
                //'defaultOrder' => 'assigned_date DESC',
                'sortVar' => 'sort',
                'attributes' => array(
                ),
            )
        ));
    }
}



