<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseOfflineF2fCounsellor');

class OfflineF2fCounsellor extends BaseOfflineF2fCounsellor
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

    public function rules() {
        return array(
            array('inst_ref_id, f2f_counsellor, start_date, end_date, is_active', 'required', 'on' => 'f2f'),
            array('end_date, start_date', 'validateDate', 'on' => 'f2f'),
            array('inst_ref_id', 'checkCombination', 'on' => 'f2f'),
            array('f2f_id, inst_ref_id, f2f_counsellor, start_date, end_date, is_active, added_on, added_by, last_sync', 'safe'),
        );
    }

    public function attributeLabels() {
        return array(
            'inst_ref_id' => 'School',
            'f2f_counsellor' => 'F2F counsellor',
            'is_active' => 'Status'
        );
    }

    public function validateDate()
    {
        if($this->start_date && $this->end_date && ($this->start_date > $this->end_date) ){
            $this->addError("end_date", 'End date must greater than start date');
        }
    }

    public function checkCombination()
    {
        if($this->inst_ref_id && $this->f2f_counsellor){
            $cond = $this->f2f_id  ? " AND f2f_id != '".$this->f2f_id."'" : '';
            $exists = self::model()->exists("inst_ref_id = '".$this->inst_ref_id."' AND f2f_counsellor = '".$this->f2f_counsellor."' $cond");
            if($exists){
                $this->addError("inst_ref_id", 'School & Counsellor combination already exist');
            }
        }
    }

    public function _ce($error){

        return '<div class="holder"><p>'.$error.'</p></div>';
    }

    public function addError($attribute,$error) {

        parent::addError($attribute, $this->_ce($error));
    }

    public function getOfflineCounsellors(){

      $criteria = new CDbCriteria();
      if($this->inst_ref_id){
            $criteria->addCondition("t.inst_ref_id = '".$this->inst_ref_id."' ");
      }
      if($this->f2f_counsellor){
          $criteria->addCondition("t.f2f_counsellor = '".$this->f2f_counsellor."' ");
      }

      return new CActiveDataProvider(self::model(), array(
          'criteria'=>$criteria,
          'pagination'=>array(
              'pageSize'=>20,
          ),
          'sort' => array(
              'sortVar' => 'sort',
              'attributes' => array(
                  ''
              ),
          )
      ));

  }

    public static function localChange($userId){
        $checkUser = UserLocalChanges::model()->findByAttributes(array('user_ref_id'=>$userId));
        if(!$checkUser){
            $f2fModel = new UserLocalChanges();
            $f2fModel->user_ref_id = $userId;
            $f2fModel->added_on = date('Y-m-d H:i:s');
            $f2fModel->save(false);
        }
        $userModel = TblUserMaster::model()->findByPk($userId);
        if($userModel){
            $userModel->production_sync = null;
            $userModel->save(false);
        }
    }
}