<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseLookupSubjectMaster');

class LookupSubjectMaster extends BaseLookupSubjectMaster
{
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    public static function getSubjectsList($boardId) {
        $sql ="SELECT DISTINCT lss.`student_subject_id`,lsm.subject_name,lbe.board_ref_id,lbe.`class_level`,lb.board_name
                  FROM `lookup_subject_master` lsm
                  JOIN `department_subject` ds ON ds.subject_ref_id = lsm.`subject_master_id`
                  JOIN `lookup_student_subject` lss ON lss.`subject_master_ref_id` = lsm.`subject_master_id`
                  JOIN lookup_board_equivalent lbe ON lbe.`board_equivalent_id` = lss.`board_ref_id`
                  JOIN lookup_board lb ON lb.board_id = lbe.board_ref_id
                  WHERE lbe.`board_equivalent_id` = '$boardId'";
        $command =Yii::app()->db->createCommand($sql);
        $res =$command->queryAll();
        return $res;
    }

    public static function saveTwelveSubjects($postData,$key) {
        $subjectName = $postData['other_subject_12'][$key];
        $existSubject = LookupSubjectMaster::model()->findByAttributes(array('subject_name'=>$subjectName));
        if(count($existSubject)<1) {
            $model = new LookupSubjectMaster();
            $model->subject_name = $subjectName;
            $model->added_on = date('Y-m-d H:i:s');
            $model->user_entered = 1;
            $model->save();

            $subjectModel = new LookupStudentSubject();
            $subjectModel->board_ref_id = $postData['board_12'];
            $subjectModel->subject_name = $subjectName;
            $subjectModel->subject_master_ref_id = $model->subject_master_id;
            $subjectModel->added_on = date('Y-m-d H:i:s');
            $subjectModel->save(false);
            return $subjectModel->student_subject_id;
        }
        else{
            $subject = LookupStudentSubject::model()->findByAttributes(array('subject_name'=>$subjectName,'board_ref_id'=>$postData['board_12']));
            return $subject->student_subject_id;

        }

    }

    public static function add_student_subject($subject_title, $board_equivalent_id){

        if(!LookupStudentSubject::model()->exists('subject_name = :title AND board_ref_id = :board_id', [':title' => $subject_title, ':board_id' => (int)$board_equivalent_id])){

            $LookupSubjectMaster = LookupSubjectMaster::model()->find('subject_name = :title', [':title' => $subject_title]);
            if(!$LookupSubjectMaster){
                $LookupSubjectMaster = new LookupSubjectMaster;
                $LookupSubjectMaster->subject_name  = $subject_title;
                $LookupSubjectMaster->added_on      = date('Y-m-d H:i:s');
                $LookupSubjectMaster->user_entered  = 1;
                $LookupSubjectMaster->save(FALSE);
            }

            $StudentSubject = new LookupStudentSubject;
            $StudentSubject->board_ref_id           = (int)$board_equivalent_id;
            $StudentSubject->subject_name           = $subject_title;
            $StudentSubject->subject_master_ref_id  = $LookupSubjectMaster->subject_master_id;
            $StudentSubject->added_on               = date('Y-m-d H:i:s');
            $StudentSubject->save(false);
        }else{
            $StudentSubject = LookupStudentSubject::model()->find('subject_name = :title AND board_ref_id = :board_id', [':title' => $subject_title, ':board_id' => (int)$board_equivalent_id]);
        }

        return $StudentSubject;
    }

    public static function saveTenthSubjects($postData,$key ,$class = false) {
        $subjectName = $postData['other_subject_10'][$key];
        if($class == 9){
            $subjectName = $postData['other_subject_9'][$key];
        }
        $existSubject = LookupSubjectMaster::model()->findByAttributes(array('subject_name'=>$subjectName));
        if(count($existSubject)<1) {
            $model = new LookupSubjectMaster();
            $model->subject_name = $subjectName;
            $model->added_on = date('Y-m-d H:i:s');
            $model->user_entered = 1;
            $model->save();

            $subjectModel = new LookupStudentSubject();
            $subjectModel->board_ref_id = $postData['board_10'];
            $subjectModel->subject_name = $subjectName;
            $subjectModel->subject_master_ref_id = $model->subject_master_id;
            $subjectModel->added_on = date('Y-m-d H:i:s');
            $subjectModel->save(false);
            return $subjectModel->student_subject_id;
        }
        else{
            $subject = LookupStudentSubject::model()->findByAttributes(array('subject_name'=>$subjectName,'board_ref_id'=>$postData['board_10']));
            return $subject->student_subject_id;

        }
    }
}