<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseLookupStudentSubject');

class LookupStudentSubject extends BaseLookupStudentSubject {

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getPreferredSubjectsByDepartment($board = 0, $departmentIds = array()) {
        $subjects = array();
        $preferredSubjects = array();
        $preferredSubjectIds = array();
        $curricularSubjects = array();

        //Preferred Subjects
        if (count($departmentIds) > 0) {
            $cdbCriteria = new CDbCriteria();
            $cdbCriteria->join = " LEFT JOIN lookup_subject_master lsm ON lsm.subject_master_id = t.subject_master_ref_id ";
            $cdbCriteria->join.= " LEFT JOIN department_subject ds ON ds.subject_ref_id = t.subject_master_ref_id";
            $cdbCriteria->addInCondition('department_ref_id', $departmentIds, 'AND');
            $cdbCriteria->addCondition("t.board_ref_id='$board'", "AND");
            $cdbCriteria->addCondition("lsm.user_entered='0'", "AND");
            $cdbCriteria->order = "t.subject_name";
            $result = self::model()->findAll($cdbCriteria);
            if (count($result) > 0) {
                foreach ($result as $subject) {
                    $preferredSubjects[$subject->attributes['student_subject_id']] = $subject->attributes['subject_name'];
                }
            }
        }
        if (count($preferredSubjects) > 0) {
            $subjects['Preferred Subjects'] = $preferredSubjects;
            $preferredSubjectIds = array_keys($preferredSubjects);
        }

        //Other Subjects
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->join = " LEFT JOIN lookup_subject_master lsm ON lsm.subject_master_id = t.subject_master_ref_id ";
        $cdbCriteria->addCondition("board_ref_id = '$board'", "AND");
        if (count($preferredSubjectIds) > 0) {
            $cdbCriteria->addNotInCondition("student_subject_id", $preferredSubjectIds, "AND");
        }
        $cdbCriteria->addCondition("lsm.user_entered='0'", "AND");
        $cdbCriteria->order = "subject_name";
        $result = self::model()->findAll($cdbCriteria);
        if (count($result) > 0) {
            foreach ($result as $subject) {
                $otherSubjects[$subject->attributes['student_subject_id']] = $subject->attributes['subject_name'];
            }
        }
        //$otherSubjects['others'] = 'Others';
        if (count($preferredSubjects) > 0) {
            $subjects['Other Subjects'] = $otherSubjects;
        } else {
            $subjects = $otherSubjects;
        }

        return $subjects;
    }

    
    public function getPreferredSubjectsByDeptWithoutOtherSubject($board = 0, $departmentIds = array()) {
        $subjects = array();
        $preferredSubjects = array();
        $preferredSubjectIds = array();
        $curricularSubjects = array();

        //Preferred Subjects
        if (count($departmentIds) > 0) {
            $cdbCriteria = new CDbCriteria();
            $cdbCriteria->join = "LEFT JOIN lookup_subject_master lsm ON lsm.subject_master_id = t.subject_master_ref_id ";
            $cdbCriteria->join.= " LEFT JOIN department_subject ds ON ds.subject_ref_id = t.subject_master_ref_id";
            $cdbCriteria->addInCondition('department_ref_id', $departmentIds, 'AND');
            $cdbCriteria->addCondition("t.board_ref_id='$board'", "AND");
            $cdbCriteria->addCondition("lsm.user_entered='0'", "AND");
            $cdbCriteria->order = "t.subject_name";
            $result = self::model()->findAll($cdbCriteria);
            if (count($result) > 0) {
                foreach ($result as $subject) {
                    $preferredSubjects[$subject->attributes['student_subject_id']] = $subject->attributes['subject_name'];
                }
            }
        }
        if (count($preferredSubjects) > 0) {
            $subjects['Preferred Subjects'] = $preferredSubjects;
        }
        return $subjects;
    }
    
    
    public static function getSubjectListByBoard($boardId = 0) {


        $criteria = new CDbCriteria();
        $criteria->select = "t.student_subject_id, t.subject_name";
        $criteria->join = "LEFT JOIN lookup_subject_master lsm ON lsm.subject_master_id = t.subject_master_ref_id ";
        $criteria->with = array(
            'boardRef' => array('select' => 'boardRef.board_equivalent_id', 'joinType' => 'INNER JOIN'),
        );
        $criteria->condition = "boardRef.board_equivalent_id = '" . $boardId . "'";
        $criteria->addCondition("lsm.user_entered='0'", "AND");
        $criteria->order = 't.subject_name ASC';
        $data = LookupStudentSubject::model()->findAll($criteria);
        return $data;
    }


    public function getNinthPreferredSubjects($board = 0, $departmentIds = array()) {
        $subjects = array();
        $preferredSubjects = array();
        $preferredSubjectIds = array();
        $curricularSubjects = array();

        //Preferred Subjects
        if (count($departmentIds) > 0) {
            $cdbCriteria = new CDbCriteria();
            $cdbCriteria->join = "LEFT JOIN department_subject ds ON ds.subject_ref_id = t.subject_master_ref_id";
            $cdbCriteria->addCondition("t.board_ref_id='$board'", "AND");
            $cdbCriteria->order = "t.subject_name";
            $result = self::model()->findAll($cdbCriteria);
            if (count($result) > 0) {
                foreach ($result as $subject) {
                    $preferredSubjects[$subject->attributes['student_subject_id']] = $subject->attributes['subject_name'];
                }
            }
        }
        if (count($preferredSubjects) > 0) {
            $subjects['Preferred Subjects'] = $preferredSubjects;
            $preferredSubjectIds = array_keys($preferredSubjects);
        }

        //Other Subjects
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("board_ref_id = '$board'", "AND");
        if (count($preferredSubjectIds) > 0) {
            $cdbCriteria->addNotInCondition("student_subject_id", $preferredSubjectIds, "AND");
        }
        $cdbCriteria->order = "subject_name";
        $result = self::model()->findAll($cdbCriteria);
        if (count($result) > 0) {
            foreach ($result as $subject) {
                $otherSubjects[$subject->attributes['student_subject_id']] = $subject->attributes['subject_name'];
            }
        }

        if (count($preferredSubjects) > 0) {
            $subjects['Other Subjects'] = $otherSubjects;
        } else {
            $subjects = $otherSubjects;
        }

        return $subjects;
    }

    public function getPreferredSubjectsByDepartmentByTerm($term, $board = 0, $departmentIds = array()) {
        $subjects = array();
        $preferredSubjects = array();
        $preferredSubjectIds = array();
        $curricularSubjects = array();

        //Preferred Subjects
        if (count($departmentIds) > 0) {
            $cdbCriteria = new CDbCriteria();
            $cdbCriteria->join = "LEFT JOIN lookup_subject_master lsm ON lsm.subject_master_id = t.subject_master_ref_id ";
            $cdbCriteria->join.= " LEFT JOIN department_subject ds ON ds.subject_ref_id = t.subject_master_ref_id";
            $cdbCriteria->addInCondition('department_ref_id', $departmentIds, 'AND');
            $cdbCriteria->addCondition("t.board_ref_id='$board'", "AND");
            $cdbCriteria->addCondition("lsm.user_entered='0'", "AND");
            $cdbCriteria->addCondition("t.subject_name LIKE '".$term."%'", "AND");
            $cdbCriteria->order = "t.subject_name";
            $result = self::model()->findAll($cdbCriteria);
            if (count($result) > 0) {
                foreach ($result as $subject) {
                    $preferredSubjects[$subject->attributes['student_subject_id']] = $subject->attributes['subject_name'];
                }
            }
        }
        if (count($preferredSubjects) > 0) {
            $subjects = $preferredSubjects;
            $preferredSubjectIds = array_keys($preferredSubjects);
        }

        //Other Subjects
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->join = " LEFT JOIN lookup_subject_master lsm ON lsm.subject_master_id = t.subject_master_ref_id ";
        $cdbCriteria->addCondition("board_ref_id = '$board'", "AND");
        if (count($preferredSubjectIds) > 0) {
            $cdbCriteria->addNotInCondition("student_subject_id", $preferredSubjectIds, "AND");
        }
        $cdbCriteria->addCondition("t.subject_name LIKE '".$term."%'", "AND");
        $cdbCriteria->addCondition("lsm.user_entered='0'", "AND");
        $cdbCriteria->order = "subject_name";
        $result = self::model()->findAll($cdbCriteria);
        if (count($result) > 0) {
            foreach ($result as $subject) {
                $subjects[$subject->attributes['student_subject_id']] = $subject->attributes['subject_name'];
            }
        }

        return $subjects;
    }

    public static function getAutoSubjectListByBoard($term, $boardId = 0) {

        $criteria = new CDbCriteria();
        $criteria->select = "t.student_subject_id, t.subject_name";
        $criteria->join = "LEFT JOIN lookup_subject_master lsm ON lsm.subject_master_id = t.subject_master_ref_id ";
        $criteria->with = array(
            'boardRef' => array('select' => 'boardRef.board_equivalent_id', 'joinType' => 'INNER JOIN'),
        );
        $criteria->condition = "boardRef.board_equivalent_id = '" . $boardId . "'";
        $criteria->addCondition("lsm.user_entered ='0'", "AND");
        $criteria->addCondition("t.subject_name LIKE '".$term."%'", "AND");
        $criteria->order = 't.subject_name ASC';
        $data = LookupStudentSubject::model()->findAll($criteria);
        return $data;
    }
}