<?php

/**
 * This is the model class for table "lookup_school".
 *
 * The followings are the available columns in table 'lookup_school':
 * @property integer $school_id
 * @property string $school_name
 * @property integer $state
 * @property integer $city
 * @property integer $user_entered
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property TblSiDi[] $tblSiDis
 * @property TblUserMaster[] $tblUserMasters
 */
class LookupSchool extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupSchool the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_school';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('school_name, added_on', 'required'),
			array('state, city, user_entered', 'numerical', 'integerOnly'=>true),
			array('school_name', 'length', 'max'=>150),
			array('added_by', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('school_id, school_name, state, city, user_entered, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tblSiDis' => array(self::HAS_MANY, 'TblSiDi', 'school_ref_id'),
			'tblUserMasters' => array(self::HAS_MANY, 'TblUserMaster', 'school_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'school_id' => 'School',
			'school_name' => 'School Name',
			'state' => 'State',
			'city' => 'City',
			'user_entered' => 'User Entered',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('school_id',$this->school_id);
		$criteria->compare('school_name',$this->school_name,true);
		$criteria->compare('state',$this->state);
		$criteria->compare('city',$this->city);
		$criteria->compare('user_entered',$this->user_entered);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	 public static function getSchoolDetails($schoolId= false)
  {
       $criteria = new CDbCriteria;
	   $criteria->condition = "school_id = '".$schoolId."'";	       
	   $schoolDetails = self::model()->find($criteria);  
  	   return $schoolDetails; 		
  }

    public static function getSchoolID($schoolname)
    {
        $criteria = new CDbCriteria;
        //$criteria->condition = "school_name = '".addslashes($schoolname)."'";
        $criteria->addCondition("school_name = :school_name", "AND");
        $criteria->params = array(':school_name' => $schoolname);
        $criteria->addCondition("user_entered=0", "AND");
        $schoolID = self::model()->find($criteria);
        return $schoolID->attributes['school_id'];
    }

    public static function getUserSchoolID($schoolname)
    {
        $criteria = new CDbCriteria;
        $criteria->addCondition("school_name = :school_name", "AND");
        $criteria->params = array(':school_name' => $schoolname);
        $schoolID = self::model()->find($criteria);
        return $schoolID->attributes['school_id'];
    }

    public static function getPresentSchoolName($schoolId)
    {
        $criteria = new CDbCriteria;
        $criteria->select = "school_name";
        $criteria->condition = "school_id = '".$schoolId."'";
        $schoolName = self::model()->find($criteria);
        return $schoolName->attributes['school_name'];
    }

    public static function getSchoolDetailsByInstId($instId = 0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = "t.school_id, t.school_name";
        $cdbCriteria->join = "LEFT JOIN tbl_si_di sidi ON sidi.school_ref_id = t.school_id";
        $cdbCriteria->addCondition("sidi.inst_id = :instId", "AND");
        $cdbCriteria->addCondition("t.user_entered IS FALSE", "AND");
        $cdbCriteria->params = array(':instId' => $instId);
        $result = self::model()->find($cdbCriteria);
        return $result->attributes;
    }  

    public static function addStudentSchool($schoolName=''){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("school_name = :schoolName", "AND");
        $cdbCriteria->addCondition("user_entered IS TRUE", "AND");
        $cdbCriteria->params = array(':schoolName' => $schoolName);
        $model = self::model()->findByAttributes(array('school_name' => $schoolName, 'user_entered' => '1'));
        if(!$model){
            $model = new LookupSchool();
            $model->school_name = $schoolName;
            $model->user_entered = 1;
            $model->added_on = date('Y-m-d H:i:s');
            //$model->added_by = '';
            $model->save();
        }
    }

    public static function getSchoolList($term, $cityId=false)
    {
        $sqlSelect = 'SELECT DISTINCT(school_name),school_id FROM lookup_school ls
                    LEFT JOIN `tag_school` ts ON ts.school_ref_id = ls.school_id
                    LEFT JOIN tbl_si_di tsd ON tsd.school_ref_id = ls.school_id
                    WHERE (school_name LIKE "%'.$term.'%"  OR tag_name LIKE "%'.$term.'%"  ) AND user_entered <> 1 AND city_ref_id = "'.$cityId.'"
                UNION
                    SELECT DISTINCT(school_name),school_id FROM lookup_school ls
                    LEFT JOIN `tag_school` ts ON ts.school_ref_id = ls.school_id
                    INNER JOIN tbl_si_di tsd ON tsd.school_ref_id = ls.school_id
                    WHERE (school_name LIKE "%'.$term.'%"  OR tag_name LIKE "%'.$term.'%"  ) AND user_entered <> 1
                    LIMIT 10';
        // ORDER BY CASE WHEN school_name LIKE '".$term."%'  THEN 0 ELSE 1 END, LENGTH(school_name), school_name
        $cmd = Yii::app()->db->createCommand($sqlSelect);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getAllSchoolList($term, $limit = false)
    {
        $criteria = new CDbCriteria;
        $criteria->select = array('t.school_id', 't.school_name');
        $criteria->join = "LEFT JOIN school_franchise sf ON sf.school_ref_id = t.school_id";
       // $criteria->condition = "t.school_name LIKE '%$term%' AND (t.user_entered <> 1 OR t.is_approved = 'Y' OR sf.is_free = 'Y')";
        $criteria->condition = "t.school_name LIKE '%$term%'";
        $criteria->group = 't.school_name';
        $criteria->limit = $limit;

        $res = self::model()->findAll($criteria);
        return $res;
    }

}
