<?php

/**
 * This is the model class for table "lookup_popular_subdept_course".
 *
 * The followings are the available columns in table 'lookup_popular_subdept_course':
 * @property integer $popular_subdept_course_id
 * @property integer $sub_department_ref_id
 * @property string $course_name
 * @property integer $is_active
 *
 * The followings are the available model relations:
 * @property LookupDepartment $subDepartmentRef
 * @property StudentPreferredDepartment[] $studentPreferredDepartments
 */
class LookupPopularSubdeptCourse extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupPopularSubdeptCourse the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_popular_subdept_course';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sub_department_ref_id, course_name', 'required'),
			array('sub_department_ref_id, is_active', 'numerical', 'integerOnly'=>true),
			array('course_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('popular_subdept_course_id, sub_department_ref_id, course_name, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'subDepartmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'sub_department_ref_id'),
			'studentPreferredDepartments' => array(self::HAS_MANY, 'StudentPreferredDepartment', 'popular_subdept_course_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'popular_subdept_course_id' => 'Popular Subdept Course',
			'sub_department_ref_id' => 'Sub Department Ref',
			'course_name' => 'Course Name',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('popular_subdept_course_id',$this->popular_subdept_course_id);
		$criteria->compare('sub_department_ref_id',$this->sub_department_ref_id);
		$criteria->compare('course_name',$this->course_name,true);
		$criteria->compare('is_active',$this->is_active);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}