<?php

/**
 * This is the model class for table "lookup_popular_courses".
 *
 * The followings are the available columns in table 'lookup_popular_courses':
 * @property integer $popular_courses_id
 * @property string $course_name
 * @property integer $department_ref_id
 * @property integer $is_active
 *
 * The followings are the available model relations:
 * @property LookupDepartment $departmentRef
 * @property StudentPreferredDepartment[] $studentPreferredDepartments
 */
class LookupPopularCourses extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupPopularCourses the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_popular_courses';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
            array('course_name, main_dept_ref_id, department_ref_id, display_order, added_on', 'required'),
            array('main_dept_ref_id, department_ref_id, display_order, is_active', 'numerical', 'integerOnly'=>true),
			array('course_name', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
            array('popular_courses_id, course_name, main_dept_ref_id, department_ref_id, display_order, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
            'mainDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_dept_ref_id'),
			'studentPreferredDepartments' => array(self::HAS_MANY, 'StudentPreferredDepartment', 'popular_course_ref_id'),
            'studentPreferredDepartmentLogs' => array(self::HAS_MANY, 'StudentPreferredDepartmentLog', 'popular_course_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'popular_courses_id' => 'Popular Courses',
			'course_name' => 'Course Name',
            'main_dept_ref_id' => 'Main Dept Ref',
			'department_ref_id' => 'Department Ref',
            'display_order' => 'Display Order',
			'is_active' => 'Is Active',
            'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('popular_courses_id',$this->popular_courses_id);
		$criteria->compare('course_name',$this->course_name,true);
        $criteria->compare('main_dept_ref_id',$this->main_dept_ref_id);
		$criteria->compare('department_ref_id',$this->department_ref_id);
        $criteria->compare('display_order',$this->display_order);
		$criteria->compare('is_active',$this->is_active);
        $criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

    public static function getPopularCoursesByDepartment($departmentId = 0){
        $cdbCriteria = new CDbCriteria();
        //$cdbCriteria->join = "LEFT JOIN lookup_department ld ON ld.department_id = t.department_ref_id";
        //$cdbCriteria->addCondition("ld.main_dept_id = $departmentId", "AND");
        $cdbCriteria->addCondition("t.is_active = 1", "AND");
        $cdbCriteria->addCondition("t.main_dept_ref_id = $departmentId", "AND");
        $cdbCriteria->order = "t.display_order";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getPopularCoursesByName($term=''){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 't.*, ld.main_dept_id,ld.department_name';
        $cdbCriteria->join = "LEFT JOIN lookup_department ld ON ld.department_id = t.department_ref_id";
        $cdbCriteria->addCondition(" t.course_name LIKE '%".$term."%'", "AND");
        $cdbCriteria->order = "t.course_name";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getPopularCourseDetailsByName($courseName = ''){
        $result = self::getPopularCoursesByName($courseName);
        foreach($result as $popularCourse){
            return $popularCourse->departmentRef->attributes;
        }
    }
    
    /*public static function getPopularCourseList($term='',$limit=10,$status=true){
        $searchTerm = mysql_escape_string($term);
         $data = Yii::app()->db->createCommand()
            ->select('t.course_name,ld1.department_name, ld1.department_id')
            ->from('lookup_popular_courses AS t')
            ->join('lookup_department AS ld', 'ld.department_id = t.department_ref_id')
            ->join('lookup_department AS ld1', 'ld.main_dept_id = ld1.department_id')
            ->where(" t.course_name LIKE '%".$searchTerm."%' and t.is_active= ".$status)
            ->order("(CASE WHEN t.course_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), t.course_name")
            ->limit($limit)
            ->queryAll();
         return $data;
    }*/

    public static function getPopularCourseList($term='',$limit=10,$status=true){
        $searchTerm = mysql_escape_string($term);
        $data = Yii::app()->db->createCommand()
            ->select('department_name, main_dept_id,department_id')
            ->from('lookup_department')
            ->where(" department_name LIKE '%".$searchTerm."%' and is_active= 'Y'")
            ->limit($limit)
            ->queryAll();
        return $data;
    }
}