<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseLookupCurrency');

class LookupCurrency extends BaseLookupCurrency {

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getCurrencyList() {
        $criteria = New CDbCriteria;
        $criteria->select = 'currency_id,currency_name';
        $criteria->order = 'currency_name';
        $data = self::model()->findAll($criteria);
        foreach ($data as $value) {
            $currencyList[$value->attributes['currency_id']] = $value->attributes['currency_name'];
        }
        return $currencyList;
    }

    public static function getCurrencyListByCode() {
        $criteria = New CDbCriteria;
        $criteria->select = 'currency_code,currency_name';
        $criteria->order = 'currency_name';
        $data = self::model()->findAll($criteria);
        foreach ($data as $value) {
            $currencyList[$value->attributes['currency_code']] = $value->attributes['currency_name'];
        }
        return $currencyList;
    }

    public static function getCurrencyInfoAsArray(){
        $currencyInfo = array();
        $model = self::model()->findAll();
        foreach($model as $currency){
            $currencyInfo[$currency->attributes['currency_id']] = $currency->attributes;
        }
        return $currencyInfo;
    }
    public static function getCurrencyInfoById($currencyId){
        $currencyInfo = array();
        $model = self::model()->find('currency_id='.$currencyId);
        return $model;
    }

    public static function getCurrencyId($currencyCode=''){
        $model = self::model()->find("currency_code = '".$currencyCode."'");
        return $model->attributes['currency_id'];
    }
    
    public static function getCurrencyIdBycountry($countryname=''){
        $model = self::model()->find("country_name = '".$countryname."'");
        return $model;
    }    
}