<?php

/**
 * This is the model class for table "lookup_course_level".
 *
 * The followings are the available columns in table 'lookup_course_level':
 * @property integer $level_id
 * @property string $course_level
 * @property integer $parent_ref_id
 * @property string $is_active
 * @property integer $course_level_priority
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupCourselevelClass[] $lookupCourselevelClasses
 * @property StudentPreferredStudyLevel[] $studentPreferredStudyLevels
 */
class LookupCourseLevel extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupCourseLevel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_course_level';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('parent_ref_id, course_level_priority', 'numerical', 'integerOnly'=>true),
			array('course_level', 'length', 'max'=>255),
			array('is_active', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('level_id, course_level, parent_ref_id, is_active, course_level_priority, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'lookupCourselevelClasses' => array(self::HAS_MANY, 'LookupCourselevelClass', 'course_level_ref_id'),
			'studentPreferredStudyLevels' => array(self::HAS_MANY, 'StudentPreferredStudyLevel', 'course_level_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'level_id' => 'Level',
			'course_level' => 'Course Level',
			'parent_ref_id' => 'Parent Reference',
			'is_active' => 'Is Active',
			'course_level_priority' => 'Course Level Priority',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('level_id',$this->level_id);
		$criteria->compare('course_level',$this->course_level,true);
		$criteria->compare('parent_ref_id',$this->parent_ref_id);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('course_level_priority',$this->course_level_priority);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

    public static function getAllCourseLevelAsParentChild(){
        $courseLevel = array();
        $parentCourseLevel = self::getParentCourseLevel();
        foreach($parentCourseLevel as $parent){
            $childCourseLevel = self::getChildCourseLevel($parent->attributes['level_id']);
            $childCourseLevelArr = array();
            foreach($childCourseLevel as $child){
                $childCourseLevelArr[$child->attributes['level_id']] = $child->attributes['course_level'];
            }
            $courseLevel[$parent->attributes['course_level']] = $childCourseLevelArr;
        }
        return $courseLevel;
    }

    public static function getParentCourseLevel($excludeIds=array()){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("t.parent_ref_id = 0", "AND");
        $cdbCriteria->addCondition("t.is_active = 'Y'", "AND");
	
        if(count($excludeIds) > 0){
            $cdbCriteria->addNotInCondition('level_id', $excludeIds, "AND");
        }
	
        $cdbCriteria->order = "t.course_level";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getChildCourseLevel($parentCourseLevel = 0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("t.parent_ref_id = '".$parentCourseLevel."'", "AND");
        $cdbCriteria->addCondition("t.is_active = 'Y'", "AND");
        $cdbCriteria->order = "t.course_level";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getParentID($LevelId = 0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->condition = "t.level_id = '".$LevelId."' AND t.is_active = 'Y'";
        $result = self::model()->findAll($cdbCriteria);
        if($result[0]['parent_ref_id']!= 0)
            return $result[0]['parent_ref_id'];
        else
            return $LevelId;
    }
    
    public static function getParentIdByLevelId($LevelId = 0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->condition = "t.level_id = '".$LevelId."' AND t.is_active = 'Y'";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }
}