<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseLookupContactType');

class LookupContactType extends BaseLookupContactType
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

    /*
     *  Returns all contact types
     * returns except "student" contact type if "isStudent" is set to TRUE
     */
    public static function getContactType($isStudent = false){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("is_active = 1", "AND");
        if($isStudent){
            $cdbCriteria->addCondition("contact_type != 'Student'", "AND");
        }
        $cdbCriteria->order = "contact_type_id ASC";
        $result = LookupContactType::model()->findAll($cdbCriteria);
        return $result;
    }
}