<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseLookupBoardConversion');

class LookupBoardConversion extends BaseLookupBoardConversion
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

    public static function getGradesByBoard($boardEqId,$isEmpty=false)
    {
            $emptyText = 'Grade';
            $criteria = new CDbCriteria;
            $criteria->select = 't.board_conversion_id,t.board_marks';
            $criteria->distinct = true;
            $criteria->order = " board_conversion_id asc ";

            if($boardEqId == 31 || $boardEqId == 29) {
                $criteria->addCondition("t.board_ref_id=8", "AND");
                $criteria->addCondition("t.mark_type='S'", "AND");
                $criteria->order = " board_conversion_id DESC ";
            } else {
                $criteria->addCondition("t.board_equivalent_ref_id='".$boardEqId."'", "AND");
                $criteria->addInCondition("t.mark_type", array('OS','S'), "AND");
            }
            $grades = self::model()->findAll($criteria);

            $gradeList = array();
            if(!$isEmpty){
                $gradeList[''] = $emptyText;
            }
            foreach ($grades as $val) {
                $val->board_marks = ($val->board_marks == 'aa') ? 'a*' : $val->board_marks;
                $gradeList[$val->board_conversion_id] = strtoupper($val->board_marks);
            }
            return $gradeList;

    }
}