<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseEntranceExamPreparation');

class EntranceExamPreparation extends BaseEntranceExamPreparation
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  
  public function rules()
  {
          // NOTE: you should only define rules for those attributes that
          // will receive user inputs.
          return array(
                  array('entrance_exam_ref_id, added_by', 'required'),
                  array('entrance_exam_ref_id', 'numerical', 'integerOnly'=>true),
                  array('media_type', 'length', 'max'=>6),
                  array('name, author', 'length', 'max'=>255),
                  array('website_link', 'length', 'max'=>500),
                  array('added_by, modified_by', 'length', 'max'=>10),
                  array('modified_on', 'safe'),
                  // The following rule is used by search().
                  // Please remove those attributes that should not be searched.
                  array('entrance_exam_preparation_id, entrance_exam_ref_id, media_type, name, author, website_link, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
          );
  }
  
  public static function getmediaData($TestId,$mediaType)
  {
        $criteria = new CDbCriteria();
        $criteria->condition = "entrance_exam_ref_id=".$TestId." AND media_type='".$mediaType."'";
        //$criteria->condition = "entrance_exam_ref_id=:id AND media_type=:mediaType";
        //$criteria->params = array(':id' => $TestId,':mediaType'=>$mediaType);
        $data = self::model()->findAll($criteria);
        return $data;
  }
}