<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseCourseFees');

class CourseFees extends BaseCourseFees
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  
  public static function getCourseFeeDetail($courseId) {
              
      $feeDetail = Yii::app()->db->createCommand()
                ->select('reservation_name, fees, currency_code,duration, html_entity,currency_ref_id')
                ->from('course_fees AS cf')
                ->join('lookup_reservation AS lr', 'lr.reservation_id = cf.reservation_ref_id')
                ->join('lookup_currency AS lc', 'cf.currency_ref_id = lc.currency_id')
                ->join('lookup_course_fees_duration AS lcfd', 'lcfd.course_fees_duration_id = cf.course_fees_duration_ref_id')              
                ->where('uni_course_ref_id=:id', array(':id' => $courseId))
                ->queryAll();
        return $feeDetail;
  }
  
    public static function getAllCourseFees($limit = 0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->join  = "LEFT JOIN tbl_uni_courses course ON t.uni_course_ref_id = course.course_id
                               LEFT JOIN tbl_university_master um ON um.uni_id = course.uni_ref_id";
        $cdbCriteria->addCondition("t.fees IS NOT NULL", "AND");
        $cdbCriteria->addCondition("course.is_active = 'Y'", "AND");
        $cdbCriteria->group = "t.uni_course_ref_id";
        if($limit > 0){
            $cdbCriteria->limit = $limit;
        }
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getAllCourseFeesDetails($courseId = 0, $reservationString = ''){
        /*SELECT t.uni_course_ref_id, lr.reservation_name, cfd.duration, c.currency_code, t.fees
        FROM course_fees t
        LEFT JOIN tbl_uni_courses uc ON t.uni_course_ref_id = uc.course_id
        LEFT JOIN lookup_reservation lr ON lr.reservation_id = t.reservation_ref_id
        LEFT JOIN `lookup_course_fees_duration` cfd ON cfd.course_fees_duration_id = t.course_fees_duration_ref_id
        LEFT JOIN lookup_currency c ON c.currency_id = t.currency_ref_id
        WHERE uc.course_id = 116880 AND lr.reservation_name = 'General Category'*/

        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->join = "LEFT JOIN tbl_uni_courses uc ON t.uni_course_ref_id = uc.course_id
        LEFT JOIN lookup_reservation lr ON lr.reservation_id = t.reservation_ref_id
        LEFT JOIN `lookup_course_fees_duration` cfd ON cfd.course_fees_duration_id = t.course_fees_duration_ref_id
        LEFT JOIN lookup_currency c ON c.currency_id = t.currency_ref_id";
        $cdbCriteria->addCondition("uc.course_id = ".$courseId, "AND");
        $cdbCriteria->addCondition("lr.reservation_name = '".$reservationString."'", "AND");
        $cdbCriteria->order =   "(t.course_fees_duration_ref_id = 6) DESC,
                                (t.course_fees_duration_ref_id = 8) DESC,
                                (t.course_fees_duration_ref_id = 1) DESC,
                                (t.course_fees_duration_ref_id = 2) DESC,
                                (t.course_fees_duration_ref_id = 3) DESC,
                                (t.course_fees_duration_ref_id = 4) DESC,
                                (t.course_fees_duration_ref_id = 5) DESC,
                                (t.course_fees_duration_ref_id = 7) DESC,
                                (t.course_fees_duration_ref_id = 9) DESC";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

}