<?php

class NarniaProdSyncController extends Controller
{
    public $f2fLoginId;
    private $prodDb;

    public function init()
    {
        parent::init();
        ini_set('memory_limit', '1024M');
        set_time_limit(0);

        $host = Yii::app()->request->getParam('host');
        $db = Yii::app()->request->getParam('db');
        $username = Yii::app()->request->getParam('username');
        $password = Yii::app()->request->getParam('password');

        $this->prodDb = new CDbConnection('mysql:host=' . $host  . ';dbname=' . $db, $username, $password);

        $this->prodDb->createCommand('set foreign_key_checks=0')->execute();
        Yii::import('application.modules.milestoneprogress.models.MilestoneOfflineShare');
    }

    private function _switchDB($name='local'){
        try{
            $this->prodDb;
        }catch(Exception $e) {
            echo "<h2>Net connection required.</h2>";
            $e->getMessage();
            exit;
        }
        CActiveRecord::$db = ($name == 'local') ? Yii::app()->db : $this->prodDb;
    }

    public function actionSync()
    {
    	$this->_switchDB('local');
        $sql = "SELECT user_id, lm.login_id, username FROM login_master lm
                JOIN `tbl_user_master` um ON um.login_ref_id = lm.login_id
                JOIN user_local_changes ulc ON ulc.user_ref_id = um.user_id
                WHERE user_type_ref_id = 1 AND um.production_sync IS NULL ";
        $sql.= " ORDER BY lm.login_id DESC";
        $students = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        $this->_log("Total local students found: " . count($students),'production');
        echo "Total local students found: " . count($students);

        foreach ($students as $key => $localUser) {
        	$this->_switchDB('local');
            $transaction = CActiveRecord::$db->beginTransaction();
            try {
                $this->_switchDB('prodDb');
                $sql = "SELECT user_id, lm.login_id, username from tbl_user_master um
                        JOIN login_master lm ON lm.login_id = um.login_ref_id
                        WHERE username = '".$localUser->username."' ";
                $ProdUser = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
                if($ProdUser){
                    $this->deleteExistRecords($localUser, $ProdUser);
                    $this->syncCriticalFields($localUser, $ProdUser);
                }
                $transaction->commit();
                $this->_log(" - $ProdUser->user_id . ' - Production user synced'",'production');
                echo '<br>' . $ProdUser->user_id . ' - Production user synced.<br>';
            } catch (Exception $exc) {
                $transaction->rollback();
                echo $exc->getMessage();
            }
        }
        // Check Active F2F Counsellor
        $this->checkActiveCounsellor();
    }


    private function deleteExistRecords($localUser=false, $student)
    {
        $sql = "SELECT * FROM `narnia_local_to_prod_tables` WHERE is_active='Y' AND table_name NOT IN ('tbl_si_di','rbac_authassignment','student_grade_count','student_education_detail','user_entrance_exam_module','student_preferred_location','login_master','tbl_user_master','tbl_user_prof_critical_completion','umail_header','lookup_school','courses','umail_message') ORDER BY dependency_order DESC";

		$this->_switchDB('local');
        $tables = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        foreach ($tables as $k => $table) {
            $className = $table->class_name;
            $col_name = $table->column_name;

            $this->_switchDB('local');
            if(in_array($table->column_name, array('user_ref_id','student_ref_id'))){
                $col_name = 'user_id';
            }

            $criteria = new CDbCriteria;
            $criteria->addCondition("$table->column_name = '".$localUser->{$col_name}."' ");
            $criteria->order = "{$table->date_column} DESC";
            $localDate = $className::model()->find($criteria)->{$table->date_column};

            $this->_switchDB('prodDb');
            $criteriaProd = new CDbCriteria;
            $criteriaProd->addCondition("$table->column_name = '".$student->{$table->code_column}."' ");
            $criteriaProd->order = "{$table->date_column} DESC";
            $prodDate = $className::model()->find($criteriaProd)->{$table->date_column};

            if($table->delete_column){
                $this->_switchDB('local');
                $deleteDate = OfflineDeleteRecordLog::model()->findByAttributes(array('user_ref_id'=>$localUser->{$table->code_column}));
            }

            //if($prodDate < $localDate || !$prodDate || !$localDate){
            if($prodDate < $localDate){
                $this->_switchDB('prodDb');
                $className::model()->deleteAll($criteriaProd);
                $deletedTables[] = $className;
            }
            else if($table->delete_column){
                if($deleteDate && ( $localDate < $deleteDate->{$table->delete_column}) ){
                    $this->_switchDB('prodDb');
                    $className::model()->deleteAll($criteriaProd);
                    $deletedTables[] = $className;
                }
            }
        }
        $this->_log("Deleted existed tables who are updated in production".print_r($deletedTables, true),'production');
        //echo '<pre>'; print_r($deletedTables); //die;
        //if(count($deletedTables)){
            $this->tablesSync($student, $deletedTables);
        //}
    }


    private function tablesSync($student, $deletedTables = array())
    {
        if(count($deletedTables)){
            $this->_switchDB('local');
            $userSql = "SELECT user_id, lm.login_id, username FROM tbl_user_master um
                        JOIN login_master lm ON lm.login_id = um.login_ref_id
                        WHERE username = '".$student->username."' ";
            $this->_switchDB('local');
            $localUserInfo = CActiveRecord::$db->createCommand($userSql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
            $localUser = TblUserMaster::model()->findByAttributes(array('user_id' => $localUserInfo->user_id));
            $this->_switchDB('prodDb');
            $prodUser = TblUserMaster::model()->findByAttributes(array('user_id' => $student->user_id));

            if($prodUser->modified_on < $localUser->modified_on){
                $prodUser->attributes = $localUser->attributes;
                $prodUser->user_id = $student->user_id;
                $prodUser->login_ref_id = $student->login_id;
                $prodUser->save(false);
            }
        }

        $tablesList = implode("','",array_filter($deletedTables, function($tbl){
            return !in_array($tbl, array('StudentPreferredCountry','UserEntranceExam','StudentEducation','TblUniversityMaster'));
        }));

        $sql = "SELECT * FROM narnia_local_to_prod_tables WHERE is_active='Y'
             AND class_name IN ('".$tablesList."')
             ORDER BY dependency_order ASC";

        $this->_switchDB('local');
        $tables = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        foreach ($tables as $k => $table) {
            $className = $table->class_name;
            $tb_name = $table->table_name;
            $this->_switchDB('local');
            $tb = $className::model()->findAllByAttributes(array($table->column_name => $localUserInfo->{$table->code_column}));
            $this->_switchDB('prodDb');
            foreach ($tb as $data) {
                $res = new $className('search');
                $res->attributes = $data->attributes;
                unset($res->{$res->tableSchema->primaryKey});
                if ($table->table_name == 'tbl_user_master') {
                    $res->login_ref_id = $student->login_id;
                }
                if (!in_array($table->table_name, array('tbl_user_master','login_master'))) {
                    $res->{$table->column_name} = $student->{$table->code_column};
                }
                $res->save(false);
            }
        }

        $this->_switchDB('local');
        $sql = "SELECT * FROM narnia_local_to_prod_tables WHERE is_active='Y' AND is_dependency='Y'
             ORDER BY dependency_order ASC";
        if(count($deletedTables)){
            $sql = "SELECT * FROM narnia_local_to_prod_tables WHERE is_active='Y' AND is_dependency='Y'
             AND class_name NOT IN ('".$tablesList."')
             ORDER BY dependency_order ASC";
        }
        $this->_switchDB('local');
        $tables = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        if(count($tables)){
            foreach ($tables as $k => $table) {
                $className = $table->class_name;
                if (in_array($table->table_name, array('student_preferred_country')) && in_array('StudentPreferredCountry',$deletedTables)) {
                    $this->_switchDB('local');
                    $tb = $className::model()->findAllByAttributes(array('user_ref_id' => $localUser->user_id));
                    if($tb){
                        foreach ($tb as $k => $record) {
                            $res = new $className('search');
                            $res->attributes = $record->attributes;
                            unset($res->{$res->tableSchema->primaryKey});
                            $res->user_ref_id = $student->user_id;
                            $this->_switchDB('prodDb');
                            $res->save(false);
                            $this->_switchDB('local');

                            $childRecords = StudentPreferredLocation::model()->findAllByAttributes(array('preferred_country_ref_id' => $record->preferred_country_id ));

                            if (count($childRecords)) {
                                foreach ($childRecords as $k => $childRecord) {
                                    $childRes = new StudentPreferredLocation();
                                    $childRes->attributes = $childRecord->attributes;
                                    unset($childRes->{$childRes->tableSchema->primaryKey});
                                    $childRes->preferred_country_ref_id = $res->preferred_country_id;
                                    $this->_switchDB('prodDb');
                                    $childRes->save(false);
                                }
                            }
                        }
                    }
                }
                else if(in_array($table->table_name, array('user_entrance_exam')) && in_array('UserEntranceExam',$deletedTables)) {
                    $this->_switchDB('local');
                    $tb = $className::model()->findAllByAttributes(array('user_ref_id'=> $localUser->user_id),array('order'=>'user_entrance_exam_id ASC'));
                    if($tb){
                        foreach($tb as $k => $record) {
                            $res = new $className('search');
                            $res->attributes = $record->attributes;
                            unset($res->{$res->tableSchema->primaryKey});
                            $res->user_ref_id = $student->user_id;
                            $this->_switchDB('prodDb');
                            $res->save(false);

                            $this->_switchDB('local');
                            $childRecords = UserEntranceExamModule::model()->findAllByAttributes(array('user_entrance_exam_ref_id'=> $record->user_entrance_exam_id) );
                            if(count($childRecords)) {
                                foreach($childRecords as $k => $childRecord) {
                                    $childRes = new UserEntranceExamModule();
                                    $childRes->attributes = $childRecord->attributes;
                                    unset($childRes->{$childRes->tableSchema->primaryKey});
                                    $childRes->user_entrance_exam_ref_id = $res->user_entrance_exam_id;
                                    $this->_switchDB('prodDb');
                                    $childRes->save(false);
                                }
                            }
                        }
                    }
                }

                else if (in_array($table->table_name, array('student_education')) && in_array('StudentEducation',$deletedTables)) {
                    $this->_switchDB('local');
                    $tb = $className::model()->findAllByAttributes(array('user_ref_id'=> $localUser->user_id));
                    if($tb){
                        foreach($tb as $k => $record) {
                            $res = new $className('search');
                            $res->attributes = $record->attributes;
                            $this->_switchDB('prodDb');
                            unset($res->{$res->tableSchema->primaryKey});
                            $res->user_ref_id = $student->user_id;
                            $res->save(false);

                            $this->_switchDB('local');
                            $childRecords = StudentEducationDetail::model()->findAllByAttributes(array('student_education_ref_id'=> $record->student_education_id));
                            if(count($childRecords)) {
                                foreach($childRecords as $k => $childRecord) {
                                    $childRes = new StudentEducationDetail('search');
                                    $childRes->attributes = $childRecord->attributes;
                                    $this->_switchDB('prodDb');
                                    unset($childRes->{$childRes->tableSchema->primaryKey});
                                    $childRes->student_education_ref_id = $res->student_education_id;
                                    $childRes->save(false);
                                }
                            }

                            $this->_switchDB('local');
                            $childRecords = StudentGradeCount::model()->findAllByAttributes(array('student_education_ref_id'=> $record->student_education_id));
                            if(count($childRecords)) {
                                foreach($childRecords as $k => $childRecord) {
                                    $childRes = new StudentGradeCount('search');
                                    $childRes->attributes = $childRecord->attributes;
                                    $this->_switchDB('prodDb');
                                    unset($childRes->{$childRes->tableSchema->primaryKey});
                                    $childRes->student_education_ref_id = $res->student_education_id;
                                    $childRes->save(false);
                                }
                            }
                        }
                    }
                }
                else if(in_array($table->table_name, array('umail_header')) ) {
                    $this->_switchDB('local');
                    $tb = $className::model()->findAllByAttributes(array('sender_id'=> $localUser->user_id));
                    foreach($tb as $k => $record) {
                        $res = new $className('search');
                        $res->attributes = $record->attributes;
                        $this->_switchDB('prodDb');
                        unset($res->{$res->tableSchema->primaryKey});
                        $res->sender_id = $student->user_id;
                        $res->save(false);
                        //echo '<pre>'; print_r($record->attributes);
                        $this->_switchDB('local');
                        $childRecords = UmailMessage::model()->findAllByAttributes(array('header_ref_id'=> $record->header_id));
                        if(count($childRecords)) {
                            foreach($childRecords as $k => $childRecord) {
                                $childRes = new UmailMessage('search');
                                $childRes->attributes = $childRecord->attributes;
                                $this->_switchDB('prodDb');
                                unset($childRes->{$childRes->tableSchema->primaryKey});
                                $childRes->header_ref_id = $res->header_id;
                                $childRes->sender_id = $student->user_id;
                                $childRes->save(false);
                            }
                        }
                    }
					$this->_switchDB('local');
                    CActiveRecord::$db->createCommand()->delete('umail_header', 'sender_id=:id', array(':id'=>$localUser->user_id));
                }
                else if(in_array($table->table_name, array('courses')) ) {
                    $this->_switchDB('local');
                    $sql = "SELECT spd.course_ref_id, preferred_department_id, spd.main_dept_ref_id,spd.sub_dept_ref_id, course_name FROM student_preferred_department spd LEFT JOIN courses c ON c.course_id = spd.course_ref_id
                                    WHERE user_ref_id = '".$localUser->user_id."' AND course_ref_id IS NOT NULL";
                    $courses = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
                    foreach($courses as $k => $record) {
                        $this->_switchDB('local');
                        $courseRes = Courses::model()->findByAttributes(array('course_id'=> $record->course_ref_id));
                        if($courseRes) {
                            $this->_switchDB('ProdDb');
                            $res = Courses::model()->findByAttributes(array('course_name' => $courseRes->course_name, 'main_dept_ref_id'=> $courseRes->main_dept_ref_id,'sub_dept_ref_id'=> $courseRes->sub_dept_ref_id));
                            if(!$res){
                            $res = new Courses('search');
                            $res->attributes = $courseRes->attributes;
                            unset($res->{$res->tableSchema->primaryKey});
                            $res->save(false);
                            }
                            $childRecord = StudentPreferredDepartment::model()->findByAttributes(array('user_ref_id' => $student->user_id, 'main_dept_ref_id'=> $record->main_dept_ref_id,'sub_dept_ref_id'=> $record->sub_dept_ref_id));
							if($childRecord) {
								if($res->course_id){
									$childRecord->course_ref_id = $res->course_id;
									$childRecord->save(false);
								}
							}
                        }
                    }
                }
                else if(in_array($table->table_name, array('tbl_university_master')) ) {
                    $sql = "SELECT uni_name,uni_id,user_ref_id FROM `student_shortlist_university` spu
                            INNER JOIN tbl_university_master um ON um.uni_id = spu.uni_ref_id
                            WHERE user_ref_id = '".$localUser->user_id."' AND  is_user_entered='1' ";
                    $this->_switchDB('local');
                    $universities = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
                    if($universities) {
                        foreach($universities as $k => $record) {
                            $this->_switchDB('local');
                            $uniData = TblUniversityMaster::model()->findByPk($record->uni_id);
                            $this->_switchDB('ProdDb');
                            $universityRes = TblUniversityMaster::model()->findByAttributes(array('uni_name'=>$record->uni_name));
                            if(count($universityRes)<1){
                            $universityRes = new TblUniversityMaster('search');
                            $universityRes->attributes = $uniData->attributes;
                            $universityRes->uni_name = $uniData->uni_name;
                            unset($universityRes->{$universityRes->tableSchema->primaryKey});
                            $universityRes->save(false);
                            }
                            $uniRes = StudentShortlistUniversity::model()->findByAttributes(array('user_ref_id'=> $student->user_id,'uni_ref_id'=>$record->uni_id));
                            if($uniRes) {
                                $uniRes->uni_ref_id = $universityRes->uni_id;
                                $uniRes->save(false);
                            }
                            $uniAdmission = StudentOutplacementUniversity::model()->findByAttributes(array('user_ref_id'=> $student->user_id,'uni_ref_id'=>$record->uni_id));
                            if($uniAdmission) {
                                $uniAdmission->uni_ref_id = $universityRes->uni_id;
                                $uniAdmission->save(false);
                            }
                        }
                    }
                }
                else if(in_array($table->table_name, array('lookup_school')) ) {
                    $this->_switchDB('local');
                    $sql = "SELECT user_id, school_name, user_entered, school_id FROM tbl_user_master um
                            INNER JOIN lookup_school ls ON ls.school_id = um.school_ref_id
                            WHERE user_id  = '".$localUser->user_id."' ";
                    $school = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
                    if($school->user_id) {
                        $this->_switchDB('local');
                        if($school->user_entered == '0') {
                            $this->_switchDB('prodDb');
                            $userTable = TblUserMaster::model()->findByAttributes(array('user_id'=> $student->user_id));
                            $userTable->school_ref_id = $school->school_id;
                            $userTable->save(false);
                        } else {
                            $this->_switchDB('prodDB');
                            $res = LookupSchool::model()->findByAttributes(array('school_name'=> $school->school_name));
                            $this->_switchDB('local');
                            $schoolRecord = LookupSchool::model()->findByAttributes(array('school_id'=> $school->school_id));
                            if(!$res){
                            $res = new LookupSchool('search');
                            $res->attributes = $schoolRecord->attributes;
                            $this->_switchDB('prodDb');
                            $primaryKey = $res->tableSchema->primaryKey;
                            unset($res->$primaryKey);
                            $res->save(false);
                            }
                            $userTable = TblUserMaster::model()->findByAttributes(array('user_id'=> $student->user_id));
                            if($userTable){
                            $userTable->school_ref_id = $res->school_id;
                            $userTable->save(false);
                            }
                        }
                    }
                }
            }
        }

        $this->_switchDB('local');
        $this->syncMilestoneTrack($localUser->user_id,$student->user_id);
        $userModel = TblUserMaster::model()->findByAttributes(array('user_id' => $localUser->user_id));
        if ($userModel) {
            $userModel->production_sync = 'Y';
            $userModel->save(false);
        }
        CActiveRecord::$db->createCommand()->delete('milestone_offline_share', 'user_id=:user_id', array(':user_id'=>$localUser->user_id));

        $this->_switchDB('prodDb');
        $userModel = TblUserMaster::model()->findByAttributes(array('user_id' => $student->user_id));
        if ($userModel) {
            $userModel->production_sync = 'Y';
            $userModel->synced_on = date('Y-m-d H:i:s');
            $userModel->save(false);
        }

    }

    private function syncCriticalFields($localUser=false, $student){
        $this->_switchDB('local');
        $tb = TblUserProfCriticalCompletion::model()->findByAttributes(array('user_ref_id'=> $localUser->user_id));
        $this->_switchDB('prodDb');
        $res = TblUserProfCriticalCompletion::model()->findByAttributes(array('user_ref_id'=> $student->user_id));
        $attributes = array_filter(array_keys($tb->attributes), function($attr) use ($tb){
            return !$tb->{$attr};
        });
		if($attributes && $tb && $res) {
			$tb->unsetAttributes($attributes);
			$res->attributes = $tb->attributes;
			$res->user_ref_id = $student->user_id;
			$res->save(false);
		}
        $this->_log(" - Critical fields table synced'",'production');
    }

    private function checkActiveCounsellor(){
    	$this->_switchDB('prodDb');
        CActiveRecord::$db->createCommand('set foreign_key_checks=1')->execute();
        $this->_switchDB('local');
        $offlineData = OfflineF2fCounsellor::model()->find();
        if($offlineData){
            $this->_switchDB('prodDb');
            $admin = TblAdmin::model()->findByPk($offlineData->f2f_counsellor);
            if($admin->is_active == 'N'){
                $this->_switchDB('local');
                CActiveRecord::$db->createCommand('DROP DATABASE '.DBNAME)->execute();
            }
        }
        $this->_log(" - Database deleted due to inactive'",'production');
    }

    public function syncMilestoneTrack($localUserId,$studentId){
        $this->_switchDB('local');
        $trackData = MilestoneCounsellingTimetrack::model()->findAllByAttributes(array('student_ref_id'=>$localUserId) );
        foreach ($trackData as $data) {
            $this->_switchDB('prodDb');
            $res = MilestoneCounsellingTimetrack::model()->findByAttributes(array('student_ref_id'=>$studentId,'counsellor_ref_id'=>$data->counsellor_ref_id,'session_id'=>$data->session_id,'milestone_ref_id'=>$data->milestone_ref_id));
            //echo "++".$studentId."++".$data->counsellor_ref_id."++".$data->session_id."++"."$data->milestone_ref_id";
            if(!$res){
                $res = new MilestoneCounsellingTimetrack('search');
                $res->attributes = $data->attributes;
                unset($res->{$res->tableSchema->primaryKey});
                $res->student_ref_id = $studentId;
                $res->save(false);
            } else{
                $res->attributes = $data->attributes;
                $res->student_ref_id = $studentId;
                $res->save(false);
            }

        }

        }
}
