<?php

class NarniaController extends Controller
{
    public $f2fLoginId;
    public $f2fID;
    private $prodDb;

    public function init()
    {
        parent::init();
        ini_set('memory_limit', '1024M');
        set_time_limit(0);

        Yii::app()->db->createCommand('set foreign_key_checks=0')->execute();

        $db = Yii::app()->request->getParam('db');
        $host = Yii::app()->request->getParam('host');
        $username = Yii::app()->request->getParam('username');
        $password = Yii::app()->request->getParam('password');

        $this->prodDb = new CDbConnection('mysql:host=' . $host  . ';dbname=' . $db, $username, $password);
    }

    private function _switchDB($name='local'){
        try{
            $this->prodDb;
        }catch(Exception $e) {
            echo "<h2>Net connection required.</h2>";
            $e->getMessage();
            exit;
        }
        CActiveRecord::$db = ($name == 'local') ? Yii::app()->db : $this->prodDb;
    }

    public function actionSyncProdToLocalAllSchoolData()
    {
        $f2fID = Yii::app()->getRequest()->getParam('f2fAdmin', 0);

        echo $this->renderPartial('wait_msg', [], false, true);
		$rurl = $this->createUrl('/fcfcounsellor');
		flush();

		$command = 'c:\xampp\htdocs\app\protected\helpers\SyncProdToLocalAllSchoolData.exe '.$f2fID;
		exec($command);
		die('<script>window.location="'.$rurl.'";</script>');

    }

    public function actionSyncProdToLocalIndSchoolData()
    {
        $f2fID = Yii::app()->getRequest()->getParam('f2fAdmin', 0);
        $inst_id = Yii::app()->getRequest()->getParam('inst_id', 0);
        $f2fLogin = Yii::app()->getRequest()->getParam('f2fLogin', 0);

        echo $this->renderPartial('wait_msg', [], false, true);
		$rurl = $this->createUrl('/fcfcounsellor');
		flush();

		$command = 'c:\xampp\htdocs\app\protected\helpers\SyncProdToLocalIndSchoolData.exe '.$inst_id.' '.$f2fLogin.' '.$f2fID;
		exec($command);
		die('<script>window.location="'.$rurl.'";</script>');
    }

    public function actionSyncNewSchools(){

        $f2fAdminId = Yii::app()->request->getParam('f2fAdmin');
        echo $this->renderPartial('wait_msg', [], false, true);
		$rurl = $this->createUrl('/fcfcounsellor');
		flush();

		$command = 'c:\xampp\htdocs\app\protected\helpers\SyncNewSchools.exe '.$f2fAdminId;
		exec($command);
		die('<script>window.location="'.$rurl.'";</script>');
    }


    public function actionInstall()
    {
        echo $this->renderPartial('wait_msg', [], false, true);
        flush();

        $this->_log("Install started.");
        $this->_switchDB('prodDb');
        $this->f2fID = Yii::app()->getRequest()->getParam('f2fAdmin', 0);

        if($this->f2fID){
            $this->f2fLoginId = TblAdmin::model()->findByAttributes(array('admin_id'=>$this->f2fID))->login_ref_id;
        }

        $this->_switchDB('local');
        // Clean the data
        $this->truncateTableData();

        // For adviser dump
        $this->dumpCounsellorData();

		$this->_switchDB('prodDb');
        //  Student local sync start here
        /* Here we are get the records from the production which schools assigned to f2f counsellors */
        $sql = "SELECT user_id, lm.login_id, username FROM offline_f2f_counsellor oc
                JOIN tbl_si_students tss ON tss.inst_ref_id = oc.inst_ref_id
                JOIN `tbl_user_master` um ON um.user_id = tss.user_ref_id
                JOIN login_master lm ON lm.login_id = um.login_ref_id
                WHERE f2f_counsellor = $this->f2fID AND user_type_ref_id = 1 AND oc.is_active = 'Y'";
        $sql.= " ORDER BY lm.login_id DESC";

        $students = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();

        $this->_log("Total students found: " . count($students));

        foreach ($students as $key => $student) {
            $transaction = Yii::app()->db->beginTransaction();
            try {
                $this->_log('Prod studentID:'.$student->user_id);
                $this->_switchDB('local');
                $this->tablesSync($student);
                $transaction->commit();
                $this->_log($student->user_id.'- Prod User updated successfully');
                echo '<br>' . $student->user_id . ' - Prod User updated successfully.<br>';
            } catch (Exception $exc) {
                $transaction->rollback();
                //echo $exc->getTraceAsString();
                echo $exc->getMessage();
            }
        }

        $this->_syncF2FTable();

        //echo $this->renderPartial('wait_msg', ['rUrl' => $this->createUrl('/fcfcounsellor')], false, true);

    }

    private function dumpCounsellorData()
    {
        $adminSql = "SELECT DISTINCT(login_ref_id), user_type_ref_id,lm.username FROM tbl_admin ta
                    JOIN offline_f2f_counsellor oc ON oc.f2f_counsellor = ta.admin_id
                    JOIN login_master lm ON lm.login_id = ta.login_ref_id
                    AND user_type_ref_id = 4 AND f2f_counsellor = '".$this->f2fID."' ";
        try {
			$this->_switchDB('prodDb');
            $admins = CActiveRecord::$db->createCommand($adminSql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
            foreach ($admins as $key => $admin) {
                $transaction = Yii::app()->db->beginTransaction();
                try {
                    $this->_switchDB('local');
                    $exists = LoginMaster::model()->findByAttributes(array('username' => $admin->username));
                    if (count($exists) < 1) {
                        $className = 'LoginMaster';
                        $this->_switchDB('prodDb');
                        $tb = $className::model()->findByAttributes(array('username' => $admin->username));
                        $this->_switchDB('local');
                        $res = new $className('search');
                        unset($tb->{$tb->tableSchema->primaryKey});
                        $res->attributes = $tb->attributes;
                        $res->save(false);

                        $model = new RbacAuthassignment;
                        $model->itemname = 'Advisor';
                        $model->userid = $res->login_id;
                        $model->save(false);

                        $adminModel = TblAdmin::model()->findByAttributes(array('login_ref_id' => $admin->login_ref_id));
                        if($adminModel){
                            $adminModel->login_ref_id = $res->login_id;
                            $adminModel->save(false);
                        }
                    }
                    $transaction->commit();
                    $this->_log($admin->login_ref_id.'- admin updated successfully');
                    echo '<br>' . $admin->login_ref_id.' - admin updated successfully.<br>';
                } catch (Exception $exc) {
                    $transaction->rollback();
                    echo $exc->getMessage();
                }
            }
        } catch (Exception $e) {
            echo "<h2>Net connection required.</h2>";
            echo $e->getMessage();
            exit;
        }
        $this->_log("Counsellor Data imported(admin table data).");
    }

    private function truncateTableData()
    {
		$this->_switchDB('local');
        $command = CActiveRecord::$db->createCommand();
        $tablesToTruncate = ['user_local_changes','tbl_si_students','tbl_user_master','student_preferred_country','student_preferred_location','student_alternate_email','student_contact_number','student_preferred_department','student_preferred_university','student_shortlist_university','user_scholarship','student_shortlist_vendor','user_data_point','milestone_test_deadlines_chosen','student_interested_products','student_counselling_request','student_subject_help','student_product_comment','user_milestone_tracking',
            'self_country_status','user_entrance_exam_module','user_entrance_exam','tbl_user_prof_critical_completion','tbl_user_interest','student_summer_plan','student_preferred_subject','student_preferred_study_level','student_preferred_period','student_preferred_duration','student_preferred_career','profile_validation_score','profile_verification_score','signup_steps','student_citizenship','student_education','student_education_detail','student_grade_count','student_overall_percent','offline_f2f_counsellor','tbl_interaction_details','student_outplacement_university'];
        array_walk($tablesToTruncate, function($tbl) use($command){
            $command->truncateTable($tbl);
        });

        /*$criteria = new CDbCriteria;
        $criteria->select='min(login_id) AS login_id';
        $row = LoginMaster::model()->find($criteria);
        $minLoginId = $row['login_id'];*/

        $criteria = new CDbCriteria;
        $criteria->addCondition("login_id != '".$this->f2fLoginId."' ");
        LoginMaster::model()->deleteAll($criteria);

        $criteria = new CDbCriteria;
        $criteria->addCondition("userid != '".$this->f2fLoginId."' ");
        RbacAuthassignment::model()->deleteAll($criteria);

        $this->_log("Truncated user tables.");
    }

    public function actionLocalSync() {

        echo $this->renderPartial('wait_msg', [], false, true);
        flush();

        $instID = Yii::app()->getRequest()->getParam('inst_id', 0);
        $f2fLoginID = Yii::app()->getRequest()->getParam('f2fLogin', 0);
        $f2fAdminID = Yii::app()->getRequest()->getParam('f2fAdmin', 0);

        $this->_switchDB('local');
        $loginData = LoginMaster::model()->findByPk($f2fLoginID);
        $this->_switchDB('prodDb');
        $loginData = LoginMaster::model()->findByAttributes(array('username'=>$loginData->username));
        $this->f2fLoginId = $loginData->login_id;
        /* Here we are get the records from the production which schools assigned to f2f counsellors */
        $sql = "SELECT user_id, lm.login_id, username FROM offline_f2f_counsellor oc
                JOIN tbl_si_students tss ON tss.inst_ref_id = oc.inst_ref_id
                JOIN `tbl_user_master` um ON um.user_id = tss.user_ref_id
                JOIN login_master lm ON lm.login_id = um.login_ref_id
                WHERE f2f_counsellor = '".$f2fAdminID."' AND user_type_ref_id = 1
                AND (local_sync_by <> '".$this->f2fLoginId."' || local_sync_by IS NULL)";
        if($instID){
            $sql.= " AND tss.inst_ref_id = '".$instID."' AND oc.is_active = 'Y' ";
        }
        $sql.= " ORDER BY lm.login_id DESC";

		$this->_switchDB('prodDb');
        $students = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        //echo "Total students found: " . count($students);

        foreach ($students as $key => $ProdUser) {
            $this->_log("userId- ".$ProdUser->user_id);
            //echo '===='.$ProdUser->username.'<br>';
            $transaction = Yii::app()->db->beginTransaction();
            try {
                $sql = "SELECT user_id, login_ref_id, username from tbl_user_master um
                        JOIN login_master lm ON lm.login_id = um.login_ref_id
                        WHERE username = '".$ProdUser->username."' ";
				$this->_switchDB('local');
                $localUser = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
                if($localUser){
                    // echo 'update-'.$ProdUser->user_id;
                    $this->deleteExistRecords($ProdUser, $localUser);
                } else{
                    // echo 'insert-'.$ProdUser->user_id;
                    $this->tablesSync($ProdUser);
                }

                $transaction->commit();
                //echo '<br>' . $ProdUser->user_id . ' - User updated successfully.<br>';
            } catch (Exception $exc) {
                $transaction->rollback();
                echo $exc->getMessage();
            }
        }

        if($instID){
            $this->_switchDB('local');
            $model = OfflineF2fCounsellor::model()->findByAttributes(['inst_ref_id' => $instID]);
            $model->last_sync = date('Y-m-d H:i:s');
            $model->save(false);
        }
        //echo $this->renderPartial('wait_msg', ['rUrl' => $this->createUrl('/fcfcounsellor')], false, true);

    }

    private function tablesSync($student,$deletedTables = array())
    {
        // Get the tables data from local DataBase
        $sql = "SELECT * FROM narnia_prod_to_local_tables WHERE is_active='Y' AND is_dependency='N' ORDER BY dependency_order ASC";
        if(count($deletedTables)){
            $tablesList = implode("','",$deletedTables);
            $tablesList = implode("','",array_filter($deletedTables, function($tbl){
                return !in_array($tbl, array('StudentPreferredCountry','UserEntranceExam','StudentEducation','TblUniversityMaster'));
            }));
            $sql = "SELECT * FROM narnia_prod_to_local_tables WHERE is_active='Y' AND is_dependency='N'
             AND class_name IN ('".$tablesList."')
             ORDER BY dependency_order ASC";
            $this->_switchDB('local');
            $this->_updateUserMasterData($student);
        }
		$this->_switchDB('local');
        $tables = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        foreach ($tables as $k => $table) {
            $className = $table->class_name;
            $tb_name = $table->table_name;
            $this->_switchDB('prodDb');
            $tb = $className::model()->findAllByAttributes(array($table->column_name => $student->{$table->code_column}));

            $this->_switchDB('local');
            foreach ($tb as $data) {
                $res = new $className('search');
                unset($data->{$data->tableSchema->primaryKey});
                $res->attributes = $data->attributes;
                if ($table->table_name == 'tbl_user_master') {
                    $res->login_ref_id = Yii::app()->session->get('login_id');
                }
                if (!in_array($table->table_name, array('tbl_user_master','login_master'))) {
                    $res->{$table->column_name} = Yii::app()->session->get($table->code_column);
                }
                $res->save(false);
                if ($table->table_name == 'login_master') {
                    Yii::app()->session->add('login_id', $res->login_id);
                }
                else if ($table->table_name == 'tbl_user_master') {
                    Yii::app()->session->add('user_id', $res->user_id);
                }
            }
        }
        $this->_switchDB('local');

        $sql = "SELECT * FROM narnia_prod_to_local_tables WHERE is_active='Y' AND is_dependency='Y' ORDER BY dependency_order ASC";
        if(count($deletedTables)){
            $tablesList = implode("','",$deletedTables);
            $sql = "SELECT * FROM narnia_prod_to_local_tables WHERE is_active='Y' AND is_dependency='Y'
             AND class_name IN ('".$tablesList."')
             ORDER BY dependency_order ASC";
        }
		$this->_switchDB('local');
        $tables = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        if(count($tables)){
            foreach ($tables as $k => $table) {
                $className = $table->class_name;
                if (in_array($table->table_name, array('student_preferred_country'))) {
                    $this->_switchDB('prodDb');
                    $tb = $className::model()->findAllByAttributes(array('user_ref_id' => $student->user_id));
                    if($tb){
                        foreach ($tb as $k => $record) {
                            $res = new $className('search');
                            Yii::app()->session->add('pref_country_id', $record->preferred_country_id);
                            unset($record->{$record->tableSchema->primaryKey});
                            $res->attributes = $record->attributes;
                            $res->user_ref_id = Yii::app()->session->get('user_id');

                            $this->_switchDB('local');
                            $res->save(false);

                            $this->_switchDB('prodDb');
                            $childRecords = StudentPreferredLocation::model()->findAllByAttributes(array('preferred_country_ref_id' => Yii::app()->session->get('pref_country_id') ));
                            if (count($childRecords)) {
                                foreach ($childRecords as $k => $childRecord) {
                                    $childRes = new StudentPreferredLocation('search');
                                    unset($childRecord->{$childRecord->tableSchema->primaryKey});
                                    $childRes->attributes = $childRecord->attributes;
                                    $childRes->preferred_country_ref_id = $res->preferred_country_id;
                                    $this->_switchDB('local');
                                    $childRes->save(false);
                                }
                            }
                        }
                    }
                }

                else if(in_array($table->table_name, array('user_entrance_exam')) ) {
                    $this->_switchDB('prodDb');
                    $tb = $className::model()->findAllByAttributes(array('user_ref_id'=> $student->user_id),array('order'=>'user_entrance_exam_id ASC'));
                    if($tb){
                        foreach($tb as $k => $record) {
                            $res = new $className('search');
                            Yii::app()->session->add('exam_id', $record->user_entrance_exam_id);
                            unset($record->{$record->tableSchema->primaryKey});
                            $res->attributes = $record->attributes;
                            $res->user_ref_id = Yii::app()->session->get('user_id');
                            $this->_switchDB('local');
                            $res->save(false);

                            $this->_switchDB('prodDb');
                            $childRecords = UserEntranceExamModule::model()->findAllByAttributes(array('user_entrance_exam_ref_id'=> Yii::app()->session->get('exam_id')) );
                            if(count($childRecords)) {
                                foreach($childRecords as $k => $childRecord) {
                                    $childRes = new UserEntranceExamModule();
                                    $childRes->attributes = $childRecord->attributes;
                                    unset($childRecord->{$childRecord->tableSchema->primaryKey});
                                    $childRes->user_entrance_exam_ref_id = $res->user_entrance_exam_id;
                                    $this->_switchDB('local');
                                    $childRes->save(false);
                                }
                            }
                        }
                    }
                }

                else if (in_array($table->table_name, array('student_education'))) {
                    $this->_switchDB('prodDb');
                    $tb = $className::model()->findAllByAttributes(array('user_ref_id'=> $student->user_id));
                    if($tb){
                        foreach($tb as $k => $record) {
                            $res = new $className('search');
                            Yii::app()->session->add('edu_id', $record->student_education_id);
                            unset($record->{$record->tableSchema->primaryKey});
                            $res->attributes = $record->attributes;
                            $this->_switchDB('local');
                            $res->user_ref_id = Yii::app()->session->get('user_id');
                            $res->save(false);

                            $this->_switchDB('prodDb');
                            $childRecords = StudentEducationDetail::model()->findAllByAttributes(array('student_education_ref_id'=> Yii::app()->session->get('edu_id')));
                            if(count($childRecords)) {
                                foreach($childRecords as $k => $childRecord) {
                                    $childRes = new StudentEducationDetail('search');
                                    unset($childRecord->{$childRecord->tableSchema->primaryKey});
                                    $childRes->attributes = $childRecord->attributes;
                                    $this->_switchDB('local');
                                    $childRes->student_education_ref_id = $res->student_education_id;
                                    $childRes->save(false);
                                }
                            }

                            $this->_switchDB('prodDb');
                            $childRecords = StudentGradeCount::model()->findAllByAttributes(array('student_education_ref_id'=> Yii::app()->session->get('edu_id')));
                            if(count($childRecords)) {
                                foreach($childRecords as $k => $childRecord) {
                                    $childRes = new StudentGradeCount('search');
                                    unset($childRecord->{$childRecord->tableSchema->primaryKey});
                                    $childRes->attributes = $childRecord->attributes;
                                    $this->_switchDB('local');
                                    $childRes->student_education_ref_id = $res->student_education_id;
                                    $childRes->save(false);
                                }
                            }
                        }
                    }
                }

                else if(in_array($table->table_name, array('courses')) ) {
                    $sql = "SELECT spd.course_ref_id, preferred_department_id, spd.main_dept_ref_id,spd.sub_dept_ref_id FROM student_preferred_department spd LEFT JOIN courses c ON c.course_id = spd.course_ref_id WHERE user_ref_id = '".$student->user_id."' AND course_ref_id IS NOT NULL";
					$this->_switchDB('prodDb');
                    $courses = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
                    foreach($courses as $k => $record) {
                        $this->_switchDB('prodDb');
                        $courseRes = Courses::model()->findByAttributes(array('course_id'=> $record->course_ref_id));
                        if($courseRes) {
                            $this->_switchDB('local');
                            $res = new Courses('search');
                            $res->attributes = $courseRes->attributes;
                            $primaryKey = $res->tableSchema->primaryKey;
                            unset($res->$primaryKey);
                            $res->save(false);
                            $childRecord = StudentPreferredDepartment::model()->findByAttributes(array('user_ref_id' => Yii::app()->session->get('user_id'), 'main_dept_ref_id'=> $record->main_dept_ref_id,'sub_dept_ref_id'=> $record->sub_dept_ref_id));
                            if($childRecord){
                                if($res->course_id){
                                    $childRecord->course_ref_id = $res->course_id;
                                    $childRecord->save(false);
                                }
                            }
                        }
                    }
                }
                else if(in_array($table->table_name, array('tbl_university_master')) ) {
                    $sql = "SELECT uni_name,uni_id,user_ref_id FROM `student_shortlist_university` spu
                            INNER JOIN tbl_university_master um ON um.uni_id = spu.uni_ref_id
                            WHERE user_ref_id = '".$student->user_id."' AND  is_user_entered='1' ";
					$this->_switchDB('prodDb');
                    $universities = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
                    if($universities) {
                        foreach($universities as $k => $record) {
                            $this->_switchDB('prodDb');
                            $uniData = TblUniversityMaster::model()->findByPk($record->uni_id);
                            $this->_switchDB('local');
                            $universityRes = TblUniversityMaster::model()->findByAttributes(array('uni_name'=>$record->uni_name));
                            if(count($universityRes)<1){
                                $universityRes = new TblUniversityMaster('search');
                                $universityRes->attributes = $uniData->attributes;
                                $universityRes->uni_name = $uniData->uni_name;
                                unset($universityRes->{$universityRes->tableSchema->primaryKey});
                                $universityRes->save(false);
                            }
                            $uniRes = StudentShortlistUniversity::model()->findByAttributes(array('user_ref_id'=> Yii::app()->session->get('user_id'),'uni_ref_id'=>$record->uni_id));
                            if($uniRes) {
                                $uniRes->uni_ref_id = $universityRes->uni_id;
                                $uniRes->save(false);
                            }
                            $uniAdmission = StudentOutplacementUniversity::model()->findByAttributes(array('user_ref_id'=> Yii::app()->session->get('user_id'),'uni_ref_id'=>$record->uni_id));
                            if($uniAdmission) {
                                $uniAdmission->uni_ref_id = $universityRes->uni_id;
                                $uniAdmission->save(false);
                            }
                        }
                    }
                }
            }
        }
        /*$this->_switchDB('local');
        $userModel = TblUserMaster::model()->findByAttributes(array('user_id' => Yii::app()->session->get('user_id')));
        $userModel->local_sync_by = $this->f2fLoginId;
        $userModel->save(false);*/

        $this->_switchDB('prodDb');
        $userModel = TblUserMaster::model()->findByAttributes(array('user_id' => $student->user_id));
        if ($userModel) {
            $userModel->local_sync_by = $this->f2fLoginId;
            $userModel->save(false);
        }
    }

    private function deleteExistRecords($student, $localUser=false)
    {
        $sql = "SELECT * FROM narnia_prod_to_local_tables WHERE is_active='Y' AND table_name NOT IN ('tbl_si_di','rbac_authassignment','tbl_user_prof_critical_completion','student_grade_count','student_education_detail','user_entrance_exam_module','student_preferred_location','login_master','tbl_user_master') ORDER BY dependency_order DESC";
		$this->_switchDB('local');
        $tables = CActiveRecord::$db->createCommand($sql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();
        foreach ($tables as $k => $table) {
            $className = $table->class_name;
            $col_name = $table->column_name;

            $this->_switchDB('local');
            if(in_array($table->column_name, array('user_ref_id','student_ref_id'))){
                $col_name = 'user_id';
            }

            $criteria = new CDbCriteria;
            $criteria->addCondition("$table->column_name = '".$localUser->{$col_name}."' ");
            $criteria->order = "{$table->date_column} DESC";
            $localDate = $className::model()->find($criteria)->{$table->date_column};

            $this->_switchDB('prodDb');
            $criteriaProd = new CDbCriteria;
            $criteriaProd->addCondition("$table->column_name = '".$student->{$table->code_column}."' ");
            $criteriaProd->order = "{$table->date_column} DESC";
            $prodDate = $className::model()->find($criteriaProd)->{$table->date_column};
            if($table->delete_column){
                $deleteDate = OfflineDeleteRecordLog::model()->findByAttributes(array('user_ref_id'=>$student->{$table->code_column}));
            }

            //if($prodDate > $localDate || !$prodDate || !$localDate){
            if($prodDate > $localDate){
                $this->_switchDB('local');
                $className::model()->deleteAll($criteria);
                $deletedTables[] = $className;
            }
            else if($table->delete_column){
                if($deleteDate && ($deleteDate->{$table->delete_column} > $localDate) ){
                    $this->_switchDB('local');
                    $className::model()->deleteAll($criteria);
                    $deletedTables[] = $className;
                }
            }
            //echo '<pre>'; print_r($deletedTables); //die;
        }
        if(count($deletedTables)){
            $this->tablesSync($student, $deletedTables);
        }
    }

    private function _syncF2FTable(){
        //$f2fID = Yii::app()->getRequest()->getParam('f2f', 0);
        $f2fID = $this->f2fID;

        $this->_switchDB('prodDb');
        $f2fData = OfflineF2fCounsellor::model()->findAllByAttributes(array('f2f_counsellor'=>$f2fID));
        foreach ($f2fData as $f2f) {

            $this->_switchDB('local');
            $f2fModel = new OfflineF2fCounsellor();
            $f2fModel->attributes = $f2f->attributes;
            $f2fModel->last_sync = date('Y-m-d H:i:s');
            $f2fModel->save(false);
        }
        $this->_log("F2F counsellor table data imported");

        $adminModel = TblAdmin::model()->findByPk($f2fID);
        $adminModel->offline_sync_completed = 'Y';
        $adminModel->save(false);
    }

    private function _offlineDataUpdate($f2fAdminId){
        $this->_switchDB('prodDb');
        $f2fData = OfflineF2fCounsellor::model()->findAllByAttributes(array('f2f_counsellor'=>$f2fAdminId));
        if($f2fData){
            foreach ($f2fData as $f2f) {
                $this->_switchDB('local');
                $checkF2F = OfflineF2fCounsellor::model()->findByAttributes(array('f2f_counsellor'=>$f2f->f2f_counsellor,'inst_ref_id'=>$f2f->inst_ref_id));
                $counsellorData = OfflineF2fCounsellor::model()->findByAttributes(array('f2f_counsellor'=>$f2f->f2f_counsellor,'inst_ref_id'=>$f2f->inst_ref_id));
                if(!$checkF2F){
                    $f2fModel = new OfflineF2fCounsellor();
                    $f2fModel->attributes = $f2f->attributes;
                    unset($f2fModel->{$f2fModel->tableSchema->primaryKey});
                    $f2fModel->save(false);
                    if($f2fModel->inst_ref_id){
                        $exists = TblSiDi::model()->exists("inst_id = ".$f2fModel->inst_ref_id." ");
                        if(!$exists){
                            $this->_switchDB('prodDb');
                            $siData = TblSiDi::model()->findByPk($f2fModel->inst_ref_id);
                            $this->_switchDB('local');
                            $siModel = new TblSiDi('search');
                            $siModel->attributes = $siData->attributes;
                            $siModel->save(false);
                            if($siModel->school_ref_id){
                                $this->_switchDB('prodDb');
                                $schoolData = LookupSchool::model()->findByPk($siModel->school_ref_id);
                                $this->_switchDB('local');
                                $schoolModel = new LookupSchool('search');
                                unset($schoolData->{$schoolData->tableSchema->primaryKey});
                                $schoolModel->attributes = $schoolData->attributes;
                                $schoolModel->save(false);
                                $si = TblSiDi::model()->findByPk($f2fModel->inst_ref_id);
                                $si->school_ref_id = $schoolModel->school_id;
                                $si->save(false);
                                $checkBoards = TblSiBoard::model()->exists("si_ref_id = ".$f2fModel->inst_ref_id." ");
                                if(!$checkBoards){
                                    $this->_switchDB('prodDb');
                                    $boardData = TblSiBoard::model()->findAllByAttributes(array('si_ref_id'=>$f2fModel->inst_ref_id));
                                    foreach($boardData as $board){
                                        $this->_switchDB('local');
                                        $boardModel = new TblSiBoard('search');
                                        unset($board->{$board->tableSchema->primaryKey});
                                        $boardModel->attributes = $board->attributes;
                                        $boardModel->save(false);
                                    }
                                }
                            }
                        }
                    }
                } else {
                    //unset($f2f->last_sync);
                    $checkF2F->attributes = $f2f->attributes;
                    unset($checkF2F->{$checkF2F->tableSchema->primaryKey});
                    $checkF2F->last_sync = $counsellorData->last_sync;
                    $checkF2F->save(false);
                }
            }
        } else {
			$this->_switchDB('local');
            CActiveRecord::$db->createCommand('TRUNCATE offline_f2f_counsellor')->execute();
        }
        $this->_switchDB('local');
        $f2fData = OfflineF2fCounsellor::model()->findAllByAttributes(array('f2f_counsellor'=>$f2fAdminId));
        foreach ($f2fData as $f2f) {
            $this->_switchDB('prodDb');
            $prodData = OfflineF2fCounsellor::model()->findByAttributes(array('inst_ref_id'=>$f2f->inst_ref_id,'f2f_counsellor'=>$f2fAdminId));
            if(!$prodData){
                $this->_switchDB('local');
                CActiveRecord::$db->createCommand("DELETE FROM offline_f2f_counsellor WHERE inst_ref_id = ".$f2f->inst_ref_id." AND f2f_counsellor = ".$f2f->f2f_counsellor." ")->execute();
            }
        }
        $this->_log("F2F counsellor table data updated");
    }


    public function _updateUserMasterData($student)
    {
        $userSql = "SELECT user_id, login_ref_id, username FROM tbl_user_master um
                        JOIN login_master lm ON lm.login_id = um.login_ref_id
                        WHERE username = '".$student->username."' ";
		$this->_switchDB('local');
        $localUser = CActiveRecord::$db->createCommand($userSql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
        Yii::app()->session->add('user_id', $localUser->user_id);
        Yii::app()->session->add('login_id', $localUser->login_ref_id);
        $this->_switchDB('prodDb');
        $prodUser = TblUserMaster::model()->findByAttributes(array('user_id' => $student->user_id));
        $this->_switchDB('local');
        $localUser = TblUserMaster::model()->findByAttributes(array('user_id' => $localUser->user_id));
        if($prodUser->modified_on > $localUser->modified_on){
            $localUser->attributes = $prodUser->attributes;
            $localUser->user_id = Yii::app()->session->get('user_id');
            $localUser->login_ref_id = Yii::app()->session->get('login_id');
            $localUser->save(false);
        }
    }

    public function actionNewSchoolSync(){
        $f2fAdminId = Yii::app()->request->getParam('f2fAdmin');

        $this->_offlineDataUpdate($f2fAdminId);
        setFlashMessage('success_notify', 'globalnotifications.notification_geniric', ['MESSAGE' => 'New school sync is done.']);
        $this->redirect(array('/fcfcounsellor'));
    }

}
